/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.support.elasticsearch;

import io.committed.invest.core.dto.analytic.GeoBox;
import io.committed.invest.core.dto.analytic.GeoRadius;
import io.committed.invest.core.dto.analytic.TimeRange;
import io.committed.invest.support.elasticsearch.BooleanQueriesUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.query.GeoBoundingBoxQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;

public class QueryUtils {
    public QueryBuilder createGetByIdQuery(String type, String id) {
        return BooleanQueriesUtil.andQueries(new QueryBuilder[]{QueryBuilders.termQuery((String)"_id", (String)id), QueryBuilders.termQuery((String)"type", (String)type)});
    }

    public QueryBuilder createOrTermQuery(String field, Collection<String> terms) {
        List<QueryBuilder> typeQueries = terms.stream().map(s -> QueryBuilders.termQuery((String)field, (String)s)).collect(Collectors.toList());
        return BooleanQueriesUtil.orQueries(typeQueries);
    }

    public GeoBoundingBoxQueryBuilder createBoundingBoxQuery(String field, GeoBox box) {
        return QueryBuilders.geoBoundingBoxQuery((String)field).setCorners(box.getSafeN(), box.getSafeW(), box.getSafeS(), box.getSafeE()).type("indexed");
    }

    public QueryStringQueryBuilder createQueryString(String defaultField, String query) {
        return QueryBuilders.queryStringQuery((String)query).defaultField(defaultField);
    }

    public QueryBuilder createRadiusQuery(String field, GeoRadius geoRadius) {
        return QueryBuilders.geoDistanceQuery((String)field).point(geoRadius.getLat().doubleValue(), geoRadius.getLon().doubleValue()).distance(geoRadius.getRadius().doubleValue(), DistanceUnit.METERS);
    }

    public QueryBuilder createTimeRangeQuery(String field, TimeRange range) {
        RangeQueryBuilder query = QueryBuilders.rangeQuery((String)field);
        if (range != null) {
            if (range.getStart() != null) {
                query = query.gte((Object)range.getStart());
            }
            if (range.getEnd() != null) {
                query = query.lte((Object)range.getEnd());
            }
        }
        return query;
    }
}

