/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.support.elasticsearch;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public final class BooleanQueriesUtil {
    public static QueryBuilder andQueries(List<QueryBuilder> queries) {
        if (queries.size() == 1) {
            return queries.get(0);
        }
        BoolQueryBuilder andQuery = QueryBuilders.boolQuery();
        for (QueryBuilder qb : queries) {
            if (qb == null) continue;
            andQuery = andQuery.must(qb);
        }
        return andQuery;
    }

    public static QueryBuilder andQueries(QueryBuilder ... queries) {
        return BooleanQueriesUtil.andQueries(Arrays.asList(queries));
    }

    public static QueryBuilder notQuery(QueryBuilder query) {
        BoolQueryBuilder notQuery = QueryBuilders.boolQuery();
        return notQuery.mustNot(query);
    }

    public static QueryBuilder orQueries(List<QueryBuilder> queries) {
        if (queries.size() == 1) {
            return queries.get(0);
        }
        BoolQueryBuilder andQuery = QueryBuilders.boolQuery();
        for (QueryBuilder qb : queries) {
            if (qb == null) continue;
            andQuery = andQuery.should(qb);
        }
        return andQuery;
    }

    public static QueryBuilder orQueries(QueryBuilder ... queries) {
        return BooleanQueriesUtil.orQueries(Arrays.asList(queries));
    }

    private BooleanQueriesUtil() {
    }
}

