/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.support.elasticsearch;

import io.committed.invest.core.dto.constants.TimeInterval;
import io.committed.invest.support.elasticsearch.TimeIntervalUtils;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoGridAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGrid;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;

public class AggregiationQueryUtils {
    public static final int MIN_GEOHASH_PRECISION = 1;
    public static final int MAX_GEOHASH_PRECISION = 20;

    public Map<String, Long> convertGeohashAggregationToMap(SearchResponse r, String aggregationName) {
        GeoHashGrid agg = (GeoHashGrid)r.getAggregations().get(aggregationName);
        return agg.getBuckets().stream().collect(Collectors.toMap(MultiBucketsAggregation.Bucket::getKeyAsString, MultiBucketsAggregation.Bucket::getDocCount));
    }

    public Map<String, Long> convertTermsAggregationToMap(SearchResponse r, String aggregationName) {
        Terms terms = (Terms)r.getAggregations().get(aggregationName);
        return terms.getBuckets().stream().collect(Collectors.toMap(MultiBucketsAggregation.Bucket::getKeyAsString, MultiBucketsAggregation.Bucket::getDocCount));
    }

    public Map<String, Long> convertTimelineAggregationToMap(SearchResponse r, String aggregationName) {
        Histogram agg = (Histogram)r.getAggregations().get(aggregationName);
        return agg.getBuckets().stream().sorted((b1, b2) -> b1.getKeyAsString().compareTo(b2.getKeyAsString())).collect(Collectors.toMap(MultiBucketsAggregation.Bucket::getKeyAsString, MultiBucketsAggregation.Bucket::getDocCount, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, TreeMap::new));
    }

    public GeoGridAggregationBuilder createGeohashAggregation(String field, int precision, int size) {
        GeoGridAggregationBuilder builder = ((GeoGridAggregationBuilder)AggregationBuilders.geohashGrid((String)field).field(field)).precision(Math.max(Math.min(precision, 20), 1));
        builder.size(size > 0 ? size : 0);
        return builder;
    }

    public TermsAggregationBuilder createTermAggregation(String field, int size) {
        TermsAggregationBuilder builder = (TermsAggregationBuilder)AggregationBuilders.terms((String)field).field(field);
        builder.size(size > 0 ? size : 0);
        return builder;
    }

    public DateHistogramAggregationBuilder createTimelineAggregation(String field, TimeInterval interval) {
        return ((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)field).field(field)).dateHistogramInterval(TimeIntervalUtils.toDateHistogram(interval));
    }
}

