/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.core.utils;

import io.committed.invest.core.dto.analytic.GeoBox;

public final class GeoUtil {
    private static final double WGS84_a = 6378137.0;
    private static final double WGS84_b = 6356752.3;

    public static GeoBox createBoundingBox(double latitudeInDegrees, double longitudeInDegrees, double halfSideInMeters) {
        double lat = Math.toRadians(latitudeInDegrees);
        double lon = Math.toRadians(longitudeInDegrees);
        double halfSide = halfSideInMeters;
        double radius = GeoUtil.calculateWGS84EarthRadius(lat);
        double pradius = radius * Math.cos(lat);
        double latMin = Math.toDegrees(lat - halfSide / radius);
        double latMax = Math.toDegrees(lat + halfSide / radius);
        double lonMin = Math.toDegrees(lon - halfSide / pradius);
        double lonMax = Math.toDegrees(lon + halfSide / pradius);
        return new GeoBox(latMax, lonMax, latMin, lonMin);
    }

    private static double calculateWGS84EarthRadius(double lat) {
        double An = 4.0680631590769E13 * Math.cos(lat);
        double Bn = 4.040829980355529E13 * Math.sin(lat);
        double Ad = 6378137.0 * Math.cos(lat);
        double Bd = 6356752.3 * Math.sin(lat);
        return Math.sqrt((An * An + Bn * Bn) / (Ad * Ad + Bd * Bd));
    }

    private GeoUtil() {
    }
}

