/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.core.dto.graph;

import io.committed.invest.core.dto.graph.Edge;
import io.committed.invest.core.dto.graph.Graph;
import io.committed.invest.core.dto.graph.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphBuilder {
    private static final Logger log = LoggerFactory.getLogger(GraphBuilder.class);
    private final Map<Long, Node> nodes = new HashMap<Long, Node>();
    private final Map<Long, Edge> idEdges = new HashMap<Long, Edge>();
    private final Collection<Edge> edges = new ArrayList<Edge>();

    public void addEdge(Edge edge) {
        if (edge.getId() != 0L) {
            this.idEdges.putIfAbsent(edge.getId(), edge);
        } else {
            this.edges.add(edge);
        }
    }

    public void addNode(Node node) {
        this.nodes.putIfAbsent(node.getId(), node);
    }

    public Graph build() {
        this.edges.addAll(this.idEdges.values());
        return new Graph(this.nodes.values(), this.edges);
    }

    public Collection<Node> getNodes() {
        return this.nodes.values();
    }
}

