/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.core.dto.graph;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.committed.invest.core.dto.graph.Edge;
import io.committed.invest.core.dto.graph.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Graph {
    private static Graph EMPTY = new Graph();
    @JsonProperty(value="nodes")
    private List<Node> nodes;
    @JsonProperty(value="edges")
    private List<Edge> edges;

    public static Graph empty() {
        return EMPTY;
    }

    public static Graph singleton(Node node) {
        return new Graph(Collections.singleton(node), Collections.emptyList());
    }

    public Graph(Collection<Node> nodes, Collection<Edge> edges) {
        this.nodes = new ArrayList<Node>(nodes);
        this.edges = new ArrayList<Edge>(edges);
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public void setNodes(List<Node> nodes) {
        this.nodes = nodes;
    }

    public void setEdges(List<Edge> edges) {
        this.edges = edges;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Graph)) {
            return false;
        }
        Graph other = (Graph)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Node> this$nodes = this.getNodes();
        List<Node> other$nodes = other.getNodes();
        if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
            return false;
        }
        List<Edge> this$edges = this.getEdges();
        List<Edge> other$edges = other.getEdges();
        return !(this$edges == null ? other$edges != null : !((Object)this$edges).equals(other$edges));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Graph;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Node> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        List<Edge> $edges = this.getEdges();
        result = result * 59 + ($edges == null ? 43 : ((Object)$edges).hashCode());
        return result;
    }

    public String toString() {
        return "Graph(nodes=" + this.getNodes() + ", edges=" + this.getEdges() + ")";
    }

    public Graph() {
    }

    static {
        EMPTY.setEdges(Collections.emptyList());
        EMPTY.setNodes(Collections.emptyList());
    }
}

