/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.core.dto.analytic;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;

public class TimeRange {
    @JsonProperty(value="start")
    private Date start;
    @JsonProperty(value="end")
    private Date end;

    @JsonCreator
    public TimeRange(@JsonProperty(value="start") Date start, @JsonProperty(value="end") Date end) {
        if (start != null && end != null) {
            if (start.before(end)) {
                this.start = start;
                this.end = end;
            } else {
                this.start = end;
                this.end = start;
            }
        } else {
            this.start = start;
            this.end = end;
        }
    }

    @JsonIgnore
    public long getDuration() {
        if (this.end != null && this.start != null) {
            return this.end.getTime() - this.start.getTime();
        }
        return 0L;
    }

    @JsonIgnore
    public boolean isValid() {
        return this.start != null && this.end != null;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeRange)) {
            return false;
        }
        TimeRange other = (TimeRange)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Date this$start = this.getStart();
        Date other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        Date this$end = this.getEnd();
        Date other$end = other.getEnd();
        return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TimeRange;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Date $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        Date $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        return result;
    }

    public String toString() {
        return "TimeRange(start=" + this.getStart() + ", end=" + this.getEnd() + ")";
    }

    public TimeRange() {
    }
}

