/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.core.dto.analytic;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class TemporalHeatmap {
    @JsonProperty(value="x")
    private final String[] xAxis;
    @JsonProperty(value="y")
    private final String[] yAxis;
    private final List<List<Long>> bins = new ArrayList<List<Long>>();

    public TemporalHeatmap(String[] xAxis, String[] yAxis) {
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        for (String i : xAxis) {
            ArrayList<Long> day = new ArrayList<Long>();
            for (String j : yAxis) {
                day.add(0L);
            }
            this.bins.add(day);
        }
    }

    public void add(int x, int y) {
        this.add(x, y, 1L);
    }

    public void add(int x, int y, long value) {
        List<Long> b = this.bins.get(x);
        b.set(y, b.get(y) + value);
    }

    public String[] getXAxis() {
        return this.xAxis;
    }

    public String[] getYAxis() {
        return this.yAxis;
    }

    public List<List<Long>> getBins() {
        return this.bins;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemporalHeatmap)) {
            return false;
        }
        TemporalHeatmap other = (TemporalHeatmap)o;
        if (!Arrays.deepEquals(this.getXAxis(), other.getXAxis())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getYAxis(), other.getYAxis())) {
            return false;
        }
        List<List<Long>> this$bins = this.getBins();
        List<List<Long>> other$bins = other.getBins();
        return !(this$bins == null ? other$bins != null : !((Object)this$bins).equals(other$bins));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getXAxis());
        result = result * 59 + Arrays.deepHashCode(this.getYAxis());
        List<List<Long>> $bins = this.getBins();
        result = result * 59 + ($bins == null ? 43 : ((Object)$bins).hashCode());
        return result;
    }

    public String toString() {
        return "TemporalHeatmap(xAxis=" + Arrays.deepToString(this.getXAxis()) + ", yAxis=" + Arrays.deepToString(this.getYAxis()) + ", bins=" + this.getBins() + ")";
    }
}

