/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.core.dto.analytic;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.committed.invest.core.dto.analytic.GeoBox;
import io.committed.invest.core.utils.GeoUtil;
import java.beans.ConstructorProperties;

public class GeoRadius {
    @JsonProperty(value="lat")
    private Double lat;
    @JsonProperty(value="lon")
    private Double lon;
    @JsonProperty(value="radius")
    private Double radius;

    public GeoBox convertToBox() {
        if (!this.isValid()) {
            return new GeoBox(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        }
        return GeoUtil.createBoundingBox(this.getLat(), this.getLon(), this.getRadius());
    }

    @JsonIgnore
    public boolean isValid() {
        return Double.isFinite(this.lat) && Double.isFinite(this.lon) && -180.0 <= this.lon && this.lon <= 180.0 && -90.0 <= this.lat && this.lat <= 90.0 && 0.0 <= this.radius;
    }

    public Double getLat() {
        return this.lat;
    }

    public Double getLon() {
        return this.lon;
    }

    public Double getRadius() {
        return this.radius;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    public void setRadius(Double radius) {
        this.radius = radius;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeoRadius)) {
            return false;
        }
        GeoRadius other = (GeoRadius)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$lat = this.getLat();
        Double other$lat = other.getLat();
        if (this$lat == null ? other$lat != null : !((Object)this$lat).equals(other$lat)) {
            return false;
        }
        Double this$lon = this.getLon();
        Double other$lon = other.getLon();
        if (this$lon == null ? other$lon != null : !((Object)this$lon).equals(other$lon)) {
            return false;
        }
        Double this$radius = this.getRadius();
        Double other$radius = other.getRadius();
        return !(this$radius == null ? other$radius != null : !((Object)this$radius).equals(other$radius));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeoRadius;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $lat = this.getLat();
        result = result * 59 + ($lat == null ? 43 : ((Object)$lat).hashCode());
        Double $lon = this.getLon();
        result = result * 59 + ($lon == null ? 43 : ((Object)$lon).hashCode());
        Double $radius = this.getRadius();
        result = result * 59 + ($radius == null ? 43 : ((Object)$radius).hashCode());
        return result;
    }

    public String toString() {
        return "GeoRadius(lat=" + this.getLat() + ", lon=" + this.getLon() + ", radius=" + this.getRadius() + ")";
    }

    @ConstructorProperties(value={"lat", "lon", "radius"})
    public GeoRadius(Double lat, Double lon, Double radius) {
        this.lat = lat;
        this.lon = lon;
        this.radius = radius;
    }

    public GeoRadius() {
    }
}

