/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.core.dto.analytic;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;

public class GeoLocation {
    public static final GeoLocation INVALID = new GeoLocation(Double.NaN, Double.NaN);
    @JsonProperty(value="lat")
    private double lat;
    @JsonProperty(value="lon")
    private double lon;
    @JsonProperty(value="acc")
    private double acc;

    public GeoLocation(double lat2, double lon2) {
        this.lat = lat2;
        this.lon = lon2;
    }

    @JsonIgnore
    public boolean isValidLocation() {
        return Double.isFinite(this.lat) && Double.isFinite(this.lon) && -180.0 <= this.lon && this.lon <= 180.0 && -90.0 <= this.lat && this.lat <= 90.0;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public double getAcc() {
        return this.acc;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public void setLon(double lon) {
        this.lon = lon;
    }

    public void setAcc(double acc) {
        this.acc = acc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeoLocation)) {
            return false;
        }
        GeoLocation other = (GeoLocation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLat(), other.getLat()) != 0) {
            return false;
        }
        if (Double.compare(this.getLon(), other.getLon()) != 0) {
            return false;
        }
        return Double.compare(this.getAcc(), other.getAcc()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeoLocation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lat = Double.doubleToLongBits(this.getLat());
        result = result * 59 + (int)($lat >>> 32 ^ $lat);
        long $lon = Double.doubleToLongBits(this.getLon());
        result = result * 59 + (int)($lon >>> 32 ^ $lon);
        long $acc = Double.doubleToLongBits(this.getAcc());
        result = result * 59 + (int)($acc >>> 32 ^ $acc);
        return result;
    }

    public String toString() {
        return "GeoLocation(lat=" + this.getLat() + ", lon=" + this.getLon() + ", acc=" + this.getAcc() + ")";
    }

    @ConstructorProperties(value={"lat", "lon", "acc"})
    public GeoLocation(double lat, double lon, double acc) {
        this.lat = lat;
        this.lon = lon;
        this.acc = acc;
    }

    public GeoLocation() {
    }
}

