/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.core.dto.analytic;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class GeoBox {
    public static final GeoBox GLOBE = new GeoBox(90.0, -180.0, -90.0, 180.0);
    @JsonProperty(value="n")
    private Double n;
    @JsonProperty(value="e")
    private Double e;
    @JsonProperty(value="s")
    private Double s;
    @JsonProperty(value="w")
    private Double w;

    @JsonCreator
    public GeoBox(@JsonProperty(value="n") Double n, @JsonProperty(value="e") Double e, @JsonProperty(value="s") Double s, @JsonProperty(value="w") Double w) {
        if (n != null && s != null) {
            this.n = Math.max(n, s);
            this.s = Math.min(n, s);
        } else {
            this.n = n;
            this.s = s;
        }
        if (e != null && w != null) {
            this.e = Math.max(e, w);
            this.w = Math.min(e, w);
        } else {
            this.e = e;
            this.w = w;
        }
    }

    @JsonIgnore
    public double getSafeN() {
        return this.getN() == null ? 180.0 : this.getN();
    }

    @JsonIgnore
    public double getSafeS() {
        return this.getS() == null ? 180.0 : this.getS();
    }

    @JsonIgnore
    public double getSafeE() {
        return this.getE() == null ? 180.0 : this.getE();
    }

    @JsonIgnore
    public double getSafeW() {
        return this.getW() == null ? 180.0 : this.getW();
    }

    public boolean contains(double lat, double lon) {
        return this.s <= lat && lat <= this.n && this.w <= lon && lon <= this.e;
    }

    @JsonIgnore
    public boolean isValid() {
        return this.n != null && this.s != null && this.e != null && this.w != null && -180.0 <= this.e && this.e <= 180.0 && -180.0 <= this.w && this.w <= 180.0 && -90.0 <= this.n && this.n <= 90.0 && -90.0 <= this.s && this.s <= 90.0;
    }

    public GeoBox intersection(GeoBox geobox) {
        return new GeoBox(GeoBox.minOrSet(this.n, geobox.getN()), GeoBox.minOrSet(this.e, geobox.getE()), GeoBox.maxOrSet(this.s, geobox.getS()), GeoBox.maxOrSet(this.w, geobox.getW()));
    }

    private static Double minOrSet(Double d1, Double d2) {
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        return Math.min(d1, d2);
    }

    private static Double maxOrSet(Double d1, Double d2) {
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        return Math.max(d1, d2);
    }

    public Double getN() {
        return this.n;
    }

    public Double getE() {
        return this.e;
    }

    public Double getS() {
        return this.s;
    }

    public Double getW() {
        return this.w;
    }

    public void setN(Double n) {
        this.n = n;
    }

    public void setE(Double e) {
        this.e = e;
    }

    public void setS(Double s) {
        this.s = s;
    }

    public void setW(Double w) {
        this.w = w;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeoBox)) {
            return false;
        }
        GeoBox other = (GeoBox)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$n = this.getN();
        Double other$n = other.getN();
        if (this$n == null ? other$n != null : !((Object)this$n).equals(other$n)) {
            return false;
        }
        Double this$e = this.getE();
        Double other$e = other.getE();
        if (this$e == null ? other$e != null : !((Object)this$e).equals(other$e)) {
            return false;
        }
        Double this$s = this.getS();
        Double other$s = other.getS();
        if (this$s == null ? other$s != null : !((Object)this$s).equals(other$s)) {
            return false;
        }
        Double this$w = this.getW();
        Double other$w = other.getW();
        return !(this$w == null ? other$w != null : !((Object)this$w).equals(other$w));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeoBox;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $n = this.getN();
        result = result * 59 + ($n == null ? 43 : ((Object)$n).hashCode());
        Double $e = this.getE();
        result = result * 59 + ($e == null ? 43 : ((Object)$e).hashCode());
        Double $s = this.getS();
        result = result * 59 + ($s == null ? 43 : ((Object)$s).hashCode());
        Double $w = this.getW();
        result = result * 59 + ($w == null ? 43 : ((Object)$w).hashCode());
        return result;
    }

    public String toString() {
        return "GeoBox(n=" + this.getN() + ", e=" + this.getE() + ", s=" + this.getS() + ", w=" + this.getW() + ")";
    }

    public GeoBox() {
    }
}

