/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.worker.execution.model;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class SandboxExecutionRunnable<T>
implements Runnable {
    private final ClassLoader classLoader;
    private final AtomicReference<Pair<T, RuntimeException>> bundle;
    private final Callable<T> callable;

    public SandboxExecutionRunnable(ClassLoader classLoader, Callable<T> callable) {
        this.classLoader = classLoader;
        this.bundle = new AtomicReference();
        this.callable = callable;
    }

    @Override
    public void run() {
        Object processingResult = null;
        RuntimeException processingException = null;
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            processingResult = this.callable.call();
        }
        catch (RuntimeException re) {
            processingException = re;
        }
        catch (Exception exception) {
            processingException = new RuntimeException(exception);
        }
        this.bundle.set((Pair<T, RuntimeException>)new ImmutablePair(processingResult, (Object)processingException));
    }
}

