/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.worker.execution.reflection;

import io.cloudslang.score.api.ControlActionMetadata;
import io.cloudslang.score.exceptions.FlowExecutionException;
import io.cloudslang.score.lang.ExecutionRuntimeServices;
import io.cloudslang.worker.execution.reflection.ReflectionAdapter;
import io.cloudslang.worker.execution.services.SessionDataHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;

public class ReflectionAdapterImpl
implements ReflectionAdapter,
ApplicationContextAware {
    private static final Logger logger = Logger.getLogger(ReflectionAdapterImpl.class);
    @Autowired
    private SessionDataHandler sessionDataHandler;
    private ApplicationContext applicationContext;
    private Map<String, Object> cacheBeans = new ConcurrentHashMap<String, Object>();
    private Map<String, Method> cacheMethods = new ConcurrentHashMap<String, Method>();
    private ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private Map<String, String[]> cacheParamNames = new ConcurrentHashMap<String, String[]>();

    private static Long getExecutionIdFromActionData(Map<String, ?> actionData) {
        ExecutionRuntimeServices executionRuntimeServices = (ExecutionRuntimeServices)actionData.get("executionRuntimeServices");
        if (executionRuntimeServices != null) {
            return executionRuntimeServices.getExecutionId();
        }
        return null;
    }

    private static Long getRunningExecutionIdFromActionData(Map<String, ?> actionData) {
        ExecutionRuntimeServices executionRuntimeServices = (ExecutionRuntimeServices)actionData.get("executionRuntimeServices");
        if (executionRuntimeServices != null) {
            return executionRuntimeServices.getParentRunningId();
        }
        return ReflectionAdapterImpl.getExecutionIdFromActionData(actionData);
    }

    private static String getExceptionMessage(ControlActionMetadata actionMetadata) {
        return "Failed to run the action! Class: " + actionMetadata.getClassName() + ", method: " + actionMetadata.getMethodName();
    }

    public Object executeControlAction(ControlActionMetadata actionMetadata, Map<String, ?> actionData) {
        Validate.notNull((Object)actionMetadata, (String)"Action metadata is null");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing control action [" + actionMetadata.getClassName() + '.' + actionMetadata.getMethodName() + ']'));
        }
        try {
            Object actionBean = this.getActionBean(actionMetadata);
            Method actionMethod = this.getActionMethod(actionMetadata);
            Object[] arguments = this.buildParametersArray(actionMethod, actionData);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Invoking...");
            }
            Object result = actionMethod.invoke(actionBean, arguments);
            this.clearStateAfterInvocation(actionData);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Control action [" + actionMetadata.getClassName() + '.' + actionMetadata.getMethodName() + "] done"));
            }
            return result;
        }
        catch (IllegalArgumentException ex) {
            String message = "Failed to run the action! Wrong arguments were passed to class: " + actionMetadata.getClassName() + ", method: " + actionMetadata.getMethodName() + ", reason: " + ex.getMessage();
            throw new FlowExecutionException(message, (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            String message = ex.getTargetException() == null ? ex.getMessage() : ex.getTargetException().getMessage();
            logger.error((Object)(ReflectionAdapterImpl.getExceptionMessage(actionMetadata) + ", reason: " + message), (Throwable)ex);
            throw new FlowExecutionException(message, (Throwable)ex);
        }
        catch (Exception ex) {
            throw new FlowExecutionException(ReflectionAdapterImpl.getExceptionMessage(actionMetadata) + ", reason: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private void clearStateAfterInvocation(Map<String, ?> actionData) {
        Long executionId = ReflectionAdapterImpl.getExecutionIdFromActionData(actionData);
        this.sessionDataHandler.setGlobalSessionDataInactive(executionId);
        this.sessionDataHandler.setSessionDataInactive(executionId, ReflectionAdapterImpl.getRunningExecutionIdFromActionData(actionData));
    }

    private Object getActionBean(ControlActionMetadata actionMetadata) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object bean = this.cacheBeans.get(actionMetadata.getClassName());
        if (bean == null) {
            Class<?> actionClass;
            block6: {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)(actionMetadata.getClassName() + " wasn't found in the beans cache"));
                }
                actionClass = Class.forName(actionMetadata.getClassName());
                try {
                    bean = this.applicationContext.getBean(actionClass);
                }
                catch (Exception ex) {
                    if (!logger.isTraceEnabled()) break block6;
                    logger.trace((Object)ex);
                }
            }
            if (bean == null) {
                bean = actionClass.newInstance();
            }
            this.cacheBeans.put(actionMetadata.getClassName(), bean);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(actionMetadata.getClassName() + " placed in the beans cache"));
            }
        }
        return bean;
    }

    private Method getActionMethod(ControlActionMetadata actionMetadata) throws ClassNotFoundException {
        Method actionMethod = this.cacheMethods.get(actionMetadata.getClassName() + '.' + actionMetadata.getMethodName());
        if (actionMethod == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(actionMetadata.getClassName() + '.' + actionMetadata.getMethodName() + " wasn't found in the methods cache"));
            }
            for (Method method : Class.forName(actionMetadata.getClassName()).getMethods()) {
                if (!method.getName().equals(actionMetadata.getMethodName())) continue;
                actionMethod = method;
                this.cacheMethods.put(actionMetadata.getClassName() + '.' + actionMetadata.getMethodName(), method);
                break;
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)(actionMetadata.getClassName() + '.' + actionMetadata.getMethodName() + " was found in the methods cache"));
        }
        if (actionMethod == null) {
            String errMessage = "Method: " + actionMetadata.getMethodName() + " was not found in class:  " + actionMetadata.getClassName();
            logger.error((Object)errMessage);
            throw new FlowExecutionException(errMessage);
        }
        return actionMethod;
    }

    private Object[] buildParametersArray(Method actionMethod, Map<String, ?> actionData) {
        String actionFullName = actionMethod.getDeclaringClass().getName() + "." + actionMethod.getName();
        String[] paramNames = this.cacheParamNames.get(actionFullName);
        if (paramNames == null) {
            paramNames = this.parameterNameDiscoverer.getParameterNames(actionMethod);
            this.cacheParamNames.put(actionFullName, paramNames);
        }
        ArrayList args = new ArrayList(paramNames.length);
        for (String paramName : paramNames) {
            if ("nonSerializableExecutionData".equals(paramName)) {
                Long executionId = ReflectionAdapterImpl.getExecutionIdFromActionData(actionData);
                Long runningId = ReflectionAdapterImpl.getRunningExecutionIdFromActionData(actionData);
                Map globalSessionsExecutionData = this.sessionDataHandler.getGlobalSessionsExecutionData(executionId);
                Map sessionObjectExecutionData = this.sessionDataHandler.getSessionsExecutionData(executionId, runningId);
                HashMap<String, Map> nonSerializableExecutionData = new HashMap<String, Map>(2);
                nonSerializableExecutionData.put("globalSessionObject", globalSessionsExecutionData);
                nonSerializableExecutionData.put("sessionObject", sessionObjectExecutionData);
                args.add(nonSerializableExecutionData);
                this.sessionDataHandler.setGlobalSessionDataActive(executionId);
                this.sessionDataHandler.setSessionDataActive(executionId, runningId);
                continue;
            }
            if ("execution".equals(paramName)) {
                Object seqExecution = actionData.remove("execution");
                args.add(seqExecution);
                continue;
            }
            Object param = actionData.get(paramName);
            args.add(param);
        }
        return args.toArray(new Object[args.size()]);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

