/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.worker.execution.services;

import io.cloudslang.orchestrator.services.PauseResumeService;
import io.cloudslang.score.api.ExecutionPlan;
import io.cloudslang.score.api.ExecutionStep;
import io.cloudslang.score.api.StartBranchDataContainer;
import io.cloudslang.score.events.EventBus;
import io.cloudslang.score.events.ScoreEvent;
import io.cloudslang.score.facade.entities.Execution;
import io.cloudslang.score.facade.entities.RunningExecutionPlan;
import io.cloudslang.score.facade.execution.ExecutionStatus;
import io.cloudslang.score.facade.execution.ExecutionSummary;
import io.cloudslang.score.facade.execution.PauseReason;
import io.cloudslang.score.lang.SystemContext;
import io.cloudslang.worker.execution.reflection.ReflectionAdapter;
import io.cloudslang.worker.execution.services.ExecutionService;
import io.cloudslang.worker.management.WorkerConfigurationService;
import io.cloudslang.worker.management.services.dbsupport.WorkerDbSupportService;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public final class ExecutionServiceImpl
implements ExecutionService {
    private static final Logger logger = Logger.getLogger(ExecutionServiceImpl.class);
    @Autowired
    private PauseResumeService pauseService;
    @Autowired
    private ReflectionAdapter reflectionAdapter;
    @Autowired
    private WorkerDbSupportService workerDbSupportService;
    @Autowired
    private WorkerConfigurationService workerConfigurationService;
    @Autowired
    private EventBus eventBus;

    public Execution execute(Execution execution) throws InterruptedException {
        try {
            if (this.handleCancelledFlow(execution)) {
                return execution;
            }
            ExecutionStep currStep = this.loadExecutionStep(execution);
            if (!ExecutionServiceImpl.isDebuggerMode((Map<String, Serializable>)execution.getSystemContext()) && this.handlePausedFlow(execution)) {
                return null;
            }
            this.dumpBusEvents(execution);
            this.executeStep(execution, currStep);
            this.navigate(execution, currStep);
            ExecutionServiceImpl.postExecutionSettings(execution);
            if (execution.getSystemContext().isPaused() && this.handlePausedFlowAfterStep(execution)) {
                return null;
            }
            this.dumpBusEvents(execution);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("End of step: " + execution.getPosition() + " in execution id: " + execution.getExecutionId()));
            }
            return execution;
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"Error during execution: ", (Throwable)ex);
            execution.getSystemContext().setStepErrorKey(ex.getMessage());
            execution.getSystemContext().setFlowTerminationType(ExecutionStatus.SYSTEM_FAILURE);
            execution.setPosition(null);
            return execution;
        }
    }

    public List<Execution> executeSplit(Execution execution) throws InterruptedException {
        try {
            ExecutionStep currStep = this.loadExecutionStep(execution);
            if (!ExecutionServiceImpl.isDebuggerMode((Map<String, Serializable>)execution.getSystemContext()) && this.handlePausedFlow(execution)) {
                return null;
            }
            this.dumpBusEvents(execution);
            this.executeStep(execution, currStep);
            this.failFlowIfSplitStepFailed(execution);
            this.dumpBusEvents(execution);
            List newBranches = execution.getSystemContext().removeBranchesData();
            List<Execution> newExecutions = ExecutionServiceImpl.createChildExecutions(execution.getExecutionId(), newBranches);
            this.navigate(execution, currStep);
            this.dumpBusEvents(execution);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("End of step: " + execution.getPosition() + " in execution id: " + execution.getExecutionId()));
            }
            return newExecutions;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception during the split step!", (Throwable)ex);
            throw ex;
        }
    }

    private void failFlowIfSplitStepFailed(Execution execution) throws InterruptedException {
        if (execution.getSystemContext().hasStepErrorKey()) {
            String exception = execution.getSystemContext().getStepErrorKey();
            execution.getSystemContext().setFlowTerminationType(ExecutionStatus.SYSTEM_FAILURE);
            execution.setPosition(null);
            try {
                this.createErrorEvent(exception, "Error occurred during split step ", "STEP_SPLIT_ERROR", execution.getSystemContext());
            }
            catch (RuntimeException eventEx) {
                logger.error((Object)"Failed to create event: ", (Throwable)eventEx);
            }
            throw new RuntimeException(exception);
        }
    }

    private static List<Execution> createChildExecutions(Long executionId, List<StartBranchDataContainer> newBranches) {
        ArrayList<Execution> newExecutions = new ArrayList<Execution>();
        String splitId = UUID.randomUUID().toString();
        for (int i = 0; i < newBranches.size(); ++i) {
            StartBranchDataContainer from = newBranches.get(i);
            Execution to = new Execution(executionId, from.getExecutionPlanId(), from.getStartPosition(), from.getContexts(), (Map)from.getSystemContext());
            to.getSystemContext().setSplitId(splitId);
            to.getSystemContext().setBranchId(splitId + ":" + (i + 1));
            newExecutions.add(to);
        }
        return newExecutions;
    }

    public boolean isSplitStep(Execution execution) {
        ExecutionStep currStep = this.loadExecutionStep(execution);
        return currStep.isSplitStep();
    }

    protected boolean handleCancelledFlow(Execution execution) {
        boolean executionIsCancelled = this.workerConfigurationService.isExecutionCancelled(execution.getExecutionId());
        if (ExecutionStatus.CANCELED.equals((Object)execution.getSystemContext().getFlowTerminationType())) {
            executionIsCancelled = true;
        }
        if (executionIsCancelled) {
            execution.getSystemContext().setFlowTerminationType(ExecutionStatus.CANCELED);
            execution.setPosition(null);
            return true;
        }
        return false;
    }

    protected boolean handlePausedFlow(Execution execution) throws InterruptedException {
        String branchId = execution.getSystemContext().getBranchId();
        PauseReason reason = this.findPauseReason(execution.getExecutionId(), branchId);
        if (reason != null) {
            this.pauseFlow(reason, execution);
            return true;
        }
        return false;
    }

    private boolean handlePausedFlowAfterStep(Execution execution) throws InterruptedException {
        String branchId = execution.getSystemContext().getBranchId();
        PauseReason reason = null;
        ExecutionSummary execSummary = this.pauseService.readPausedExecution(execution.getExecutionId(), branchId);
        if (execSummary != null && execSummary.getStatus().equals((Object)ExecutionStatus.PENDING_PAUSE)) {
            reason = execSummary.getPauseReason();
        }
        if (reason != null) {
            this.pauseFlow(reason, execution);
            return true;
        }
        return false;
    }

    private void pauseFlow(PauseReason reason, Execution execution) throws InterruptedException {
        SystemContext systemContext = execution.getSystemContext();
        Long executionId = execution.getExecutionId();
        String branchId = systemContext.getBranchId();
        if (!ExecutionServiceImpl.isDebuggerMode((Map<String, Serializable>)execution.getSystemContext()) && reason.equals((Object)PauseReason.USER_PAUSED) && branchId != null) {
            this.pauseService.pauseExecution(executionId, branchId, reason);
        }
        this.addPauseEvent(systemContext);
        this.dumpBusEvents(execution);
        this.pauseService.writeExecutionObject(executionId, branchId, execution);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Execution with execution_id: " + execution.getExecutionId() + " is paused!"));
        }
    }

    private void addPauseEvent(SystemContext systemContext) throws InterruptedException {
        HashMap eventData = new HashMap();
        eventData.put("systemContext", new HashMap(systemContext));
        ScoreEvent eventWrapper = new ScoreEvent("SCORE_PAUSED_EVENT", eventData);
        this.eventBus.dispatch(new ScoreEvent[]{eventWrapper});
    }

    private PauseReason findPauseReason(Long executionId, String branchId) {
        PauseReason reason;
        ExecutionSummary execSummary;
        if (this.workerConfigurationService.isExecutionPaused(executionId, branchId)) {
            ExecutionSummary execSummary2 = this.pauseService.readPausedExecution(executionId, branchId);
            if (execSummary2 != null && execSummary2.getStatus().equals((Object)ExecutionStatus.PENDING_PAUSE)) {
                return execSummary2.getPauseReason();
            }
        } else if (branchId != null && this.workerConfigurationService.isExecutionPaused(executionId, null) && (execSummary = this.pauseService.readPausedExecution(executionId, null)) != null && execSummary.getStatus().equals((Object)ExecutionStatus.PENDING_PAUSE) && PauseReason.USER_PAUSED.equals((Object)(reason = execSummary.getPauseReason()))) {
            return reason;
        }
        return null;
    }

    private static boolean isDebuggerMode(Map<String, Serializable> systemContext) {
        Boolean isDebuggerMode = (Boolean)systemContext.get("DEBUGGER_MODE");
        if (isDebuggerMode == null) {
            return false;
        }
        return isDebuggerMode;
    }

    private void dumpBusEvents(Execution execution) throws InterruptedException {
        ArrayDeque eventsQueue = execution.getSystemContext().getEvents();
        if (eventsQueue == null) {
            return;
        }
        for (ScoreEvent eventWrapper : eventsQueue) {
            this.eventBus.dispatch(new ScoreEvent[]{eventWrapper});
        }
        eventsQueue.clear();
    }

    protected ExecutionStep loadExecutionStep(Execution execution) {
        if (execution != null) {
            RunningExecutionPlan runningExecutionPlan;
            if (execution.getSystemContext().get((Object)"content_step") != null) {
                return (ExecutionStep)execution.getSystemContext().get((Object)"content_step");
            }
            Long position = execution.getPosition();
            if (position != null && (runningExecutionPlan = this.workerDbSupportService.readExecutionPlanById(execution.getRunningExecutionPlanId())) != null) {
                this.updateMetadata(execution, runningExecutionPlan);
                ExecutionStep currStep = runningExecutionPlan.getExecutionPlan().getStep(position);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Begin step: " + position + " in flow " + runningExecutionPlan.getExecutionPlan().getFlowUuid() + " [" + execution.getExecutionId() + "]"));
                }
                if (currStep != null) {
                    return currStep;
                }
            }
        }
        throw new RuntimeException("Failed to load ExecutionStep!");
    }

    private void updateMetadata(Execution execution, RunningExecutionPlan runningExecutionPlan) {
        Map executionMetadata = execution.getSystemContext().getMetaData();
        ExecutionPlan executionPlan = runningExecutionPlan.getExecutionPlan();
        executionMetadata.put("EXECUTION_PLAN_ID", executionPlan.getFlowUuid());
        executionMetadata.put("EXECUTION_PLAN_NAME", executionPlan.getName());
    }

    protected void executeStep(Execution execution, ExecutionStep currStep) {
        try {
            Map<String, Object> stepData = this.prepareStepData(execution, currStep);
            this.reflectionAdapter.executeControlAction(currStep.getAction(), stepData);
        }
        catch (RuntimeException ex) {
            ExecutionServiceImpl.handleStepExecutionException(execution, ex);
        }
    }

    private static void handleStepExecutionException(Execution execution, RuntimeException ex) {
        logger.error((Object)("Error occurred during operation execution.  Execution id: " + execution.getExecutionId()), (Throwable)ex);
        execution.getSystemContext().setStepErrorKey(ex.getMessage());
    }

    private Map<String, Object> prepareStepData(Execution execution, ExecutionStep currStep) {
        Map actionData = currStep.getActionData();
        HashMap<String, Object> stepData = new HashMap<String, Object>();
        if (actionData != null) {
            stepData.putAll(actionData);
        }
        ExecutionServiceImpl.addContextData(stepData, execution);
        return stepData;
    }

    private void createErrorEvent(String ex, String logMessage, String errorType, SystemContext systemContext) throws InterruptedException {
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("systemContext", new HashMap(systemContext));
        eventData.put("error_message", ex);
        eventData.put("logMessage", logMessage);
        eventData.put("SCORE_ERROR_TYPE", errorType);
        ScoreEvent eventWrapper = new ScoreEvent("SCORE_ERROR_EVENT", eventData);
        this.eventBus.dispatch(new ScoreEvent[]{eventWrapper});
    }

    protected void navigate(Execution execution, ExecutionStep currStep) throws InterruptedException {
        try {
            if (currStep.getNavigation() != null) {
                HashMap<String, Object> navigationData = new HashMap<String, Object>(currStep.getNavigationData());
                ExecutionServiceImpl.addContextData(navigationData, execution);
                Long position = (Long)this.reflectionAdapter.executeControlAction(currStep.getNavigation(), navigationData);
                execution.setPosition(position);
            } else {
                execution.setPosition(null);
            }
        }
        catch (RuntimeException navEx) {
            logger.error((Object)("Error occurred during navigation execution. Execution id: " + execution.getExecutionId()), (Throwable)navEx);
            execution.getSystemContext().setStepErrorKey(navEx.getMessage());
            execution.getSystemContext().setFlowTerminationType(ExecutionStatus.SYSTEM_FAILURE);
            execution.setPosition(null);
            try {
                this.createErrorEvent(navEx.getMessage(), "Error occurred during navigation execution ", "STEP_NAV_ERROR", execution.getSystemContext());
            }
            catch (RuntimeException eventEx) {
                logger.error((Object)"Failed to create event: ", (Throwable)eventEx);
            }
        }
    }

    private static boolean useDefaultGroup(Execution execution) {
        Boolean useDefaultGroup = (Boolean)execution.getSystemContext().get((Object)"USE_DEFAULT_GROUP");
        if (useDefaultGroup == null) {
            return false;
        }
        return useDefaultGroup;
    }

    protected static void postExecutionSettings(Execution execution) {
        Long requestForChangingExecutionPlan;
        String group = (String)((Object)execution.getSystemContext().get((Object)"ACTUALLY_OPERATION_GROUP"));
        execution.setGroupName(group);
        if (ExecutionServiceImpl.isDebuggerMode((Map<String, Serializable>)execution.getSystemContext()) && !StringUtils.isEmpty((String)group) && ExecutionServiceImpl.useDefaultGroup(execution)) {
            execution.setGroupName(null);
        }
        if ((requestForChangingExecutionPlan = execution.getSystemContext().pullRequestForChangingExecutionPlan()) != null) {
            execution.setRunningExecutionPlanId(requestForChangingExecutionPlan);
        }
    }

    private static void addContextData(Map<String, Object> data, Execution execution) {
        data.putAll(execution.getContexts());
        data.put("systemContext", execution.getSystemContext());
        data.put("executionRuntimeServices", execution.getSystemContext());
        data.put("execution", execution);
        data.put("executionContext", execution.getContexts());
        data.put("RUNNING_EXECUTION_PLAN_ID", execution.getRunningExecutionPlanId());
    }
}

