/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.worker.execution.services;

import io.cloudslang.worker.execution.services.SessionDataHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class SessionDataHandlerImpl
implements SessionDataHandler {
    private static final Logger logger = LogManager.getLogger(SessionDataHandlerImpl.class);
    @Autowired(required=false)
    @Qualifier(value="scoreSessionTimeout")
    private Long sessionTimeout = 1800000L;
    private Map<Long, SessionDataHolder> globalSessionsExecutionDataMap = new ConcurrentHashMap<Long, SessionDataHolder>();
    private Map<Long, Map<Long, SessionDataHolder>> sessionsExecutionDataMap = new ConcurrentHashMap<Long, Map<Long, SessionDataHolder>>();

    public void sessionTimeOutScheduler() {
        this.invalidateTimedOutSessions(this.globalSessionsExecutionDataMap);
        this.sessionsExecutionDataMap.values().forEach(this::invalidateTimedOutSessions);
    }

    private void invalidateTimedOutSessions(Map<Long, SessionDataHolder> executionDataMap) {
        ArrayList<SessionDataHolder> sessionDataHolders = new ArrayList<SessionDataHolder>(executionDataMap.values());
        long currentTime = System.currentTimeMillis();
        for (SessionDataHolder sessionDataHolder : sessionDataHolders) {
            if (logger.isDebugEnabled()) {
                logger.debug("Checking if we need to clean. Current time: " + new Date(currentTime).toString() + ".   session time: " + new Date(sessionDataHolder.getTimeStamp()).toString());
            }
            if (currentTime - sessionDataHolder.getTimeStamp() <= this.sessionTimeout) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Cleaning session. Current time: " + new Date(currentTime).toString() + ".   session time: " + new Date(sessionDataHolder.getTimeStamp()).toString());
            }
            executionDataMap.remove(sessionDataHolder.getExecutionId());
        }
    }

    public Map<String, Object> getSessionsExecutionData(Long executionId, Long branchId) {
        SessionDataHolder sessionDataHolder = this.getSessionDataHolder(executionId, branchId);
        if (logger.isDebugEnabled()) {
            logger.debug("Execution " + branchId + " contains " + sessionDataHolder.getSessionData().size() + " items");
        }
        sessionDataHolder.resetTimeStamp();
        return sessionDataHolder.getSessionData();
    }

    private SessionDataHolder getSessionDataHolder(Long executionId, Long branchId) {
        Map sessionMap = this.sessionsExecutionDataMap.computeIfAbsent(executionId, e -> new HashMap());
        return sessionMap.computeIfAbsent(branchId, x$0 -> new SessionDataHolder((Long)x$0));
    }

    public Map<String, Object> getGlobalSessionsExecutionData(Long executionId) {
        SessionDataHolder globalSessionDataHolder = this.getGlobalSessionDataHolder(executionId);
        if (logger.isDebugEnabled()) {
            logger.debug("Execution " + executionId + " contains " + globalSessionDataHolder.getSessionData().size() + " items");
        }
        globalSessionDataHolder.resetTimeStamp();
        return globalSessionDataHolder.getSessionData();
    }

    private SessionDataHolder getGlobalSessionDataHolder(Long executionId) {
        return this.globalSessionsExecutionDataMap.computeIfAbsent(executionId, x$0 -> new SessionDataHolder((Long)x$0));
    }

    public void setSessionDataActive(Long executionId, Long branchId) {
        if (branchId == null) {
            return;
        }
        SessionDataHolder nonSerializableExecutionData = this.getSessionDataHolder(executionId, branchId);
        nonSerializableExecutionData.setMaxTimestamp();
    }

    public void setSessionDataInactive(Long executionId, Long branchId) {
        if (branchId == null) {
            return;
        }
        SessionDataHolder nonSerializableExecutionData = this.getSessionDataHolder(executionId, branchId);
        nonSerializableExecutionData.resetTimeStamp();
    }

    public void setGlobalSessionDataActive(Long executionId) {
        if (executionId == null) {
            return;
        }
        SessionDataHolder nonSerializableExecutionData = this.getGlobalSessionDataHolder(executionId);
        nonSerializableExecutionData.setMaxTimestamp();
    }

    public void setGlobalSessionDataInactive(Long executionId) {
        if (executionId == null) {
            return;
        }
        SessionDataHolder nonSerializableExecutionData = this.getGlobalSessionDataHolder(executionId);
        nonSerializableExecutionData.resetTimeStamp();
    }

    class SessionDataHolder {
        private Long executionId;
        private Map<String, Object> sessionData;
        private long timeStamp;

        SessionDataHolder(Long executionId) {
            this.executionId = executionId;
            this.sessionData = new HashMap<String, Object>();
            this.timeStamp = System.currentTimeMillis();
        }

        Long getExecutionId() {
            return this.executionId;
        }

        Map<String, Object> getSessionData() {
            return this.sessionData;
        }

        long getTimeStamp() {
            return this.timeStamp;
        }

        void resetTimeStamp() {
            if (logger.isDebugEnabled()) {
                logger.debug("Resetting session timestamp for execution: " + this.executionId);
            }
            this.timeStamp = System.currentTimeMillis();
        }

        void setMaxTimestamp() {
            if (logger.isDebugEnabled()) {
                logger.debug("Locking session timestamp for execution: " + this.executionId);
            }
            this.timeStamp = Long.MAX_VALUE;
        }
    }
}

