/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.worker.execution.services;

import io.cloudslang.worker.execution.services.SessionDataHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class SessionDataHandlerImpl
implements SessionDataHandler {
    @Autowired(required=false)
    @Qualifier(value="scoreSessionTimeout")
    private Long sessionTimeout = 1800000L;
    private Map<Long, SessionDataHolder> nonSerializableExecutionDataMap = new ConcurrentHashMap<Long, SessionDataHolder>();
    private static final Logger logger = Logger.getLogger(SessionDataHandlerImpl.class);

    public void sessionTimeOutScheduler() {
        ArrayList<SessionDataHolder> sessionDataHolders = new ArrayList<SessionDataHolder>(this.nonSerializableExecutionDataMap.values());
        long currentTime = System.currentTimeMillis();
        for (SessionDataHolder sessionDataHolder : sessionDataHolders) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Checking if we need to clean. Current time: " + new Date(currentTime).toString() + ".   session time: " + new Date(sessionDataHolder.getTimeStamp()).toString()));
            }
            if (currentTime - sessionDataHolder.getTimeStamp() <= this.sessionTimeout) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cleaning session. Current time: " + new Date(currentTime).toString() + ".   session time: " + new Date(sessionDataHolder.getTimeStamp()).toString()));
            }
            this.nonSerializableExecutionDataMap.remove(sessionDataHolder.getExecutionId());
        }
    }

    public Map<String, Object> getNonSerializableExecutionData(Long executionId) {
        SessionDataHolder nonSerializableExecutionData = this.getNonSerializableSessionDataHolder(executionId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Execution " + executionId + " contains " + nonSerializableExecutionData.getSessionData().size() + " items"));
        }
        nonSerializableExecutionData.resetTimeStamp();
        return nonSerializableExecutionData.getSessionData();
    }

    private SessionDataHolder getNonSerializableSessionDataHolder(Long executionId) {
        SessionDataHolder nonSerializableExecutionData = this.nonSerializableExecutionDataMap.get(executionId);
        if (nonSerializableExecutionData == null) {
            nonSerializableExecutionData = new SessionDataHolder(executionId);
            this.nonSerializableExecutionDataMap.put(nonSerializableExecutionData.getExecutionId(), nonSerializableExecutionData);
        }
        return nonSerializableExecutionData;
    }

    public void setSessionDataActive(Long executionId) {
        if (executionId == null) {
            return;
        }
        SessionDataHolder nonSerializableExecutionData = this.getNonSerializableSessionDataHolder(executionId);
        nonSerializableExecutionData.setMaxTimestamp();
    }

    public void setSessionDataInactive(Long executionId) {
        if (executionId == null) {
            return;
        }
        SessionDataHolder nonSerializableExecutionData = this.getNonSerializableSessionDataHolder(executionId);
        nonSerializableExecutionData.resetTimeStamp();
    }

    class SessionDataHolder {
        private Long executionId;
        private Map<String, Object> sessionData;
        private long timeStamp;

        SessionDataHolder(Long executionId) {
            this.executionId = executionId;
            this.sessionData = new HashMap<String, Object>();
            this.timeStamp = System.currentTimeMillis();
        }

        Long getExecutionId() {
            return this.executionId;
        }

        Map<String, Object> getSessionData() {
            return this.sessionData;
        }

        long getTimeStamp() {
            return this.timeStamp;
        }

        void resetTimeStamp() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Resetting session timestamp for execution: " + this.executionId));
            }
            this.timeStamp = System.currentTimeMillis();
        }

        void setMaxTimestamp() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Locking session timestamp for execution: " + this.executionId));
            }
            this.timeStamp = Long.MAX_VALUE;
        }
    }
}

