/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.worker.execution.reflection;

import io.cloudslang.score.api.ControlActionMetadata;
import io.cloudslang.score.exceptions.FlowExecutionException;
import io.cloudslang.score.lang.ExecutionRuntimeServices;
import io.cloudslang.worker.execution.model.StepActionDataHolder;
import io.cloudslang.worker.execution.reflection.ReflectionAdapter;
import io.cloudslang.worker.execution.services.SessionDataHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;

public class ReflectionAdapterImpl
implements ReflectionAdapter,
ApplicationContextAware {
    private static final Logger logger = Logger.getLogger(ReflectionAdapterImpl.class);
    @Autowired
    private SessionDataHandler sessionDataHandler;
    private ApplicationContext applicationContext;
    private final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private final Map<String, Object> cacheBeans = new ConcurrentHashMap<String, Object>();
    private final Map<String, Method> cacheMethods = new ConcurrentHashMap<String, Method>();
    private final Map<String, String[]> cacheParamNames = new ConcurrentHashMap<String, String[]>();

    private static Long getExecutionIdFromActionData(StepActionDataHolder.ReadonlyStepActionDataAccessor accessor) {
        ExecutionRuntimeServices executionRuntimeServices = (ExecutionRuntimeServices)accessor.getValue("executionRuntimeServices");
        return executionRuntimeServices != null ? executionRuntimeServices.getExecutionId() : null;
    }

    private static Long getRunningExecutionIdFromActionData(StepActionDataHolder.ReadonlyStepActionDataAccessor accessor) {
        ExecutionRuntimeServices executionRuntimeServices = (ExecutionRuntimeServices)accessor.getValue("executionRuntimeServices");
        return executionRuntimeServices != null ? executionRuntimeServices.getParentRunningId() : ReflectionAdapterImpl.getExecutionIdFromActionData(accessor);
    }

    private static String getExceptionMessage(ControlActionMetadata actionMetadata) {
        return "Failed to run the action! Class: " + actionMetadata.getClassName() + ", method: " + actionMetadata.getMethodName();
    }

    public Object executeControlAction(ControlActionMetadata actionMetadata, StepActionDataHolder.ReadonlyStepActionDataAccessor accessor) {
        Validate.notNull((Object)actionMetadata, (String)"Action metadata is null");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing control action [" + actionMetadata.getClassName() + '.' + actionMetadata.getMethodName() + ']'));
        }
        try {
            Object actionBean = this.getActionBean(actionMetadata);
            Method actionMethod = this.getActionMethod(actionMetadata);
            Object[] arguments = this.buildParametersArray(actionMethod, accessor);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Invoking...");
            }
            Object result = actionMethod.invoke(actionBean, arguments);
            this.clearStateAfterInvocation(accessor);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Control action [" + actionMetadata.getClassName() + '.' + actionMetadata.getMethodName() + "] done"));
            }
            return result;
        }
        catch (IllegalArgumentException ex) {
            String message = "Failed to run the action! Wrong arguments were passed to class: " + actionMetadata.getClassName() + ", method: " + actionMetadata.getMethodName() + ", reason: " + ex.getMessage();
            throw new FlowExecutionException(message, (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            String message = ex.getTargetException() == null ? ex.getMessage() : ex.getTargetException().getMessage();
            logger.error((Object)(ReflectionAdapterImpl.getExceptionMessage(actionMetadata) + ", reason: " + message), (Throwable)ex);
            throw new FlowExecutionException(message, (Throwable)ex);
        }
        catch (Exception ex) {
            throw new FlowExecutionException(ReflectionAdapterImpl.getExceptionMessage(actionMetadata) + ", reason: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private void clearStateAfterInvocation(StepActionDataHolder.ReadonlyStepActionDataAccessor accessor) {
        Long executionId = ReflectionAdapterImpl.getExecutionIdFromActionData(accessor);
        this.sessionDataHandler.setGlobalSessionDataInactive(executionId);
        this.sessionDataHandler.setSessionDataInactive(executionId, ReflectionAdapterImpl.getRunningExecutionIdFromActionData(accessor));
    }

    private Object getActionBean(ControlActionMetadata actionMetadata) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object bean = this.cacheBeans.get(actionMetadata.getClassName());
        if (bean == null) {
            Class<?> actionClass = Class.forName(actionMetadata.getClassName());
            try {
                bean = this.applicationContext.getBean(actionClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bean == null) {
                bean = actionClass.newInstance();
            }
            this.cacheBeans.put(actionMetadata.getClassName(), bean);
        }
        return bean;
    }

    private Method getActionMethod(ControlActionMetadata metadata) throws ClassNotFoundException {
        String key = metadata.getClassName() + '.' + metadata.getMethodName();
        Method actionMethod = this.cacheMethods.get(key);
        if (actionMethod != null) {
            return actionMethod;
        }
        for (Method method : Class.forName(metadata.getClassName()).getMethods()) {
            if (!method.getName().equals(metadata.getMethodName())) continue;
            actionMethod = method;
            this.cacheMethods.put(key, method);
            break;
        }
        if (actionMethod != null) {
            return actionMethod;
        }
        String message = "Method: " + metadata.getMethodName() + " was not found in class:  " + metadata.getClassName();
        logger.error((Object)message);
        throw new FlowExecutionException(message);
    }

    private Object[] buildParametersArray(Method actionMethod, StepActionDataHolder.ReadonlyStepActionDataAccessor accessor) {
        String actionFullName = actionMethod.getDeclaringClass().getName() + "." + actionMethod.getName();
        String[] paramNames = this.cacheParamNames.get(actionFullName);
        if (paramNames == null) {
            paramNames = this.parameterNameDiscoverer.getParameterNames(actionMethod);
            this.cacheParamNames.put(actionFullName, paramNames);
        }
        Object[] args = new Object[paramNames.length];
        for (int counter = 0; counter < args.length; ++counter) {
            String paramName = paramNames[counter];
            if ("nonSerializableExecutionData".equals(paramName)) {
                Long executionId = ReflectionAdapterImpl.getExecutionIdFromActionData(accessor);
                Long runningId = ReflectionAdapterImpl.getRunningExecutionIdFromActionData(accessor);
                Map globalSessionsExecutionData = this.sessionDataHandler.getGlobalSessionsExecutionData(executionId);
                Map sessionObjectExecutionData = this.sessionDataHandler.getSessionsExecutionData(executionId, runningId);
                HashMap<String, Map> nonSerializableExecutionData = new HashMap<String, Map>(2);
                nonSerializableExecutionData.put("globalSessionObject", globalSessionsExecutionData);
                nonSerializableExecutionData.put("sessionObject", sessionObjectExecutionData);
                args[counter] = nonSerializableExecutionData;
                this.sessionDataHandler.setGlobalSessionDataActive(executionId);
                this.sessionDataHandler.setSessionDataActive(executionId, runningId);
                continue;
            }
            args[counter] = accessor.getValue(paramName);
        }
        return args;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

