/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.worker.execution.services;

import io.cloudslang.orchestrator.services.PauseResumeService;
import io.cloudslang.score.api.ControlActionMetadata;
import io.cloudslang.score.api.ExecutionPlan;
import io.cloudslang.score.api.ExecutionStep;
import io.cloudslang.score.api.StartBranchDataContainer;
import io.cloudslang.score.events.EventBus;
import io.cloudslang.score.events.ScoreEvent;
import io.cloudslang.score.facade.entities.Execution;
import io.cloudslang.score.facade.entities.RunningExecutionPlan;
import io.cloudslang.score.facade.execution.ExecutionStatus;
import io.cloudslang.score.facade.execution.ExecutionSummary;
import io.cloudslang.score.facade.execution.PauseReason;
import io.cloudslang.score.lang.SystemContext;
import io.cloudslang.worker.execution.model.SandboxExecutionRunnable;
import io.cloudslang.worker.execution.reflection.ReflectionAdapter;
import io.cloudslang.worker.execution.services.ExecutionService;
import io.cloudslang.worker.execution.services.RobotAvailabilityService;
import io.cloudslang.worker.management.WorkerConfigurationService;
import io.cloudslang.worker.management.services.dbsupport.WorkerDbSupportService;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public final class ExecutionServiceImpl
implements ExecutionService {
    private static final Logger logger = Logger.getLogger(ExecutionServiceImpl.class);
    @Autowired
    private PauseResumeService pauseService;
    @Autowired
    private ReflectionAdapter reflectionAdapter;
    @Autowired
    private WorkerDbSupportService workerDbSupportService;
    @Autowired
    private WorkerConfigurationService workerConfigurationService;
    @Autowired
    private EventBus eventBus;
    @Autowired
    private RobotAvailabilityService robotAvailabilityService;
    private static final int DEFAULT_PLATFORM_LEVEL_OPERATION_TIMEOUT_IN_SECONDS = 86400;
    private static final int DEFAULT_PLATFORM_LEVEL_WAIT_PERIOD_FOR_TIMEOUT_IN_SECONDS = 300;
    private static final long DEFAULT_PLATFORM_LEVEL_WAIT_PAUSE_FOR_TIMEOUT_IN_MILLIS = 200L;
    private final long operationTimeoutMillis = (long)this.getSafeIntProperty("execution.operationTimeoutInSeconds", 86400) * 1000L;
    private final long waitPauseForTimeoutMillis;
    private final long waitPeriodForTimeoutMillis = (long)this.getSafeIntProperty("execution.waitPeriodForTimeoutInSeconds", 300) * 1000L;
    private final boolean interruptOperationExecution;
    private final boolean enableNewTimeoutMechanism;

    public ExecutionServiceImpl() {
        this.waitPauseForTimeoutMillis = this.getSafeLongProperty("execution.waitPauseForTimeoutInMillis", 200L);
        this.interruptOperationExecution = Boolean.getBoolean("execution.interruptOperation");
        this.enableNewTimeoutMechanism = Boolean.getBoolean("enable.new.timeout");
    }

    private int getSafeIntProperty(String property, int defaultValue) {
        int intVal = Integer.getInteger(property, defaultValue);
        return intVal > 0 ? intVal : defaultValue;
    }

    private long getSafeLongProperty(String property, long defaultValue) {
        long longVal = Long.getLong(property, defaultValue);
        return longVal > 0L ? longVal : defaultValue;
    }

    public Execution execute(Execution execution) throws InterruptedException {
        try {
            if (this.handleCancelledFlow(execution)) {
                return execution;
            }
            ExecutionStep currStep = this.loadExecutionStep(execution);
            if (!ExecutionServiceImpl.isDebuggerMode((Map<String, Serializable>)execution.getSystemContext()) && this.handlePausedFlow(execution)) {
                return null;
            }
            this.dumpBusEvents(execution);
            String timeoutMessage = this.executeStep(execution, currStep);
            if (timeoutMessage != null) {
                try {
                    return this.doWaitForCancel(execution);
                }
                catch (TimeoutException timeout) {
                    logger.error((Object)("Timed out waiting for cancel for execution id " + execution.getExecutionId()));
                    execution.getSystemContext().setStepErrorKey(timeoutMessage);
                }
            }
            if (!execution.getSystemContext().hasStepErrorKey() && currStep.getActionData().get("actionType") != null && currStep.getActionData().get("actionType").toString().equalsIgnoreCase("sequential")) {
                return null;
            }
            this.navigate(execution, currStep);
            this.postExecutionSettings(execution);
            if (execution.getSystemContext().isPaused() && this.handlePausedFlowAfterStep(execution)) {
                return null;
            }
            this.dumpBusEvents(execution);
            return execution;
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"Error during execution: ", (Throwable)ex);
            execution.getSystemContext().setStepErrorKey(ex.getMessage());
            execution.getSystemContext().setFlowTerminationType(ExecutionStatus.SYSTEM_FAILURE);
            execution.setPosition(null);
            return execution;
        }
    }

    public void pauseSequentialExecution(Execution execution) throws InterruptedException {
        PauseReason pauseReason = this.robotAvailabilityService.isRobotAvailable("Default") ? PauseReason.PENDING_ROBOT : PauseReason.NO_ROBOTS_IN_GROUP;
        this.pauseFlow(execution, pauseReason);
    }

    public void postExecutionWork(Execution execution) throws InterruptedException {
        this.navigate(execution, this.loadExecutionStep(execution));
        this.postExecutionSettings(execution);
        this.dumpBusEvents(execution);
    }

    private Execution doWaitForCancel(Execution execution) throws InterruptedException, TimeoutException {
        int iterations = (int)(this.waitPeriodForTimeoutMillis / this.waitPauseForTimeoutMillis) + 1;
        for (int i = 0; i < iterations; ++i) {
            if (this.handleCancelledFlow(execution)) {
                return execution;
            }
            Thread.sleep(this.waitPauseForTimeoutMillis);
        }
        throw new TimeoutException();
    }

    public List<Execution> executeSplitForNonBlockAndParallel(Execution execution) throws InterruptedException {
        try {
            ExecutionStep currStep = this.loadExecutionStep(execution);
            if (!ExecutionServiceImpl.isDebuggerMode((Map<String, Serializable>)execution.getSystemContext()) && this.handlePausedFlow(execution)) {
                return null;
            }
            this.dumpBusEvents(execution);
            this.executeSplitStep(execution, currStep);
            this.failFlowIfSplitStepFailed(execution);
            this.dumpBusEvents(execution);
            List newBranches = execution.getSystemContext().removeBranchesData();
            List<Execution> newExecutions = ExecutionServiceImpl.createChildExecutionsForNonBlockingAndParallel(execution.getExecutionId(), newBranches);
            this.navigate(execution, currStep);
            this.dumpBusEvents(execution);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("End of step: " + execution.getPosition() + " in execution id: " + execution.getExecutionId()));
            }
            return newExecutions;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception during the split step!", (Throwable)ex);
            throw ex;
        }
    }

    public List<Execution> executeSplitForMi(Execution execution, String splitUuid, int nrOfAlreadyCreatedBranches) throws InterruptedException {
        try {
            ExecutionStep currStep = this.loadExecutionStep(execution);
            if (!ExecutionServiceImpl.isDebuggerMode((Map<String, Serializable>)execution.getSystemContext()) && this.handlePausedFlow(execution)) {
                return null;
            }
            this.dumpBusEvents(execution);
            this.executeSplitStep(execution, currStep);
            this.failFlowIfSplitStepFailed(execution);
            this.dumpBusEvents(execution);
            List newBranches = execution.getSystemContext().removeBranchesData();
            List<Execution> newExecutions = ExecutionServiceImpl.createChildExecutionsForMi(execution.getExecutionId(), newBranches, splitUuid, nrOfAlreadyCreatedBranches);
            Serializable miInputs = execution.getSystemContext().get((Object)"MI_INPUTS");
            if (miInputs == null) {
                this.navigate(execution, currStep);
            }
            this.dumpBusEvents(execution);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("End of step: " + execution.getPosition() + " in execution id: " + execution.getExecutionId()));
            }
            return newExecutions;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception during the split step!", (Throwable)ex);
            throw ex;
        }
    }

    private void failFlowIfSplitStepFailed(Execution execution) throws InterruptedException {
        if (execution.getSystemContext().hasStepErrorKey()) {
            String exception = execution.getSystemContext().getStepErrorKey();
            execution.getSystemContext().setFlowTerminationType(ExecutionStatus.SYSTEM_FAILURE);
            execution.setPosition(null);
            try {
                this.createErrorEvent(exception, "Error occurred during split step ", "STEP_SPLIT_ERROR", execution.getSystemContext());
            }
            catch (RuntimeException eventEx) {
                logger.error((Object)"Failed to create event: ", (Throwable)eventEx);
            }
            throw new RuntimeException(exception);
        }
    }

    private static List<Execution> createChildExecutionsForNonBlockingAndParallel(Long executionId, List<StartBranchDataContainer> newBranches) {
        ArrayList<Execution> newExecutions = new ArrayList<Execution>();
        String splitId = UUID.randomUUID().toString();
        ListIterator<StartBranchDataContainer> listIterator = newBranches.listIterator();
        int count = 0;
        while (listIterator.hasNext()) {
            StartBranchDataContainer from = listIterator.next();
            Execution to = new Execution(executionId, from.getExecutionPlanId(), from.getStartPosition(), from.getContexts(), (Map)from.getSystemContext());
            to.getSystemContext().setSplitId(splitId);
            to.getSystemContext().setBranchId(splitId + ":" + (count++ + 1));
            newExecutions.add(to);
        }
        return newExecutions;
    }

    private static List<Execution> createChildExecutionsForMi(Long executionId, List<StartBranchDataContainer> newBranches, String splitUuid, int nrOfAlreadyCreatedBranches) {
        ArrayList<Execution> newExecutions = new ArrayList<Execution>();
        ListIterator<StartBranchDataContainer> listIterator = newBranches.listIterator();
        int count = 0;
        while (listIterator.hasNext()) {
            StartBranchDataContainer from = listIterator.next();
            Execution to = new Execution(executionId, from.getExecutionPlanId(), from.getStartPosition(), from.getContexts(), (Map)from.getSystemContext());
            to.getSystemContext().setSplitId(splitUuid);
            int branchIndexInSplitStep = nrOfAlreadyCreatedBranches + count++ + 1;
            to.getSystemContext().setBranchId(splitUuid + ":" + branchIndexInSplitStep);
            newExecutions.add(to);
        }
        return newExecutions;
    }

    public boolean isSplitStep(Execution execution) {
        ExecutionStep currStep = this.loadExecutionStep(execution);
        return currStep.isSplitStep();
    }

    protected boolean handleCancelledFlow(Execution execution) {
        if (this.workerConfigurationService.isExecutionCancelled(execution.getExecutionId()) || execution.getSystemContext().getFlowTerminationType() == ExecutionStatus.CANCELED) {
            execution.getSystemContext().setFlowTerminationType(ExecutionStatus.CANCELED);
            execution.setPosition(null);
            return true;
        }
        return false;
    }

    protected boolean handlePausedFlow(Execution execution) throws InterruptedException {
        String branchId = execution.getSystemContext().getBranchId();
        PauseReason reason = this.findPauseReason(execution.getExecutionId(), branchId);
        if (reason != null) {
            this.pauseFlow(execution, reason);
            return true;
        }
        return false;
    }

    private boolean handlePausedFlowAfterStep(Execution execution) throws InterruptedException {
        String branchId = execution.getSystemContext().getBranchId();
        PauseReason reason = null;
        ExecutionSummary execSummary = this.pauseService.readPausedExecution(execution.getExecutionId(), branchId);
        if (execSummary != null && execSummary.getStatus().equals((Object)ExecutionStatus.PENDING_PAUSE)) {
            reason = execSummary.getPauseReason();
        }
        if (reason != null) {
            this.pauseFlow(execution, reason);
            return true;
        }
        return false;
    }

    private void pauseFlow(Execution execution, PauseReason reason) throws InterruptedException {
        SystemContext systemContext = execution.getSystemContext();
        Long executionId = execution.getExecutionId();
        String branchId = systemContext.getBranchId();
        if (!ExecutionServiceImpl.isDebuggerMode((Map<String, Serializable>)execution.getSystemContext()) && reason.equals((Object)PauseReason.USER_PAUSED)) {
            if (branchId != null) {
                this.pauseService.pauseExecution(executionId, branchId, reason);
            }
        } else if (reason == PauseReason.NO_ROBOTS_IN_GROUP || reason == PauseReason.PENDING_ROBOT) {
            this.pauseService.pauseExecution(executionId, branchId, reason);
        }
        this.addPauseEvent(systemContext);
        this.dumpBusEvents(execution);
        this.pauseService.writeExecutionObject(executionId, branchId, execution);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Execution with execution_id: " + execution.getExecutionId() + " is paused!"));
        }
    }

    private void addPauseEvent(SystemContext systemContext) throws InterruptedException {
        HashMap eventData = new HashMap();
        eventData.put("systemContext", new HashMap(systemContext));
        ScoreEvent eventWrapper = new ScoreEvent("SCORE_PAUSED_EVENT", eventData);
        this.eventBus.dispatch(new ScoreEvent[]{eventWrapper});
    }

    private PauseReason findPauseReason(Long executionId, String branchId) {
        PauseReason reason;
        ExecutionSummary execSummary;
        if (this.workerConfigurationService.isExecutionPaused(executionId, branchId)) {
            ExecutionSummary execSummary2 = this.pauseService.readPausedExecution(executionId, branchId);
            if (execSummary2 != null && execSummary2.getStatus().equals((Object)ExecutionStatus.PENDING_PAUSE)) {
                return execSummary2.getPauseReason();
            }
        } else if (branchId != null && this.workerConfigurationService.isExecutionPaused(executionId, null) && (execSummary = this.pauseService.readPausedExecution(executionId, null)) != null && execSummary.getStatus().equals((Object)ExecutionStatus.PENDING_PAUSE) && PauseReason.USER_PAUSED.equals((Object)(reason = execSummary.getPauseReason()))) {
            return reason;
        }
        return null;
    }

    private static boolean isDebuggerMode(Map<String, Serializable> systemContext) {
        Boolean isDebuggerMode = (Boolean)systemContext.get("DEBUGGER_MODE");
        return isDebuggerMode != null && isDebuggerMode != false;
    }

    private void dumpBusEvents(Execution execution) throws InterruptedException {
        ArrayDeque eventsQueue = execution.getSystemContext().getEvents();
        if (eventsQueue == null) {
            return;
        }
        for (ScoreEvent eventWrapper : eventsQueue) {
            this.eventBus.dispatch(new ScoreEvent[]{eventWrapper});
        }
        eventsQueue.clear();
    }

    protected ExecutionStep loadExecutionStep(Execution execution) {
        if (execution != null) {
            RunningExecutionPlan runningExecutionPlan;
            if (execution.getSystemContext().get((Object)"content_step") != null) {
                return (ExecutionStep)execution.getSystemContext().get((Object)"content_step");
            }
            Long position = execution.getPosition();
            if (position != null && (runningExecutionPlan = this.workerDbSupportService.readExecutionPlanById(execution.getRunningExecutionPlanId())) != null) {
                this.updateMetadata(execution, runningExecutionPlan);
                ExecutionStep currStep = runningExecutionPlan.getExecutionPlan().getStep(position);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Begin step: " + position + " in flow " + runningExecutionPlan.getExecutionPlan().getFlowUuid() + " [" + execution.getExecutionId() + "]"));
                }
                if (currStep != null) {
                    return currStep;
                }
            }
        }
        throw new RuntimeException("Failed to load ExecutionStep!");
    }

    private void updateMetadata(Execution execution, RunningExecutionPlan runningExecutionPlan) {
        Map executionMetadata = execution.getSystemContext().getMetaData();
        ExecutionPlan executionPlan = runningExecutionPlan.getExecutionPlan();
        executionMetadata.put("EXECUTION_PLAN_ID", executionPlan.getFlowUuid());
        executionMetadata.put("EXECUTION_PLAN_NAME", executionPlan.getName());
    }

    protected String executeStep(Execution execution, ExecutionStep currStep) throws InterruptedException {
        try {
            Map<String, Object> stepData = this.prepareStepData(execution, currStep);
            ControlActionMetadata action = currStep.getAction();
            if (this.enableNewTimeoutMechanism && this.isContentOperationStep(action)) {
                Long startTime = (Long)execution.getSystemContext().get((Object)"SC_TIMEOUT_START_TIME");
                Integer timeoutMins = (Integer)execution.getSystemContext().get((Object)"SC_TIMEOUT_MINS");
                if (startTime != null && timeoutMins != null) {
                    long now = System.currentTimeMillis();
                    Callable<Object> operationCallable = () -> this.reflectionAdapter.executeControlAction(action, stepData);
                    SandboxExecutionRunnable<Object> sandboxExecutionRunnable = new SandboxExecutionRunnable<Object>(Thread.currentThread().getContextClassLoader(), operationCallable);
                    Thread operationExecutionThread = new Thread(sandboxExecutionRunnable);
                    long dynamicTimeout = this.getDynamicTimeout(startTime, timeoutMins, now);
                    if (dynamicTimeout == -1L) {
                        String timeoutErrorMessageBeforeStep = String.format("Timeout (%d minutes) exceeded for execution id %s having start time %s (current time %s) before executing step %s", timeoutMins, String.valueOf(execution.getExecutionId()), String.valueOf(startTime), String.valueOf(now), String.valueOf(currStep.getExecStepId()));
                        logger.error((Object)timeoutErrorMessageBeforeStep);
                        return timeoutErrorMessageBeforeStep;
                    }
                    operationExecutionThread.setName("operationExecutionThread-" + execution.getExecutionId() + "-" + currStep.getExecStepId());
                    operationExecutionThread.start();
                    operationExecutionThread.join(dynamicTimeout);
                    if (operationExecutionThread.isAlive()) {
                        String timeoutErrorMessageDuringStep = String.format("Timeout (%d minutes) exceeded for execution id %s having start time %s (current time %s) when running step %s", timeoutMins, String.valueOf(execution.getExecutionId()), String.valueOf(startTime), String.valueOf(System.currentTimeMillis()), String.valueOf(currStep.getExecStepId()));
                        logger.error((Object)timeoutErrorMessageDuringStep);
                        if (this.interruptOperationExecution) {
                            operationExecutionThread.interrupt();
                        }
                        return timeoutErrorMessageDuringStep;
                    }
                    sandboxExecutionRunnable.afterExecute();
                } else {
                    this.reflectionAdapter.executeControlAction(action, stepData);
                }
            } else {
                this.reflectionAdapter.executeControlAction(action, stepData);
            }
        }
        catch (RuntimeException ex) {
            ExecutionServiceImpl.handleStepExecutionException(execution, ex);
        }
        return null;
    }

    private boolean isContentOperationStep(ControlActionMetadata action) {
        return action != null && StringUtils.equals((String)action.getMethodName(), (String)"executeContentAction") && StringUtils.endsWith((String)action.getClassName(), (String)"ContentExecutionActions");
    }

    private long getDynamicTimeout(long startTime, int timeoutMins, long now) {
        if (timeoutMins > 0 && now > startTime) {
            long minsInMillis = (long)(timeoutMins * 60) * 1000L;
            long elapsedTime = now - startTime;
            long diffInMillis = minsInMillis - elapsedTime;
            return diffInMillis > 0L ? diffInMillis : -1L;
        }
        return this.operationTimeoutMillis;
    }

    protected void executeSplitStep(Execution execution, ExecutionStep currStep) {
        try {
            Map<String, Object> stepData = this.prepareStepData(execution, currStep);
            this.reflectionAdapter.executeControlAction(currStep.getAction(), stepData);
        }
        catch (RuntimeException ex) {
            ExecutionServiceImpl.handleStepExecutionException(execution, ex);
        }
    }

    private static void handleStepExecutionException(Execution execution, RuntimeException ex) {
        logger.error((Object)("Error occurred during operation execution.  Execution id: " + execution.getExecutionId()), (Throwable)ex);
        execution.getSystemContext().setStepErrorKey(ex.getMessage());
    }

    private Map<String, Object> prepareStepData(Execution execution, ExecutionStep currStep) {
        Map navigationData;
        Map actionData = currStep.getActionData();
        HashMap<String, Object> stepData = new HashMap<String, Object>();
        if (actionData != null) {
            stepData.putAll(actionData);
        }
        if ((navigationData = currStep.getNavigationData()) != null) {
            stepData.putAll(navigationData);
        }
        ExecutionServiceImpl.addContextData(stepData, execution);
        return stepData;
    }

    private void createErrorEvent(String ex, String logMessage, String errorType, SystemContext systemContext) throws InterruptedException {
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("systemContext", new HashMap(systemContext));
        eventData.put("error_message", ex);
        eventData.put("executionIdContext", systemContext.getExecutionId());
        eventData.put("logMessage", logMessage);
        eventData.put("SCORE_ERROR_TYPE", errorType);
        ScoreEvent eventWrapper = new ScoreEvent("SCORE_ERROR_EVENT", eventData);
        this.eventBus.dispatch(new ScoreEvent[]{eventWrapper});
    }

    protected void navigate(Execution execution, ExecutionStep currStep) throws InterruptedException {
        try {
            if (currStep.getNavigation() != null) {
                HashMap<String, Object> navigationData = new HashMap<String, Object>(currStep.getNavigationData());
                ExecutionServiceImpl.addContextData(navigationData, execution);
                Long position = (Long)this.reflectionAdapter.executeControlAction(currStep.getNavigation(), navigationData);
                execution.setPosition(position);
            } else {
                execution.setPosition(null);
            }
        }
        catch (RuntimeException navEx) {
            logger.error((Object)("Error occurred during navigation execution. Execution id: " + execution.getExecutionId()), (Throwable)navEx);
            execution.getSystemContext().setStepErrorKey(navEx.getMessage());
            execution.getSystemContext().setFlowTerminationType(ExecutionStatus.SYSTEM_FAILURE);
            execution.setPosition(null);
            try {
                this.createErrorEvent(navEx.getMessage(), "Error occurred during navigation execution ", "STEP_NAV_ERROR", execution.getSystemContext());
            }
            catch (RuntimeException eventEx) {
                logger.error((Object)"Failed to create event: ", (Throwable)eventEx);
            }
        }
    }

    private static boolean useDefaultGroup(Execution execution) {
        Boolean useDefaultGroup = (Boolean)execution.getSystemContext().get((Object)"USE_DEFAULT_GROUP");
        if (useDefaultGroup == null) {
            return false;
        }
        return useDefaultGroup;
    }

    protected void postExecutionSettings(Execution execution) {
        this.setWorkerGroup(execution);
        Long requestForChangingExecutionPlan = execution.getSystemContext().pullRequestForChangingExecutionPlan();
        if (requestForChangingExecutionPlan != null) {
            execution.setRunningExecutionPlanId(requestForChangingExecutionPlan);
        }
    }

    private void setWorkerGroup(Execution execution) {
        String group = (String)((Object)execution.getSystemContext().get((Object)"ACTUALLY_OPERATION_GROUP"));
        if (group != null) {
            execution.setGroupName(group);
        }
        if (ExecutionServiceImpl.isDebuggerMode((Map<String, Serializable>)execution.getSystemContext()) && !StringUtils.isEmpty((String)group) && ExecutionServiceImpl.useDefaultGroup(execution)) {
            execution.setGroupName(null);
        }
    }

    private static void addContextData(Map<String, Object> data, Execution execution) {
        data.putAll(execution.getContexts());
        data.put("systemContext", execution.getSystemContext());
        data.put("executionRuntimeServices", execution.getSystemContext());
        data.put("execution", execution);
        data.put("executionContext", execution.getContexts());
        data.put("RUNNING_EXECUTION_PLAN_ID", execution.getRunningExecutionPlanId());
    }
}

