/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.engine.queue.entities;

import io.cloudslang.engine.queue.entities.Payload;
import io.cloudslang.engine.queue.entities.SensitiveDataHandler;
import io.cloudslang.score.facade.entities.Execution;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ExecutionMessageConverter {
    private static final byte[] ENCRYPTION_MARKER = new byte[]{73, 28, 45, 109};
    private static final int SIZE = 1024;
    @Autowired(required=false)
    private SensitiveDataHandler sensitiveDataHandler;
    private static final byte[] PAYLOAD_META_DATA_INIT_BYTES = new byte[]{0};
    private static final int INFRA_PART_BYTE = 0;
    private static final int IS_SENSITIVE = 1;

    public <T> T extractExecution(Payload payload) {
        return this.objFromBytes(payload.getData());
    }

    public Payload createPayload(Execution execution) {
        return this.createPayload(execution, false);
    }

    public Payload createPayload(Execution execution, boolean setContainsSensitiveData) {
        Payload payload = new Payload(this.objToBytes(execution));
        if (setContainsSensitiveData || this.checkContainsSensitiveData(execution)) {
            this.setSensitive(payload);
        }
        return payload;
    }

    private boolean checkContainsSensitiveData(Execution execution) {
        return this.sensitiveDataHandler != null && this.sensitiveDataHandler.containsSensitiveData(execution.getSystemContext(), execution.getContexts());
    }

    public boolean containsSensitiveData(Payload payload) {
        return this.isSensitive(payload);
    }

    private boolean areBytesCompressed(byte[] bytes) {
        if (bytes.length < 5) {
            return false;
        }
        for (int i = 0; i < ENCRYPTION_MARKER.length; ++i) {
            if (ENCRYPTION_MARKER[i] == bytes[i + 1]) continue;
            return false;
        }
        return true;
    }

    private <T> T objFromBytes(byte[] bytes) {
        Object object;
        ObjectInputStream ois;
        block5: {
            ois = null;
            if (!this.areBytesCompressed(bytes)) break block5;
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            this.skipPayloadMetaData(is);
            this.skipEncryptionMarker(is);
            ois = new ObjectInputStream(new GZIPInputStream(is));
            Object object2 = ois.readObject();
            IOUtils.closeQuietly((InputStream)ois);
            return (T)object2;
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            this.skipPayloadMetaData(is);
            ois = new ObjectInputStream(new BufferedInputStream(is));
            object = ois.readObject();
        }
        catch (IOException | ClassNotFoundException ex) {
            try {
                throw new RuntimeException("Failed to read execution plan from byte[]. Error: ", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ois);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)ois);
        return (T)object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] objToBytes(Object obj) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);){
            this.addPayloadMetadataBytes(byteArrayOutputStream);
            this.addEncryptionMarker(byteArrayOutputStream);
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new GZIPOutputStream(byteArrayOutputStream));){
                objectOutputStream.writeObject(obj);
                objectOutputStream.flush();
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to serialize execution plan. Error: ", ex);
        }
    }

    private void addEncryptionMarker(ByteArrayOutputStream bout) {
        bout.write(ENCRYPTION_MARKER, 0, ENCRYPTION_MARKER.length);
    }

    private void setSensitive(Payload payload) {
        payload.getData()[0] = 1;
    }

    private boolean isSensitive(Payload payload) {
        return payload.getData()[0] == 1;
    }

    private void skipPayloadMetaData(ByteArrayInputStream is) {
        for (int i = 0; i < PAYLOAD_META_DATA_INIT_BYTES.length; ++i) {
            is.read();
        }
    }

    private void skipEncryptionMarker(ByteArrayInputStream is) {
        for (int i = 0; i < ENCRYPTION_MARKER.length; ++i) {
            is.read();
        }
    }

    private void addPayloadMetadataBytes(ByteArrayOutputStream baos) throws IOException {
        baos.write(PAYLOAD_META_DATA_INIT_BYTES);
    }
}

