/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.engine.queue.enums;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public enum AssignStrategy {
    RANDOM("random"),
    SECURE_RANDOM("securerandom"),
    ROUND_ROBIN("roundrobin");

    private final String strategyName;

    private AssignStrategy(String strategy) {
        this.strategyName = strategy;
    }

    public static AssignStrategy getAssignedStrategy(String givenStrategy, AssignStrategy defaultStrategy) {
        Validate.notNull((Object)((Object)defaultStrategy), (String)"Default strategy cannot be null.", (Object[])new Object[0]);
        return Arrays.stream(AssignStrategy.values()).filter(strategy -> StringUtils.endsWithIgnoreCase((CharSequence)strategy.getStrategyName(), (CharSequence)givenStrategy)).findFirst().orElse(defaultStrategy);
    }

    public String getStrategyName() {
        return this.strategyName;
    }
}

