/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.engine.queue.entities;

import io.cloudslang.engine.queue.entities.Payload;
import io.cloudslang.engine.queue.entities.SensitiveDataHandler;
import io.cloudslang.score.facade.entities.Execution;
import it.unimi.dsi.fastutil.io.FastByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import net.jpountz.lz4.LZ4FrameInputStream;
import net.jpountz.lz4.LZ4FrameOutputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ExecutionMessageConverter {
    private static final int SIZE = 8192;
    @Autowired(required=false)
    private SensitiveDataHandler sensitiveDataHandler;
    private static final byte[] PAYLOAD_META_DATA_INIT_BYTES = new byte[]{0};
    private static final int INFRA_PART_BYTE = 0;
    private static final int IS_SENSITIVE = 1;

    public <T> T extractExecution(Payload payload) {
        return this.objFromBytes(payload.getData());
    }

    public Payload createPayload(Execution execution) {
        return this.createPayload(execution, false);
    }

    public Payload createPayload(Execution execution, boolean setContainsSensitiveData) {
        Payload payload = new Payload(this.objToBytes(execution));
        if (setContainsSensitiveData || this.checkContainsSensitiveData(execution)) {
            this.setSensitive(payload);
        }
        return payload;
    }

    private boolean checkContainsSensitiveData(Execution execution) {
        return this.sensitiveDataHandler != null && this.sensitiveDataHandler.containsSensitiveData(execution.getSystemContext(), execution.getContexts());
    }

    public boolean containsSensitiveData(Payload payload) {
        return this.isSensitive(payload);
    }

    private <T> T objFromBytes(byte[] bytes) {
        Object object;
        ObjectInputStream ois = null;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            this.skipPayloadMetaData(is);
            ois = new ObjectInputStream((InputStream)new LZ4FrameInputStream((InputStream)is));
            object = ois.readObject();
        }
        catch (IOException | ClassNotFoundException ex) {
            try {
                throw new RuntimeException("Failed to read execution plan from byte[]. Error: ", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ois);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)ois);
        return (T)object;
    }

    private byte[] objToBytes(Object obj) {
        byte[] byArray;
        ObjectOutputStream oos = null;
        try {
            FastByteArrayOutputStream baos = new FastByteArrayOutputStream(8192);
            this.initPayloadMetaData((OutputStream)baos);
            oos = new ObjectOutputStream((OutputStream)new LZ4FrameOutputStream((OutputStream)baos, LZ4FrameOutputStream.BLOCKSIZE.SIZE_256KB));
            oos.writeObject(obj);
            oos.flush();
            byArray = baos.array;
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException("Failed to serialize execution plan. Error: ", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(oos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)oos);
        return byArray;
    }

    private void setSensitive(Payload payload) {
        payload.getData()[0] = 1;
    }

    private boolean isSensitive(Payload payload) {
        return payload.getData()[0] == 1;
    }

    private void skipPayloadMetaData(ByteArrayInputStream is) {
        for (int i = 0; i < PAYLOAD_META_DATA_INIT_BYTES.length; ++i) {
            is.read();
        }
    }

    private void initPayloadMetaData(OutputStream baos) throws IOException {
        baos.write(PAYLOAD_META_DATA_INIT_BYTES);
    }
}

