/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.engine.queue.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.cloudslang.engine.node.entities.WorkerNode;
import io.cloudslang.engine.queue.entities.ExecStatus;
import io.cloudslang.engine.queue.entities.Payload;
import io.cloudslang.orchestrator.entities.Message;
import io.cloudslang.score.facade.entities.Execution;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.builder.EqualsBuilder;

public class ExecutionMessage
implements Message,
Cloneable {
    private static final long serialVersionUID = 3523623124812765964L;
    private static final int JVM_OBJECT_HEADER = 16;
    private static final int ARRAY_LENGTH_FIELD = 4;
    private static final int PADDING_LENGTH = 4;
    public static final long EMPTY_EXEC_STATE_ID = -1L;
    public static final String EMPTY_WORKER = "EMPTY";
    private long execStateId;
    private String workerId;
    private String workerGroup;
    private ExecStatus status;
    private Payload payload;
    private long payloadSize;
    private int msgSeqId;
    private String msgId;
    private Long createDate;
    private boolean stepPersist;
    private String stepPersistId;
    private transient String workerKey;
    private transient Execution executionObject;

    public ExecutionMessage() {
        this.execStateId = -1L;
        this.workerId = EMPTY_WORKER;
        this.workerGroup = "";
        this.status = ExecStatus.INIT;
        this.payload = null;
        this.payloadSize = 0L;
        this.msgSeqId = -1;
        this.msgId = "";
        this.createDate = null;
    }

    public ExecutionMessage(String executionId, Payload payload) {
        this.execStateId = -1L;
        this.workerId = EMPTY_WORKER;
        this.workerGroup = WorkerNode.DEFAULT_WORKER_GROUPS[0];
        this.msgId = String.valueOf(executionId);
        this.status = ExecStatus.PENDING;
        this.payload = payload;
        this.payloadSize = this.getPayloadSize(payload);
        this.msgSeqId = 0;
    }

    public ExecutionMessage(long execStateId, String workerId, String workerGroup, String msgId, ExecStatus status, Payload payload, int msgSeqId, Long createDate) {
        this.execStateId = execStateId;
        this.workerId = workerId;
        this.workerGroup = workerGroup;
        this.msgId = msgId;
        this.status = status;
        this.payload = payload;
        this.payloadSize = this.getPayloadSize(payload);
        this.msgSeqId = msgSeqId;
        this.createDate = createDate;
    }

    public ExecutionMessage(long execStateId, String workerId, String workerGroup, String msgId, ExecStatus status, Payload payload, int msgSeqId) {
        this.execStateId = execStateId;
        this.workerId = workerId;
        this.workerGroup = workerGroup;
        this.msgId = msgId;
        this.status = status;
        this.payload = payload;
        this.payloadSize = this.getPayloadSize(payload);
        this.msgSeqId = msgSeqId;
    }

    public ExecutionMessage(long execStateId, String workerId, String workerGroup, String msgId, ExecStatus status, Execution executionObject, Payload payload, int msgSeqId) {
        this.execStateId = execStateId;
        this.workerId = workerId;
        this.workerGroup = workerGroup;
        this.msgId = msgId;
        this.status = status;
        this.executionObject = executionObject;
        this.payload = payload;
        this.payloadSize = this.getPayloadSize(payload);
        this.msgSeqId = msgSeqId;
    }

    public boolean isStepPersist() {
        return this.stepPersist;
    }

    public void setStepPersist(boolean stepPersist) {
        this.stepPersist = stepPersist;
    }

    public String getStepPersistId() {
        return this.stepPersistId;
    }

    public void setStepPersistId(String stepPersistId) {
        this.stepPersistId = stepPersistId;
    }

    public Execution getExecutionObject() {
        return this.executionObject;
    }

    public void setExecutionObject(Execution executionObject) {
        this.executionObject = executionObject;
    }

    public Long getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Long createDate) {
        this.createDate = createDate;
    }

    public long getExecStateId() {
        return this.execStateId;
    }

    public void setExecStateId(long id) {
        this.execStateId = id;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public void setMsgId(String msg_id) {
        this.msgId = msg_id;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public String getWorkerGroup() {
        return this.workerGroup;
    }

    @JsonIgnore
    public String getMsgUniqueId() {
        return this.msgId + ":" + this.msgSeqId;
    }

    public ExecStatus getStatus() {
        return this.status;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public void setWorkerGroup(String workerGroup) {
        this.workerGroup = workerGroup;
    }

    public void setPayload(Payload payload) {
        this.payload = payload;
        this.payloadSize = this.getPayloadSize(payload) + 16 + 4 + 4;
    }

    public long getPayloadSize() {
        return this.payloadSize;
    }

    public void setPayloadSize(long payloadSize) {
        this.payloadSize = payloadSize;
    }

    public int getMsgSeqId() {
        return this.msgSeqId;
    }

    public void setStatus(ExecStatus status) {
        this.status = status;
    }

    public synchronized void incMsgSeqId() {
        ++this.msgSeqId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public int getWeight() {
        return 1;
    }

    public String getId() {
        return this.workerKey;
    }

    public String getWorkerKey() {
        return this.workerKey;
    }

    public ExecutionMessage setWorkerKey(String workerKey) {
        this.workerKey = workerKey;
        return this;
    }

    private int getPayloadSize(Payload payload) {
        return payload != null ? payload.getData().length : 0;
    }

    public List<Message> shrink(List<Message> messages) {
        if (messages.size() > 2) {
            ArrayList<Message> resultAfterShrink = new ArrayList<Message>();
            ExecutionMessage firstMessage = (ExecutionMessage)messages.get(0);
            ExecutionMessage secondMessage = (ExecutionMessage)messages.get(1);
            List<Message> toPersistMessages = this.filerToPersistMessages(messages.subList(2, messages.size() - 1));
            ExecutionMessage lastMessage = (ExecutionMessage)messages.get(messages.size() - 1);
            if (firstMessage.getStatus().equals((Object)ExecStatus.IN_PROGRESS)) {
                resultAfterShrink.add(secondMessage);
                resultAfterShrink.addAll(toPersistMessages);
                resultAfterShrink.add(lastMessage);
                return resultAfterShrink;
            }
            resultAfterShrink.add(firstMessage);
            if (secondMessage.isStepPersist() && secondMessage.getStatus().equals((Object)ExecStatus.FINISHED)) {
                resultAfterShrink.add(secondMessage);
            }
            resultAfterShrink.addAll(toPersistMessages);
            resultAfterShrink.add(lastMessage);
            return resultAfterShrink;
        }
        return messages;
    }

    protected List<Message> filerToPersistMessages(List<Message> messages) {
        ArrayList<Message> result = new ArrayList<Message>();
        for (Message msg : messages) {
            if (!((ExecutionMessage)msg).isStepPersist() || !((ExecutionMessage)msg).getStatus().equals((Object)ExecStatus.FINISHED)) continue;
            result.add(msg);
        }
        return result;
    }

    private String messagesToString(List<Message> messages) {
        StringBuilder str = new StringBuilder();
        for (Message m : messages) {
            str.append(m.toString()).append("\n");
        }
        return str.toString();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        boolean isAck = this.getExecutionObject() == null;
        str.append(" ExecutionId:").append(this.msgId).append(" ExecStateId:").append(this.execStateId).append(" Status:").append((Object)this.status).append(" WorkerKey:").append(this.getId()).append(" IsAck:").append(isAck);
        return str.toString();
    }

    public Object clone() {
        try {
            ExecutionMessage cloned = (ExecutionMessage)super.clone();
            if (this.payload != null) {
                cloned.payload = (Payload)this.payload.clone();
            }
            return cloned;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to clone message", ex);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionMessage that = (ExecutionMessage)o;
        return new EqualsBuilder().append(this.execStateId, that.execStateId).append(this.msgSeqId, that.msgSeqId).append((Object)this.msgId, (Object)that.msgId).append((Object)this.payload, (Object)that.payload).append(this.payloadSize, that.payloadSize).append((Object)this.status, (Object)that.status).append((Object)this.workerGroup, (Object)that.workerGroup).append((Object)this.workerId, (Object)that.workerId).append((Object)this.createDate, (Object)that.createDate).isEquals();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.workerId, this.workerGroup, this.msgId, this.status, this.payload, this.msgSeqId, this.execStateId, this.createDate});
    }
}

