/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.engine.queue.entities;

import io.cloudslang.engine.queue.entities.Payload;
import io.cloudslang.engine.queue.entities.SensitiveDataHandler;
import io.cloudslang.score.facade.entities.Execution;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ExecutionMessageConverter {
    @Autowired(required=false)
    private SensitiveDataHandler sensitiveDataHandler;

    public <T> T extractExecution(Payload payload) {
        return this.objFromBytes(payload.getData());
    }

    public Payload createPayload(Execution execution) {
        return this.createPayload(execution, false);
    }

    public Payload createPayload(Execution execution, boolean setContainsSensitiveData) {
        boolean encrypted = setContainsSensitiveData || this.checkContainsSensitiveData(execution);
        return new Payload(true, encrypted, this.objToBytes(execution));
    }

    private boolean checkContainsSensitiveData(Execution execution) {
        return this.sensitiveDataHandler != null && this.sensitiveDataHandler.containsSensitiveData(execution.getSystemContext(), execution.getContexts());
    }

    private <T> T objFromBytes(byte[] bytes) {
        Object object;
        ObjectInputStream ois = null;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            BufferedInputStream bis = new BufferedInputStream(is);
            ois = new ObjectInputStream(bis);
            object = ois.readObject();
        }
        catch (IOException | ClassNotFoundException ex) {
            try {
                throw new RuntimeException("Failed to read execution plan from byte[]. Error: ", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ois);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)ois);
        return (T)object;
    }

    private byte[] objToBytes(Object obj) {
        byte[] byArray;
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(bout);
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            byArray = bout.toByteArray();
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException("Failed to serialize execution plan. Error: ", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(oos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)oos);
        return byArray;
    }
}

