/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.engine.queue.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.cloudslang.engine.node.entities.WorkerNode;
import io.cloudslang.engine.queue.entities.ExecStatus;
import io.cloudslang.engine.queue.entities.Payload;
import io.cloudslang.orchestrator.entities.Message;
import io.cloudslang.score.facade.entities.Execution;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.builder.EqualsBuilder;

public class ExecutionMessage
implements Message,
Cloneable {
    private static final long serialVersionUID = 3523623124812765964L;
    public static final long EMPTY_EXEC_STATE_ID = -1L;
    public static final String EMPTY_WORKER = "EMPTY";
    private long execStateId;
    private String workerId;
    private String workerGroup;
    private ExecStatus status;
    private Payload payload;
    private int msgSeqId;
    private String msgId;
    private Date createDate;
    private transient String workerKey;
    private transient Execution executionObject;

    public ExecutionMessage() {
        this.execStateId = -1L;
        this.workerId = EMPTY_WORKER;
        this.workerGroup = "";
        this.status = ExecStatus.INIT;
        this.payload = null;
        this.msgSeqId = -1;
        this.msgId = "";
        this.createDate = null;
    }

    public ExecutionMessage(String executionId, Payload payload) {
        this.execStateId = -1L;
        this.workerId = EMPTY_WORKER;
        this.workerGroup = WorkerNode.DEFAULT_WORKER_GROUPS[0];
        this.msgId = String.valueOf(executionId);
        this.status = ExecStatus.PENDING;
        this.payload = payload;
        this.msgSeqId = 0;
    }

    public ExecutionMessage(long execStateId, String workerId, String workerGroup, String msgId, ExecStatus status, Payload payload, int msgSeqId, Date createDate) {
        this.execStateId = execStateId;
        this.workerId = workerId;
        this.workerGroup = workerGroup;
        this.msgId = msgId;
        this.status = status;
        this.payload = payload;
        this.msgSeqId = msgSeqId;
        this.createDate = createDate;
    }

    public ExecutionMessage(long execStateId, String workerId, String workerGroup, String msgId, ExecStatus status, Payload payload, int msgSeqId) {
        this.execStateId = execStateId;
        this.workerId = workerId;
        this.workerGroup = workerGroup;
        this.msgId = msgId;
        this.status = status;
        this.payload = payload;
        this.msgSeqId = msgSeqId;
    }

    public ExecutionMessage(long execStateId, String workerId, String workerGroup, String msgId, ExecStatus status, Execution executionObject, Payload payload, int msgSeqId) {
        this.execStateId = execStateId;
        this.workerId = workerId;
        this.workerGroup = workerGroup;
        this.msgId = msgId;
        this.status = status;
        this.executionObject = executionObject;
        this.payload = payload;
        this.msgSeqId = msgSeqId;
    }

    public Execution getExecutionObject() {
        return this.executionObject;
    }

    public void setExecutionObject(Execution executionObject) {
        this.executionObject = executionObject;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public long getExecStateId() {
        return this.execStateId;
    }

    public void setExecStateId(long id) {
        this.execStateId = id;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public void setMsgId(String msg_id) {
        this.msgId = msg_id;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public String getWorkerGroup() {
        return this.workerGroup;
    }

    @JsonIgnore
    public String getMsgUniqueId() {
        return this.msgId + ":" + this.msgSeqId;
    }

    public ExecStatus getStatus() {
        return this.status;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public void setWorkerGroup(String workerGroup) {
        this.workerGroup = workerGroup;
    }

    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    public int getMsgSeqId() {
        return this.msgSeqId;
    }

    public void setStatus(ExecStatus status) {
        this.status = status;
    }

    public synchronized void incMsgSeqId() {
        ++this.msgSeqId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public int getWeight() {
        return 1;
    }

    public String getId() {
        return this.workerKey;
    }

    public String getWorkerKey() {
        return this.workerKey;
    }

    public ExecutionMessage setWorkerKey(String workerKey) {
        this.workerKey = workerKey;
        return this;
    }

    public List<Message> shrink(List<Message> messages) {
        if (messages.size() > 2) {
            ExecutionMessage firstMessage = (ExecutionMessage)messages.get(0);
            ExecutionMessage secondMessage = (ExecutionMessage)messages.get(1);
            ExecutionMessage lastMessage = (ExecutionMessage)messages.get(messages.size() - 1);
            if (firstMessage.getStatus().equals((Object)ExecStatus.IN_PROGRESS)) {
                return Arrays.asList(secondMessage, lastMessage);
            }
            return Arrays.asList(firstMessage, lastMessage);
        }
        return messages;
    }

    private String messagesToString(List<Message> messages) {
        StringBuilder str = new StringBuilder();
        for (Message m : messages) {
            str.append(m.toString()).append("\n");
        }
        return str.toString();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        boolean isAck = this.getExecutionObject() == null;
        str.append(" ExecutionId:").append(this.msgId).append(" ExecStateId:").append(this.execStateId).append(" Status:").append((Object)this.status).append(" WorkerKey:").append(this.getId()).append(" IsAck:").append(isAck);
        return str.toString();
    }

    public Object clone() {
        try {
            ExecutionMessage cloned = (ExecutionMessage)super.clone();
            if (this.payload != null) {
                cloned.payload = (Payload)this.payload.clone();
            }
            return cloned;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to clone message", ex);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionMessage that = (ExecutionMessage)o;
        return new EqualsBuilder().append(this.execStateId, that.execStateId).append(this.msgSeqId, that.msgSeqId).append((Object)this.msgId, (Object)that.msgId).append((Object)this.payload, (Object)that.payload).append((Object)this.status, (Object)that.status).append((Object)this.workerGroup, (Object)that.workerGroup).append((Object)this.workerId, (Object)that.workerId).append((Object)this.createDate, (Object)that.createDate).isEquals();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.workerId, this.workerGroup, this.msgId, this.status, this.payload, this.msgSeqId, this.execStateId, this.createDate});
    }
}

