/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.engine.node.entities;

import io.cloudslang.engine.data.AbstractIdentifiable;
import io.cloudslang.engine.node.entities.Worker;
import io.cloudslang.score.api.nodes.WorkerStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.SelectBeforeUpdate;

@Entity
@Table(name="OO_WORKER_NODES")
@DynamicUpdate(value=true)
@SelectBeforeUpdate(value=true)
public class WorkerNode
extends AbstractIdentifiable
implements Worker {
    public static final String[] DEFAULT_WORKER_GROUPS = new String[]{"RAS_Operator_Path"};
    @Column(name="UUID", nullable=false, unique=true, length=48)
    private String uuid;
    @Column(name="STATUS", nullable=false, length=20)
    private WorkerStatus status;
    @Column(name="IS_ACTIVE", nullable=false)
    private boolean active = true;
    @Column(name="HOST_NAME", length=128, nullable=false)
    private String hostName;
    @Column(name="INSTALL_PATH", nullable=false)
    private String installPath;
    @Size(max=255)
    @Column(name="DESCRIPTION", length=255)
    private String description;
    @Column(name="PASSWORD", length=80, nullable=false)
    private String password;
    @Size(max=64)
    @Column(name="OS", length=64)
    private String os;
    @Size(max=64)
    @Column(name="JVM", length=64)
    private String jvm;
    @Size(max=16)
    @Column(name="DOT_NET_VERSION", length=16)
    private String dotNetVersion;
    @Column(name="ACK_TIME")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date ackTime;
    @Column(name="IS_DELETED", nullable=false)
    private boolean deleted = false;
    @Column(name="ACK_VERSION", nullable=false)
    private long ackVersion;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="OO_WORKER_GROUPS", joinColumns={@JoinColumn(name="WORKER_ID")})
    @Column(name="GROUP_NAME")
    private List<String> groups = new ArrayList<String>();
    @Column(name="BULK_NUMBER", length=48)
    private String bulkNumber;
    @Column(name="WRV", length=48)
    private String workerRecoveryVersion;

    @Override
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public WorkerStatus getStatus() {
        return this.status;
    }

    public void setStatus(WorkerStatus status) {
        this.status = status;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @Override
    public String getInstallPath() {
        return this.installPath;
    }

    public void setInstallPath(String installPath) {
        this.installPath = installPath;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    @Override
    public String getJvm() {
        return this.jvm;
    }

    public void setJvm(String jvm) {
        this.jvm = jvm;
    }

    @Override
    public String getDotNetVersion() {
        return this.dotNetVersion;
    }

    public void setDotNetVersion(String dotNetVersion) {
        this.dotNetVersion = dotNetVersion;
    }

    public Date getAckTime() {
        return this.ackTime;
    }

    public void setAckTime(Date ackTime) {
        this.ackTime = ackTime;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public List<String> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public long getAckVersion() {
        return this.ackVersion;
    }

    public void setAckVersion(long ackVersion) {
        this.ackVersion = ackVersion;
    }

    public String getBulkNumber() {
        return this.bulkNumber;
    }

    public void setBulkNumber(String bulkNumber) {
        this.bulkNumber = bulkNumber;
    }

    public String getWorkerRecoveryVersion() {
        return this.workerRecoveryVersion;
    }

    public void setWorkerRecoveryVersion(String workerRecoveryVersion) {
        this.workerRecoveryVersion = workerRecoveryVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkerNode)) {
            return false;
        }
        WorkerNode that = (WorkerNode)o;
        return new EqualsBuilder().append((Object)this.uuid, (Object)that.uuid).append((Object)this.description, (Object)that.description).append((Object)this.hostName, (Object)that.hostName).append((Object)this.installPath, (Object)that.installPath).append(this.active, that.active).append((Object)this.ackTime, (Object)that.ackTime).append(this.ackVersion, that.ackVersion).append((Object)this.os, (Object)that.os).append((Object)this.jvm, (Object)that.jvm).append((Object)this.dotNetVersion, (Object)that.dotNetVersion).append(this.groups, that.groups).append((Object)this.bulkNumber, (Object)that.bulkNumber).append((Object)this.workerRecoveryVersion, (Object)that.workerRecoveryVersion).isEquals();
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.description, this.hostName, this.installPath, this.active, this.ackVersion, this.ackTime, this.os, this.jvm, this.dotNetVersion, this.groups, this.bulkNumber, this.workerRecoveryVersion);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("UUID", (Object)this.uuid).append("active", this.active).append("ackTime", (Object)this.ackTime).append("ackVersion", this.ackVersion).append("host", (Object)this.hostName).append("path", (Object)this.installPath).append("OS", (Object)this.os).append("JVM", (Object)this.jvm).append(".NET", (Object)this.dotNetVersion).append("groups", this.groups).append("bulkNumber", (Object)this.bulkNumber).append("workerRecoveryVersion", (Object)this.workerRecoveryVersion).toString();
    }
}

