/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.runtime.api.python.enums;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public enum PythonStrategy {
    PYTHON_EXECUTOR("python-executor"),
    PYTHON("python"),
    JYTHON("jython");

    private final String strategyName;

    private PythonStrategy(String strategyName) {
        this.strategyName = strategyName;
    }

    public static PythonStrategy getPythonStrategy(String givenStrategy, PythonStrategy defaultStrategy) {
        Validate.notNull((Object)((Object)defaultStrategy), (String)"Default strategy cannot be null.", (Object[])new Object[0]);
        return Arrays.stream(PythonStrategy.values()).filter(strategy -> StringUtils.equalsIgnoreCase((CharSequence)strategy.getStrategyName(), (CharSequence)givenStrategy)).findFirst().orElse(defaultStrategy);
    }

    public String getStrategyName() {
        return this.strategyName;
    }
}

