/*
 * Decompiled with CFR 0.152.
 */
package io.citrine.lolo.util;

import io.citrine.lolo.PredictionResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class LoloPyDataLoader$ {
    public static LoloPyDataLoader$ MODULE$;

    static {
        new LoloPyDataLoader$();
    }

    public Seq<Vector<Object>> getFeatureArray(byte[] input, Integer numAttributes, boolean bigEndian) {
        ByteOrder ordering = bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        ByteBuffer buffer = ByteBuffer.wrap(input).order(ordering);
        int nDigits = input.length / 8;
        return ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nDigits).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x -> buffer.getDouble(x * 8), IndexedSeq$.MODULE$.canBuildFrom())).grouped(Predef$.MODULE$.Integer2int(numAttributes)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toVector()).toVector();
    }

    public Seq<Object> get1DArray(byte[] input, boolean getDouble, boolean bigEndian) {
        Vector vector;
        ByteOrder ordering = bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        ByteBuffer buffer = ByteBuffer.wrap(input).order(ordering);
        if (getDouble) {
            int nDigits = input.length / 8;
            vector = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nDigits).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x -> buffer.getDouble(x * 8), IndexedSeq$.MODULE$.canBuildFrom())).toVector();
        } else {
            int nDigits = input.length / 4;
            vector = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nDigits).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> buffer.getInt(x * 4), IndexedSeq$.MODULE$.canBuildFrom())).toVector();
        }
        return vector;
    }

    public Seq<Tuple2<Vector<Object>, Object>> zipTrainingData(Seq<Vector<Object>> X, Seq<Object> y) {
        return (Seq)X.zip(y, Seq$.MODULE$.canBuildFrom());
    }

    public byte[] getRegressionExpected(PredictionResult<Object> predictionResult) {
        Seq<Object> predResults = predictionResult.getExpected();
        ByteBuffer buffer = ByteBuffer.allocate(predResults.length() * 8).order(ByteOrder.nativeOrder());
        predResults.foreach((Function1 & Serializable & scala.Serializable)x$1 -> buffer.putDouble(BoxesRunTime.unboxToDouble((Object)x$1)));
        return buffer.array();
    }

    public byte[] getRegressionUncertainty(PredictionResult<Object> predictionResult) {
        Seq predResults = (Seq)predictionResult.getUncertainty().get();
        ByteBuffer buffer = ByteBuffer.allocate(predResults.length() * 8).order(ByteOrder.nativeOrder());
        predResults.foreach((Function1 & Serializable & scala.Serializable)x$1 -> buffer.putDouble(BoxesRunTime.unboxToDouble((Object)x$1)));
        return buffer.array();
    }

    public byte[] getClassifierExpected(PredictionResult<Object> predictionResult) {
        Seq<Object> expect = predictionResult.getExpected();
        ByteBuffer buffer = ByteBuffer.allocate(expect.length() * 4).order(ByteOrder.nativeOrder());
        expect.foreach((Function1 & Serializable & scala.Serializable)x$1 -> buffer.putInt(BoxesRunTime.unboxToInt((Object)x$1)));
        return buffer.array();
    }

    public byte[] getClassifierProbabilities(PredictionResult<Object> predictionResult, int nClasses) {
        Range classes = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nClasses);
        Seq probs = (Seq)((Seq)predictionResult.getUncertainty().get()).map((Function1 & Serializable & scala.Serializable)x -> (IndexedSeq)classes.map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> BoxesRunTime.unboxToDouble((Object)x.getOrElse((Object)BoxesRunTime.boxToInteger((int)i), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0)), IndexedSeq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        ByteBuffer buffer = ByteBuffer.allocate(nClasses * probs.length() * 8).order(ByteOrder.nativeOrder());
        ((IterableLike)probs.flatten((Function1)Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> buffer.putDouble(BoxesRunTime.unboxToDouble((Object)x$1)));
        return buffer.array();
    }

    public byte[] serializeObject(Object obj, int compressLevel) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DeflaterOutputStream compressedStream = new DeflaterOutputStream((OutputStream)stream, new Deflater(compressLevel));
        ObjectOutputStream oos = new ObjectOutputStream(compressedStream);
        oos.writeObject(obj);
        oos.close();
        compressedStream.close();
        return stream.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public Object deserializeObject(byte[] bytes) {
        void var3_3;
        ObjectInputStream stream = new ObjectInputStream(new InflaterInputStream(new ByteArrayInputStream(bytes)));
        Object obj = stream.readObject();
        stream.close();
        return var3_3;
    }

    private LoloPyDataLoader$() {
        MODULE$ = this;
    }
}

