package types;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


public enum SortType implements IXtumlType {

    UNINITIALIZED_ENUM( -1 ),
    ASCENDING( 1 ),
    DESCENDING( 2 ),
    NONE( 0 );

    private final int value;

    SortType() {
        value = -1;
    }

    SortType( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( IXtumlType value ) throws XtumlException {
        if (value instanceof SortType) {
            return null != value && this.value == ((SortType)value).getValue();
        }
        else return false;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static SortType deserialize(Object o) throws XtumlException {
        if (o instanceof SortType) {
            return (SortType)o;
        }
        else if (o instanceof Integer) {
            return valueOf((int)o);
        }
        else if (o instanceof String) {
            try {
                return valueOf(Integer.parseInt((String)o));
            }
            catch (NumberFormatException e1) {
                Matcher m = Pattern.compile("([A-Za-z][A-Za-z0-9_]*)::([A-Za-z][A-Za-z0-9_]*)").matcher((String)o);
                if (m.matches() && "sorttype".equals(m.group(1).toLowerCase())) {
                    try {
                        return Enum.valueOf(SortType.class, m.group(2).toUpperCase());
                    } catch (IllegalArgumentException e2) {/* do nothing */}
                }
            }
        }
        throw new XtumlException("Cannot deserialize value: " + o != null ? o.toString() : "null");
    }

    public static SortType valueOf(int value) {
        switch( value ) {
        case 1:
            return ASCENDING;
        case 2:
            return DESCENDING;
        case 0:
            return NONE;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
