package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


public enum StateEnum implements IXtumlType {

    UNINITIALIZED_ENUM( -1 ),
    DISABLED( 0 ),
    ENABLED( 1 );

    private final int value;

    StateEnum() {
        value = -1;
    }

    StateEnum( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( IXtumlType value ) throws XtumlException {
        if (value instanceof StateEnum) {
            return null != value && this.value == ((StateEnum)value).getValue();
        }
        else return false;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static StateEnum deserialize(Object o) throws XtumlException {
        if (o instanceof StateEnum) {
            return (StateEnum)o;
        }
        else if (o instanceof Integer) {
            return valueOf((int)o);
        }
        else if (o instanceof String) {
            try {
                return valueOf(Integer.parseInt((String)o));
            }
            catch (NumberFormatException e1) {
                Matcher m = Pattern.compile("([A-Za-z][A-Za-z0-9_]*)::([A-Za-z][A-Za-z0-9_]*)").matcher((String)o);
                if (m.matches() && "stateenum".equals(m.group(1).toLowerCase())) {
                    try {
                        return Enum.valueOf(StateEnum.class, m.group(2).toUpperCase());
                    } catch (IllegalArgumentException e2) {/* do nothing */}
                }
            }
        }
        throw new XtumlException("Cannot deserialize value: " + o != null ? o.toString() : "null");
    }

    public static StateEnum valueOf(int value) {
        switch( value ) {
        case 0:
            return DISABLED;
        case 1:
            return ENABLED;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
