package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


public enum ParseStatus implements IXtumlType {

    UNINITIALIZED_ENUM( -1 ),
    DONOTPARSE( 0 ),
    PARSEINITIAL( 1 ),
    PARSESUCCESSFUL( 2 ),
    PARSEUNSUCCESSFUL( 3 );

    private final int value;

    ParseStatus() {
        value = -1;
    }

    ParseStatus( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( IXtumlType value ) throws XtumlException {
        if (value instanceof ParseStatus) {
            return null != value && this.value == ((ParseStatus)value).getValue();
        }
        else return false;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static ParseStatus deserialize(Object o) throws XtumlException {
        if (o instanceof ParseStatus) {
            return (ParseStatus)o;
        }
        else if (o instanceof Integer) {
            return valueOf((int)o);
        }
        else if (o instanceof String) {
            try {
                return valueOf(Integer.parseInt((String)o));
            }
            catch (NumberFormatException e1) {
                Matcher m = Pattern.compile("([A-Za-z][A-Za-z0-9_]*)::([A-Za-z][A-Za-z0-9_]*)").matcher((String)o);
                if (m.matches() && "parsestatus".equals(m.group(1).toLowerCase())) {
                    try {
                        return Enum.valueOf(ParseStatus.class, m.group(2).toUpperCase());
                    } catch (IllegalArgumentException e2) {/* do nothing */}
                }
            }
        }
        throw new XtumlException("Cannot deserialize value: " + o != null ? o.toString() : "null");
    }

    public static ParseStatus valueOf(int value) {
        switch( value ) {
        case 0:
            return DONOTPARSE;
        case 1:
            return PARSEINITIAL;
        case 2:
            return PARSESUCCESSFUL;
        case 3:
            return PARSEUNSUCCESSFUL;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
