package io.ciera.tool.sql.ooaofooa.subsystem.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.association.ClassInAssociation;
import io.ciera.tool.sql.ooaofooa.association.ClassInAssociationSet;
import io.ciera.tool.sql.ooaofooa.association.impl.ClassInAssociationSetImpl;
import io.ciera.tool.sql.ooaofooa.packageableelement.PackageableElement;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.PackageableElementImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.ImportedClass;
import io.ciera.tool.sql.ooaofooa.subsystem.ModelClass;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ModelClassImpl;


public class ImportedClassImpl extends ModelInstance<ImportedClass,Sql> implements ImportedClass {

    public static final String KEY_LETTERS = "O_IOBJ";
    public static final ImportedClass EMPTY_IMPORTEDCLASS = new EmptyImportedClass();

    private Sql context;

    // constructors
    private ImportedClassImpl( Sql context ) {
        this.context = context;
        ref_IObj_ID = UniqueId.random();
        ref_Obj_ID = UniqueId.random();
        m_Modl_Typ = 0;
        m_SS_IDdeprecated = UniqueId.random();
        m_Obj_Name = "";
        m_Obj_KL = "";
        R101_represents_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
        R202_is_used_for_spanning_associations_as_ClassInAssociation_set = new ClassInAssociationSetImpl();
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }

    private ImportedClassImpl( Sql context, UniqueId instanceId, UniqueId ref_IObj_ID, UniqueId ref_Obj_ID, int m_Modl_Typ, UniqueId m_SS_IDdeprecated, String m_Obj_Name, String m_Obj_KL ) {
        super(instanceId);
        this.context = context;
        this.ref_IObj_ID = ref_IObj_ID;
        this.ref_Obj_ID = ref_Obj_ID;
        this.m_Modl_Typ = m_Modl_Typ;
        this.m_SS_IDdeprecated = m_SS_IDdeprecated;
        this.m_Obj_Name = m_Obj_Name;
        this.m_Obj_KL = m_Obj_KL;
        R101_represents_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
        R202_is_used_for_spanning_associations_as_ClassInAssociation_set = new ClassInAssociationSetImpl();
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }

    public static ImportedClass create( Sql context ) throws XtumlException {
        ImportedClass newImportedClass = new ImportedClassImpl( context );
        if ( context.addInstance( newImportedClass ) ) {
            newImportedClass.getRunContext().addChange(new InstanceCreatedDelta(newImportedClass, KEY_LETTERS));
            return newImportedClass;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ImportedClass create( Sql context, UniqueId ref_IObj_ID, UniqueId ref_Obj_ID, int m_Modl_Typ, UniqueId m_SS_IDdeprecated, String m_Obj_Name, String m_Obj_KL ) throws XtumlException {
        return create(context, UniqueId.random(), ref_IObj_ID, ref_Obj_ID, m_Modl_Typ, m_SS_IDdeprecated, m_Obj_Name, m_Obj_KL);
    }

    public static ImportedClass create( Sql context, UniqueId instanceId, UniqueId ref_IObj_ID, UniqueId ref_Obj_ID, int m_Modl_Typ, UniqueId m_SS_IDdeprecated, String m_Obj_Name, String m_Obj_KL ) throws XtumlException {
        ImportedClass newImportedClass = new ImportedClassImpl( context, instanceId, ref_IObj_ID, ref_Obj_ID, m_Modl_Typ, m_SS_IDdeprecated, m_Obj_Name, m_Obj_KL );
        if ( context.addInstance( newImportedClass ) ) {
            return newImportedClass;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_IObj_ID;
    @Override
    public void setIObj_ID(UniqueId ref_IObj_ID) throws XtumlException {
        checkLiving();
        if (ref_IObj_ID.inequality( this.ref_IObj_ID)) {
            final UniqueId oldValue = this.ref_IObj_ID;
            this.ref_IObj_ID = ref_IObj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_IObj_ID", oldValue, this.ref_IObj_ID));
            if ( !R202_is_used_for_spanning_associations_as_ClassInAssociation().isEmpty() ) R202_is_used_for_spanning_associations_as_ClassInAssociation().setIObj_ID( ref_IObj_ID );
        }
    }
    @Override
    public UniqueId getIObj_ID() throws XtumlException {
        checkLiving();
        return ref_IObj_ID;
    }
    private UniqueId ref_Obj_ID;
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
        return ref_Obj_ID;
    }
    @Override
    public void setObj_ID(UniqueId ref_Obj_ID) throws XtumlException {
        checkLiving();
        if (ref_Obj_ID.inequality( this.ref_Obj_ID)) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
        }
    }
    private int m_Modl_Typ;
    @Override
    public void setModl_Typ(int m_Modl_Typ) throws XtumlException {
        checkLiving();
        if (m_Modl_Typ != this.m_Modl_Typ) {
            final int oldValue = this.m_Modl_Typ;
            this.m_Modl_Typ = m_Modl_Typ;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Modl_Typ", oldValue, this.m_Modl_Typ));
        }
    }
    @Override
    public int getModl_Typ() throws XtumlException {
        checkLiving();
        return m_Modl_Typ;
    }
    private UniqueId m_SS_IDdeprecated;
    @Override
    public UniqueId getSS_IDdeprecated() throws XtumlException {
        checkLiving();
        return m_SS_IDdeprecated;
    }
    @Override
    public void setSS_IDdeprecated(UniqueId m_SS_IDdeprecated) throws XtumlException {
        checkLiving();
        if (m_SS_IDdeprecated.inequality( this.m_SS_IDdeprecated)) {
            final UniqueId oldValue = this.m_SS_IDdeprecated;
            this.m_SS_IDdeprecated = m_SS_IDdeprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_SS_IDdeprecated", oldValue, this.m_SS_IDdeprecated));
        }
    }
    private String m_Obj_Name;
    @Override
    public void setObj_Name(String m_Obj_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Obj_Name, this.m_Obj_Name)) {
            final String oldValue = this.m_Obj_Name;
            this.m_Obj_Name = m_Obj_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Obj_Name", oldValue, this.m_Obj_Name));
        }
    }
    @Override
    public String getObj_Name() throws XtumlException {
        checkLiving();
        return m_Obj_Name;
    }
    private String m_Obj_KL;
    @Override
    public void setObj_KL(String m_Obj_KL) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Obj_KL, this.m_Obj_KL)) {
            final String oldValue = this.m_Obj_KL;
            this.m_Obj_KL = m_Obj_KL;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Obj_KL", oldValue, this.m_Obj_KL));
        }
    }
    @Override
    public String getObj_KL() throws XtumlException {
        checkLiving();
        return m_Obj_KL;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getIObj_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ModelClass R101_represents_ModelClass_inst;
    @Override
    public void setR101_represents_ModelClass( ModelClass inst ) {
        R101_represents_ModelClass_inst = inst;
    }
    @Override
    public ModelClass R101_represents_ModelClass() throws XtumlException {
        return R101_represents_ModelClass_inst;
    }
    private ClassInAssociationSet R202_is_used_for_spanning_associations_as_ClassInAssociation_set;
    @Override
    public void addR202_is_used_for_spanning_associations_as_ClassInAssociation( ClassInAssociation inst ) {
        R202_is_used_for_spanning_associations_as_ClassInAssociation_set.add(inst);
    }
    @Override
    public void removeR202_is_used_for_spanning_associations_as_ClassInAssociation( ClassInAssociation inst ) {
        R202_is_used_for_spanning_associations_as_ClassInAssociation_set.remove(inst);
    }
    @Override
    public ClassInAssociationSet R202_is_used_for_spanning_associations_as_ClassInAssociation() throws XtumlException {
        return R202_is_used_for_spanning_associations_as_ClassInAssociation_set;
    }
    private PackageableElement R8001_is_a_PackageableElement_inst;
    @Override
    public void setR8001_is_a_PackageableElement( PackageableElement inst ) {
        R8001_is_a_PackageableElement_inst = inst;
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() throws XtumlException {
        return R8001_is_a_PackageableElement_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ImportedClass self() {
        return this;
    }

    @Override
    public ImportedClass oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_IMPORTEDCLASS;
    }

}

class EmptyImportedClass extends ModelInstance<ImportedClass,Sql> implements ImportedClass {

    // attributes
    public void setIObj_ID( UniqueId ref_IObj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getIObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setModl_Typ( int m_Modl_Typ ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getModl_Typ() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getSS_IDdeprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSS_IDdeprecated( UniqueId m_SS_IDdeprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setObj_Name( String m_Obj_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getObj_Name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setObj_KL( String m_Obj_KL ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getObj_KL() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ModelClass R101_represents_ModelClass() {
        return ModelClassImpl.EMPTY_MODELCLASS;
    }
    @Override
    public ClassInAssociationSet R202_is_used_for_spanning_associations_as_ClassInAssociation() {
        return (new ClassInAssociationSetImpl());
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() {
        return PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }


    @Override
    public String getKeyLetters() {
        return ImportedClassImpl.KEY_LETTERS;
    }

    @Override
    public ImportedClass self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ImportedClass oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ImportedClassImpl.EMPTY_IMPORTEDCLASS;
    }

}
