package io.ciera.tool.sql.ooaofooa.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.statemachine.CantHappen;
import io.ciera.tool.sql.ooaofooa.statemachine.StateEventMatrixEntry;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.StateEventMatrixEntryImpl;


public class CantHappenImpl extends ModelInstance<CantHappen,Sql> implements CantHappen {

    public static final String KEY_LETTERS = "SM_CH";
    public static final CantHappen EMPTY_CANTHAPPEN = new EmptyCantHappen();

    private Sql context;

    // constructors
    private CantHappenImpl( Sql context ) {
        this.context = context;
        ref_SMstt_ID = UniqueId.random();
        ref_SMevt_ID = UniqueId.random();
        ref_SM_ID = UniqueId.random();
        m_SMspd_IDdeprecated = UniqueId.random();
        m_Descrip = "";
        R504_is_a_StateEventMatrixEntry_inst = StateEventMatrixEntryImpl.EMPTY_STATEEVENTMATRIXENTRY;
    }

    private CantHappenImpl( Sql context, UniqueId instanceId, UniqueId ref_SMstt_ID, UniqueId ref_SMevt_ID, UniqueId ref_SM_ID, UniqueId m_SMspd_IDdeprecated, String m_Descrip ) {
        super(instanceId);
        this.context = context;
        this.ref_SMstt_ID = ref_SMstt_ID;
        this.ref_SMevt_ID = ref_SMevt_ID;
        this.ref_SM_ID = ref_SM_ID;
        this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
        this.m_Descrip = m_Descrip;
        R504_is_a_StateEventMatrixEntry_inst = StateEventMatrixEntryImpl.EMPTY_STATEEVENTMATRIXENTRY;
    }

    public static CantHappen create( Sql context ) throws XtumlException {
        CantHappen newCantHappen = new CantHappenImpl( context );
        if ( context.addInstance( newCantHappen ) ) {
            newCantHappen.getRunContext().addChange(new InstanceCreatedDelta(newCantHappen, KEY_LETTERS));
            return newCantHappen;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static CantHappen create( Sql context, UniqueId ref_SMstt_ID, UniqueId ref_SMevt_ID, UniqueId ref_SM_ID, UniqueId m_SMspd_IDdeprecated, String m_Descrip ) throws XtumlException {
        return create(context, UniqueId.random(), ref_SMstt_ID, ref_SMevt_ID, ref_SM_ID, m_SMspd_IDdeprecated, m_Descrip);
    }

    public static CantHappen create( Sql context, UniqueId instanceId, UniqueId ref_SMstt_ID, UniqueId ref_SMevt_ID, UniqueId ref_SM_ID, UniqueId m_SMspd_IDdeprecated, String m_Descrip ) throws XtumlException {
        CantHappen newCantHappen = new CantHappenImpl( context, instanceId, ref_SMstt_ID, ref_SMevt_ID, ref_SM_ID, m_SMspd_IDdeprecated, m_Descrip );
        if ( context.addInstance( newCantHappen ) ) {
            return newCantHappen;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_SMstt_ID;
    @Override
    public UniqueId getSMstt_ID() throws XtumlException {
        checkLiving();
        return ref_SMstt_ID;
    }
    @Override
    public void setSMstt_ID(UniqueId ref_SMstt_ID) throws XtumlException {
        checkLiving();
        if (ref_SMstt_ID.inequality( this.ref_SMstt_ID)) {
            final UniqueId oldValue = this.ref_SMstt_ID;
            this.ref_SMstt_ID = ref_SMstt_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SMstt_ID", oldValue, this.ref_SMstt_ID));
        }
    }
    private UniqueId ref_SMevt_ID;
    @Override
    public void setSMevt_ID(UniqueId ref_SMevt_ID) throws XtumlException {
        checkLiving();
        if (ref_SMevt_ID.inequality( this.ref_SMevt_ID)) {
            final UniqueId oldValue = this.ref_SMevt_ID;
            this.ref_SMevt_ID = ref_SMevt_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SMevt_ID", oldValue, this.ref_SMevt_ID));
        }
    }
    @Override
    public UniqueId getSMevt_ID() throws XtumlException {
        checkLiving();
        return ref_SMevt_ID;
    }
    private UniqueId ref_SM_ID;
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
        return ref_SM_ID;
    }
    @Override
    public void setSM_ID(UniqueId ref_SM_ID) throws XtumlException {
        checkLiving();
        if (ref_SM_ID.inequality( this.ref_SM_ID)) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
        }
    }
    private UniqueId m_SMspd_IDdeprecated;
    @Override
    public void setSMspd_IDdeprecated(UniqueId m_SMspd_IDdeprecated) throws XtumlException {
        checkLiving();
        if (m_SMspd_IDdeprecated.inequality( this.m_SMspd_IDdeprecated)) {
            final UniqueId oldValue = this.m_SMspd_IDdeprecated;
            this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_SMspd_IDdeprecated", oldValue, this.m_SMspd_IDdeprecated));
        }
    }
    @Override
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        checkLiving();
        return m_SMspd_IDdeprecated;
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSMstt_ID(), getSMevt_ID(), getSM_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private StateEventMatrixEntry R504_is_a_StateEventMatrixEntry_inst;
    @Override
    public void setR504_is_a_StateEventMatrixEntry( StateEventMatrixEntry inst ) {
        R504_is_a_StateEventMatrixEntry_inst = inst;
    }
    @Override
    public StateEventMatrixEntry R504_is_a_StateEventMatrixEntry() throws XtumlException {
        return R504_is_a_StateEventMatrixEntry_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public CantHappen self() {
        return this;
    }

    @Override
    public CantHappen oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_CANTHAPPEN;
    }

}

class EmptyCantHappen extends ModelInstance<CantHappen,Sql> implements CantHappen {

    // attributes
    public UniqueId getSMstt_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSMstt_ID( UniqueId ref_SMstt_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSMevt_ID( UniqueId ref_SMevt_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMevt_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSMspd_IDdeprecated( UniqueId m_SMspd_IDdeprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public StateEventMatrixEntry R504_is_a_StateEventMatrixEntry() {
        return StateEventMatrixEntryImpl.EMPTY_STATEEVENTMATRIXENTRY;
    }


    @Override
    public String getKeyLetters() {
        return CantHappenImpl.KEY_LETTERS;
    }

    @Override
    public CantHappen self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public CantHappen oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return CantHappenImpl.EMPTY_CANTHAPPEN;
    }

}
