package io.ciera.tool.sql.ooaofooa.persistenceassociations.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.C_C;
import io.ciera.tool.sql.ooaofooa.component.Satisfaction;
import io.ciera.tool.sql.ooaofooa.component.impl.C_CImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.SatisfactionImpl;
import io.ciera.tool.sql.ooaofooa.persistenceassociations.SatisfactionInComponent;


public class SatisfactionInComponentImpl extends ModelInstance<SatisfactionInComponent,Sql> implements SatisfactionInComponent {

    public static final String KEY_LETTERS = "PA_SIC";
    public static final SatisfactionInComponent EMPTY_SATISFACTIONINCOMPONENT = new EmptySatisfactionInComponent();

    private Sql context;

    // constructors
    private SatisfactionInComponentImpl( Sql context ) {
        this.context = context;
        ref_Component_Id = UniqueId.random();
        ref_Satisfaction_Id = UniqueId.random();
        R9000_C_C_inst = C_CImpl.EMPTY_C_C;
        R9000_Satisfaction_inst = SatisfactionImpl.EMPTY_SATISFACTION;
    }

    private SatisfactionInComponentImpl( Sql context, UniqueId instanceId, UniqueId ref_Component_Id, UniqueId ref_Satisfaction_Id ) {
        super(instanceId);
        this.context = context;
        this.ref_Component_Id = ref_Component_Id;
        this.ref_Satisfaction_Id = ref_Satisfaction_Id;
        R9000_C_C_inst = C_CImpl.EMPTY_C_C;
        R9000_Satisfaction_inst = SatisfactionImpl.EMPTY_SATISFACTION;
    }

    public static SatisfactionInComponent create( Sql context ) throws XtumlException {
        SatisfactionInComponent newSatisfactionInComponent = new SatisfactionInComponentImpl( context );
        if ( context.addInstance( newSatisfactionInComponent ) ) {
            newSatisfactionInComponent.getRunContext().addChange(new InstanceCreatedDelta(newSatisfactionInComponent, KEY_LETTERS));
            return newSatisfactionInComponent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static SatisfactionInComponent create( Sql context, UniqueId ref_Component_Id, UniqueId ref_Satisfaction_Id ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Component_Id, ref_Satisfaction_Id);
    }

    public static SatisfactionInComponent create( Sql context, UniqueId instanceId, UniqueId ref_Component_Id, UniqueId ref_Satisfaction_Id ) throws XtumlException {
        SatisfactionInComponent newSatisfactionInComponent = new SatisfactionInComponentImpl( context, instanceId, ref_Component_Id, ref_Satisfaction_Id );
        if ( context.addInstance( newSatisfactionInComponent ) ) {
            return newSatisfactionInComponent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Component_Id;
    @Override
    public void setComponent_Id(UniqueId ref_Component_Id) throws XtumlException {
        checkLiving();
        if (ref_Component_Id.inequality( this.ref_Component_Id)) {
            final UniqueId oldValue = this.ref_Component_Id;
            this.ref_Component_Id = ref_Component_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Component_Id", oldValue, this.ref_Component_Id));
        }
    }
    @Override
    public UniqueId getComponent_Id() throws XtumlException {
        checkLiving();
        return ref_Component_Id;
    }
    private UniqueId ref_Satisfaction_Id;
    @Override
    public void setSatisfaction_Id(UniqueId ref_Satisfaction_Id) throws XtumlException {
        checkLiving();
        if (ref_Satisfaction_Id.inequality( this.ref_Satisfaction_Id)) {
            final UniqueId oldValue = this.ref_Satisfaction_Id;
            this.ref_Satisfaction_Id = ref_Satisfaction_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Satisfaction_Id", oldValue, this.ref_Satisfaction_Id));
        }
    }
    @Override
    public UniqueId getSatisfaction_Id() throws XtumlException {
        checkLiving();
        return ref_Satisfaction_Id;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getComponent_Id(), getSatisfaction_Id());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private C_C R9000_C_C_inst;
    @Override
    public void setR9000_C_C( C_C inst ) {
        R9000_C_C_inst = inst;
    }
    @Override
    public C_C R9000_C_C() throws XtumlException {
        return R9000_C_C_inst;
    }
    private Satisfaction R9000_Satisfaction_inst;
    @Override
    public void setR9000_Satisfaction( Satisfaction inst ) {
        R9000_Satisfaction_inst = inst;
    }
    @Override
    public Satisfaction R9000_Satisfaction() throws XtumlException {
        return R9000_Satisfaction_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public SatisfactionInComponent self() {
        return this;
    }

    @Override
    public SatisfactionInComponent oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_SATISFACTIONINCOMPONENT;
    }

}

class EmptySatisfactionInComponent extends ModelInstance<SatisfactionInComponent,Sql> implements SatisfactionInComponent {

    // attributes
    public void setComponent_Id( UniqueId ref_Component_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getComponent_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSatisfaction_Id( UniqueId ref_Satisfaction_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSatisfaction_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public C_C R9000_C_C() {
        return C_CImpl.EMPTY_C_C;
    }
    @Override
    public Satisfaction R9000_Satisfaction() {
        return SatisfactionImpl.EMPTY_SATISFACTION;
    }


    @Override
    public String getKeyLetters() {
        return SatisfactionInComponentImpl.KEY_LETTERS;
    }

    @Override
    public SatisfactionInComponent self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public SatisfactionInComponent oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return SatisfactionInComponentImpl.EMPTY_SATISFACTIONINCOMPONENT;
    }

}
