package io.ciera.tool.sql.ooaofooa.invocation.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.ACT_SMT;
import io.ciera.tool.sql.ooaofooa.body.impl.ACT_SMTImpl;
import io.ciera.tool.sql.ooaofooa.domain.Bridge;
import io.ciera.tool.sql.ooaofooa.domain.impl.BridgeImpl;
import io.ciera.tool.sql.ooaofooa.invocation.BridgeInvocation;
import io.ciera.tool.sql.ooaofooa.value.V_PAR;
import io.ciera.tool.sql.ooaofooa.value.V_PARSet;
import io.ciera.tool.sql.ooaofooa.value.impl.V_PARSetImpl;


public class BridgeInvocationImpl extends ModelInstance<BridgeInvocation,Sql> implements BridgeInvocation {

    public static final String KEY_LETTERS = "ACT_BRG";
    public static final BridgeInvocation EMPTY_BRIDGEINVOCATION = new EmptyBridgeInvocation();

    private Sql context;

    // constructors
    private BridgeInvocationImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        ref_Brg_ID = UniqueId.random();
        m_bridgeNameLineNumber = 0;
        m_bridgeNameColumn = 0;
        m_externalEntityKeyLettersLineNumber = 0;
        m_externalEntityKeyLettersColumn = 0;
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R628_takes_V_PAR_set = new V_PARSetImpl();
        R674_is_an_invocation_of_Bridge_inst = BridgeImpl.EMPTY_BRIDGE;
    }

    private BridgeInvocationImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Brg_ID, int m_bridgeNameLineNumber, int m_bridgeNameColumn, int m_externalEntityKeyLettersLineNumber, int m_externalEntityKeyLettersColumn ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        this.ref_Brg_ID = ref_Brg_ID;
        this.m_bridgeNameLineNumber = m_bridgeNameLineNumber;
        this.m_bridgeNameColumn = m_bridgeNameColumn;
        this.m_externalEntityKeyLettersLineNumber = m_externalEntityKeyLettersLineNumber;
        this.m_externalEntityKeyLettersColumn = m_externalEntityKeyLettersColumn;
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R628_takes_V_PAR_set = new V_PARSetImpl();
        R674_is_an_invocation_of_Bridge_inst = BridgeImpl.EMPTY_BRIDGE;
    }

    public static BridgeInvocation create( Sql context ) throws XtumlException {
        BridgeInvocation newBridgeInvocation = new BridgeInvocationImpl( context );
        if ( context.addInstance( newBridgeInvocation ) ) {
            newBridgeInvocation.getRunContext().addChange(new InstanceCreatedDelta(newBridgeInvocation, KEY_LETTERS));
            return newBridgeInvocation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static BridgeInvocation create( Sql context, UniqueId ref_Statement_ID, UniqueId ref_Brg_ID, int m_bridgeNameLineNumber, int m_bridgeNameColumn, int m_externalEntityKeyLettersLineNumber, int m_externalEntityKeyLettersColumn ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Statement_ID, ref_Brg_ID, m_bridgeNameLineNumber, m_bridgeNameColumn, m_externalEntityKeyLettersLineNumber, m_externalEntityKeyLettersColumn);
    }

    public static BridgeInvocation create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Brg_ID, int m_bridgeNameLineNumber, int m_bridgeNameColumn, int m_externalEntityKeyLettersLineNumber, int m_externalEntityKeyLettersColumn ) throws XtumlException {
        BridgeInvocation newBridgeInvocation = new BridgeInvocationImpl( context, instanceId, ref_Statement_ID, ref_Brg_ID, m_bridgeNameLineNumber, m_bridgeNameColumn, m_externalEntityKeyLettersLineNumber, m_externalEntityKeyLettersColumn );
        if ( context.addInstance( newBridgeInvocation ) ) {
            return newBridgeInvocation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
        return ref_Statement_ID;
    }
    @Override
    public void setStatement_ID(UniqueId ref_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Statement_ID.inequality( this.ref_Statement_ID)) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
            if ( !R628_takes_V_PAR().isEmpty() ) R628_takes_V_PAR().setStatement_ID( ref_Statement_ID );
        }
    }
    private UniqueId ref_Brg_ID;
    @Override
    public UniqueId getBrg_ID() throws XtumlException {
        checkLiving();
        return ref_Brg_ID;
    }
    @Override
    public void setBrg_ID(UniqueId ref_Brg_ID) throws XtumlException {
        checkLiving();
        if (ref_Brg_ID.inequality( this.ref_Brg_ID)) {
            final UniqueId oldValue = this.ref_Brg_ID;
            this.ref_Brg_ID = ref_Brg_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Brg_ID", oldValue, this.ref_Brg_ID));
        }
    }
    private int m_bridgeNameLineNumber;
    @Override
    public int getBridgeNameLineNumber() throws XtumlException {
        checkLiving();
        return m_bridgeNameLineNumber;
    }
    @Override
    public void setBridgeNameLineNumber(int m_bridgeNameLineNumber) throws XtumlException {
        checkLiving();
        if (m_bridgeNameLineNumber != this.m_bridgeNameLineNumber) {
            final int oldValue = this.m_bridgeNameLineNumber;
            this.m_bridgeNameLineNumber = m_bridgeNameLineNumber;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_bridgeNameLineNumber", oldValue, this.m_bridgeNameLineNumber));
        }
    }
    private int m_bridgeNameColumn;
    @Override
    public void setBridgeNameColumn(int m_bridgeNameColumn) throws XtumlException {
        checkLiving();
        if (m_bridgeNameColumn != this.m_bridgeNameColumn) {
            final int oldValue = this.m_bridgeNameColumn;
            this.m_bridgeNameColumn = m_bridgeNameColumn;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_bridgeNameColumn", oldValue, this.m_bridgeNameColumn));
        }
    }
    @Override
    public int getBridgeNameColumn() throws XtumlException {
        checkLiving();
        return m_bridgeNameColumn;
    }
    private int m_externalEntityKeyLettersLineNumber;
    @Override
    public void setExternalEntityKeyLettersLineNumber(int m_externalEntityKeyLettersLineNumber) throws XtumlException {
        checkLiving();
        if (m_externalEntityKeyLettersLineNumber != this.m_externalEntityKeyLettersLineNumber) {
            final int oldValue = this.m_externalEntityKeyLettersLineNumber;
            this.m_externalEntityKeyLettersLineNumber = m_externalEntityKeyLettersLineNumber;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_externalEntityKeyLettersLineNumber", oldValue, this.m_externalEntityKeyLettersLineNumber));
        }
    }
    @Override
    public int getExternalEntityKeyLettersLineNumber() throws XtumlException {
        checkLiving();
        return m_externalEntityKeyLettersLineNumber;
    }
    private int m_externalEntityKeyLettersColumn;
    @Override
    public void setExternalEntityKeyLettersColumn(int m_externalEntityKeyLettersColumn) throws XtumlException {
        checkLiving();
        if (m_externalEntityKeyLettersColumn != this.m_externalEntityKeyLettersColumn) {
            final int oldValue = this.m_externalEntityKeyLettersColumn;
            this.m_externalEntityKeyLettersColumn = m_externalEntityKeyLettersColumn;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_externalEntityKeyLettersColumn", oldValue, this.m_externalEntityKeyLettersColumn));
        }
    }
    @Override
    public int getExternalEntityKeyLettersColumn() throws XtumlException {
        checkLiving();
        return m_externalEntityKeyLettersColumn;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ACT_SMT R603_is_a_ACT_SMT_inst;
    @Override
    public void setR603_is_a_ACT_SMT( ACT_SMT inst ) {
        R603_is_a_ACT_SMT_inst = inst;
    }
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() throws XtumlException {
        return R603_is_a_ACT_SMT_inst;
    }
    private V_PARSet R628_takes_V_PAR_set;
    @Override
    public void addR628_takes_V_PAR( V_PAR inst ) {
        R628_takes_V_PAR_set.add(inst);
    }
    @Override
    public void removeR628_takes_V_PAR( V_PAR inst ) {
        R628_takes_V_PAR_set.remove(inst);
    }
    @Override
    public V_PARSet R628_takes_V_PAR() throws XtumlException {
        return R628_takes_V_PAR_set;
    }
    private Bridge R674_is_an_invocation_of_Bridge_inst;
    @Override
    public void setR674_is_an_invocation_of_Bridge( Bridge inst ) {
        R674_is_an_invocation_of_Bridge_inst = inst;
    }
    @Override
    public Bridge R674_is_an_invocation_of_Bridge() throws XtumlException {
        return R674_is_an_invocation_of_Bridge_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public BridgeInvocation self() {
        return this;
    }

    @Override
    public BridgeInvocation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_BRIDGEINVOCATION;
    }

}

class EmptyBridgeInvocation extends ModelInstance<BridgeInvocation,Sql> implements BridgeInvocation {

    // attributes
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getBrg_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBrg_ID( UniqueId ref_Brg_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getBridgeNameLineNumber() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBridgeNameLineNumber( int m_bridgeNameLineNumber ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setBridgeNameColumn( int m_bridgeNameColumn ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getBridgeNameColumn() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setExternalEntityKeyLettersLineNumber( int m_externalEntityKeyLettersLineNumber ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getExternalEntityKeyLettersLineNumber() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setExternalEntityKeyLettersColumn( int m_externalEntityKeyLettersColumn ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getExternalEntityKeyLettersColumn() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() {
        return ACT_SMTImpl.EMPTY_ACT_SMT;
    }
    @Override
    public V_PARSet R628_takes_V_PAR() {
        return (new V_PARSetImpl());
    }
    @Override
    public Bridge R674_is_an_invocation_of_Bridge() {
        return BridgeImpl.EMPTY_BRIDGE;
    }


    @Override
    public String getKeyLetters() {
        return BridgeInvocationImpl.KEY_LETTERS;
    }

    @Override
    public BridgeInvocation self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public BridgeInvocation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return BridgeInvocationImpl.EMPTY_BRIDGEINVOCATION;
    }

}
