package io.ciera.tool.sql.ooaofooa.interaction.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.elementpackaging.EP_PKG;
import io.ciera.tool.sql.ooaofooa.elementpackaging.impl.EP_PKGImpl;
import io.ciera.tool.sql.ooaofooa.interaction.InteractionParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.PackageParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.impl.InteractionParticipantImpl;


public class PackageParticipantImpl extends ModelInstance<PackageParticipant,Sql> implements PackageParticipant {

    public static final String KEY_LETTERS = "SQ_PP";
    public static final PackageParticipant EMPTY_PACKAGEPARTICIPANT = new EmptyPackageParticipant();

    private Sql context;

    // constructors
    private PackageParticipantImpl( Sql context ) {
        this.context = context;
        ref_Part_ID = UniqueId.random();
        ref_Package_ID = UniqueId.random();
        m_Label = "";
        m_InformalName = "";
        m_Descrip = "";
        m_isFormal = false;
        R930_is_a_InteractionParticipant_inst = InteractionParticipantImpl.EMPTY_INTERACTIONPARTICIPANT;
        R956_represents_EP_PKG_inst = EP_PKGImpl.EMPTY_EP_PKG;
    }

    private PackageParticipantImpl( Sql context, UniqueId instanceId, UniqueId ref_Part_ID, UniqueId ref_Package_ID, String m_Label, String m_InformalName, String m_Descrip, boolean m_isFormal ) {
        super(instanceId);
        this.context = context;
        this.ref_Part_ID = ref_Part_ID;
        this.ref_Package_ID = ref_Package_ID;
        this.m_Label = m_Label;
        this.m_InformalName = m_InformalName;
        this.m_Descrip = m_Descrip;
        this.m_isFormal = m_isFormal;
        R930_is_a_InteractionParticipant_inst = InteractionParticipantImpl.EMPTY_INTERACTIONPARTICIPANT;
        R956_represents_EP_PKG_inst = EP_PKGImpl.EMPTY_EP_PKG;
    }

    public static PackageParticipant create( Sql context ) throws XtumlException {
        PackageParticipant newPackageParticipant = new PackageParticipantImpl( context );
        if ( context.addInstance( newPackageParticipant ) ) {
            newPackageParticipant.getRunContext().addChange(new InstanceCreatedDelta(newPackageParticipant, KEY_LETTERS));
            return newPackageParticipant;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static PackageParticipant create( Sql context, UniqueId ref_Part_ID, UniqueId ref_Package_ID, String m_Label, String m_InformalName, String m_Descrip, boolean m_isFormal ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Part_ID, ref_Package_ID, m_Label, m_InformalName, m_Descrip, m_isFormal);
    }

    public static PackageParticipant create( Sql context, UniqueId instanceId, UniqueId ref_Part_ID, UniqueId ref_Package_ID, String m_Label, String m_InformalName, String m_Descrip, boolean m_isFormal ) throws XtumlException {
        PackageParticipant newPackageParticipant = new PackageParticipantImpl( context, instanceId, ref_Part_ID, ref_Package_ID, m_Label, m_InformalName, m_Descrip, m_isFormal );
        if ( context.addInstance( newPackageParticipant ) ) {
            return newPackageParticipant;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Part_ID;
    @Override
    public UniqueId getPart_ID() throws XtumlException {
        checkLiving();
        return ref_Part_ID;
    }
    @Override
    public void setPart_ID(UniqueId ref_Part_ID) throws XtumlException {
        checkLiving();
        if (ref_Part_ID.inequality( this.ref_Part_ID)) {
            final UniqueId oldValue = this.ref_Part_ID;
            this.ref_Part_ID = ref_Part_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Part_ID", oldValue, this.ref_Part_ID));
        }
    }
    private UniqueId ref_Package_ID;
    @Override
    public UniqueId getPackage_ID() throws XtumlException {
        checkLiving();
        return ref_Package_ID;
    }
    @Override
    public void setPackage_ID(UniqueId ref_Package_ID) throws XtumlException {
        checkLiving();
        if (ref_Package_ID.inequality( this.ref_Package_ID)) {
            final UniqueId oldValue = this.ref_Package_ID;
            this.ref_Package_ID = ref_Package_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Package_ID", oldValue, this.ref_Package_ID));
        }
    }
    private String m_Label;
    @Override
    public void setLabel(String m_Label) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Label, this.m_Label)) {
            final String oldValue = this.m_Label;
            this.m_Label = m_Label;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Label", oldValue, this.m_Label));
        }
    }
    @Override
    public String getLabel() throws XtumlException {
        checkLiving();
        return m_Label;
    }
    private String m_InformalName;
    @Override
    public void setInformalName(String m_InformalName) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_InformalName, this.m_InformalName)) {
            final String oldValue = this.m_InformalName;
            this.m_InformalName = m_InformalName;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_InformalName", oldValue, this.m_InformalName));
        }
    }
    @Override
    public String getInformalName() throws XtumlException {
        checkLiving();
        return m_InformalName;
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    private boolean m_isFormal;
    @Override
    public void setIsFormal(boolean m_isFormal) throws XtumlException {
        checkLiving();
        if (m_isFormal != this.m_isFormal) {
            final boolean oldValue = this.m_isFormal;
            this.m_isFormal = m_isFormal;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_isFormal", oldValue, this.m_isFormal));
        }
    }
    @Override
    public boolean getIsFormal() throws XtumlException {
        checkLiving();
        return m_isFormal;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getPart_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private InteractionParticipant R930_is_a_InteractionParticipant_inst;
    @Override
    public void setR930_is_a_InteractionParticipant( InteractionParticipant inst ) {
        R930_is_a_InteractionParticipant_inst = inst;
    }
    @Override
    public InteractionParticipant R930_is_a_InteractionParticipant() throws XtumlException {
        return R930_is_a_InteractionParticipant_inst;
    }
    private EP_PKG R956_represents_EP_PKG_inst;
    @Override
    public void setR956_represents_EP_PKG( EP_PKG inst ) {
        R956_represents_EP_PKG_inst = inst;
    }
    @Override
    public EP_PKG R956_represents_EP_PKG() throws XtumlException {
        return R956_represents_EP_PKG_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public PackageParticipant self() {
        return this;
    }

    @Override
    public PackageParticipant oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_PACKAGEPARTICIPANT;
    }

}

class EmptyPackageParticipant extends ModelInstance<PackageParticipant,Sql> implements PackageParticipant {

    // attributes
    public UniqueId getPart_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPart_ID( UniqueId ref_Part_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPackage_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPackage_ID( UniqueId ref_Package_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setLabel( String m_Label ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLabel() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setInformalName( String m_InformalName ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getInformalName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setIsFormal( boolean m_isFormal ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getIsFormal() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public InteractionParticipant R930_is_a_InteractionParticipant() {
        return InteractionParticipantImpl.EMPTY_INTERACTIONPARTICIPANT;
    }
    @Override
    public EP_PKG R956_represents_EP_PKG() {
        return EP_PKGImpl.EMPTY_EP_PKG;
    }


    @Override
    public String getKeyLetters() {
        return PackageParticipantImpl.KEY_LETTERS;
    }

    @Override
    public PackageParticipant self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public PackageParticipant oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return PackageParticipantImpl.EMPTY_PACKAGEPARTICIPANT;
    }

}
