package io.ciera.tool.sql.ooaofooa.interaction.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.interaction.ClassParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.ClassParticipantAttribute;
import io.ciera.tool.sql.ooaofooa.interaction.FormalAttribute;
import io.ciera.tool.sql.ooaofooa.interaction.InformalAttribute;
import io.ciera.tool.sql.ooaofooa.interaction.impl.ClassParticipantImpl;
import io.ciera.tool.sql.ooaofooa.interaction.impl.FormalAttributeImpl;
import io.ciera.tool.sql.ooaofooa.interaction.impl.InformalAttributeImpl;


public class ClassParticipantAttributeImpl extends ModelInstance<ClassParticipantAttribute,Sql> implements ClassParticipantAttribute {

    public static final String KEY_LETTERS = "SQ_CPA";
    public static final ClassParticipantAttribute EMPTY_CLASSPARTICIPANTATTRIBUTE = new EmptyClassParticipantAttribute();

    private Sql context;

    // constructors
    private ClassParticipantAttributeImpl( Sql context ) {
        this.context = context;
        m_Ia_ID = UniqueId.random();
        m_Name = "";
        m_Type = "";
        ref_Part_ID = UniqueId.random();
        m_Descrip = "";
        R935_belongs_to_ClassParticipant_inst = ClassParticipantImpl.EMPTY_CLASSPARTICIPANT;
        R947_is_a_FormalAttribute_inst = FormalAttributeImpl.EMPTY_FORMALATTRIBUTE;
        R947_is_a_InformalAttribute_inst = InformalAttributeImpl.EMPTY_INFORMALATTRIBUTE;
    }

    private ClassParticipantAttributeImpl( Sql context, UniqueId instanceId, UniqueId m_Ia_ID, String m_Name, String m_Type, UniqueId ref_Part_ID, String m_Descrip ) {
        super(instanceId);
        this.context = context;
        this.m_Ia_ID = m_Ia_ID;
        this.m_Name = m_Name;
        this.m_Type = m_Type;
        this.ref_Part_ID = ref_Part_ID;
        this.m_Descrip = m_Descrip;
        R935_belongs_to_ClassParticipant_inst = ClassParticipantImpl.EMPTY_CLASSPARTICIPANT;
        R947_is_a_FormalAttribute_inst = FormalAttributeImpl.EMPTY_FORMALATTRIBUTE;
        R947_is_a_InformalAttribute_inst = InformalAttributeImpl.EMPTY_INFORMALATTRIBUTE;
    }

    public static ClassParticipantAttribute create( Sql context ) throws XtumlException {
        ClassParticipantAttribute newClassParticipantAttribute = new ClassParticipantAttributeImpl( context );
        if ( context.addInstance( newClassParticipantAttribute ) ) {
            newClassParticipantAttribute.getRunContext().addChange(new InstanceCreatedDelta(newClassParticipantAttribute, KEY_LETTERS));
            return newClassParticipantAttribute;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ClassParticipantAttribute create( Sql context, UniqueId m_Ia_ID, String m_Name, String m_Type, UniqueId ref_Part_ID, String m_Descrip ) throws XtumlException {
        return create(context, UniqueId.random(), m_Ia_ID, m_Name, m_Type, ref_Part_ID, m_Descrip);
    }

    public static ClassParticipantAttribute create( Sql context, UniqueId instanceId, UniqueId m_Ia_ID, String m_Name, String m_Type, UniqueId ref_Part_ID, String m_Descrip ) throws XtumlException {
        ClassParticipantAttribute newClassParticipantAttribute = new ClassParticipantAttributeImpl( context, instanceId, m_Ia_ID, m_Name, m_Type, ref_Part_ID, m_Descrip );
        if ( context.addInstance( newClassParticipantAttribute ) ) {
            return newClassParticipantAttribute;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Ia_ID;
    @Override
    public UniqueId getIa_ID() throws XtumlException {
        checkLiving();
        return m_Ia_ID;
    }
    @Override
    public void setIa_ID(UniqueId m_Ia_ID) throws XtumlException {
        checkLiving();
        if (m_Ia_ID.inequality( this.m_Ia_ID)) {
            final UniqueId oldValue = this.m_Ia_ID;
            this.m_Ia_ID = m_Ia_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Ia_ID", oldValue, this.m_Ia_ID));
            if ( !R947_is_a_InformalAttribute().isEmpty() ) R947_is_a_InformalAttribute().setIa_ID( m_Ia_ID );
            if ( !R947_is_a_FormalAttribute().isEmpty() ) R947_is_a_FormalAttribute().setIa_ID( m_Ia_ID );
        }
    }
    private String m_Name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    private String m_Type;
    @Override
    public void setType(String m_Type) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Type, this.m_Type)) {
            final String oldValue = this.m_Type;
            this.m_Type = m_Type;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Type", oldValue, this.m_Type));
        }
    }
    @Override
    public String getType() throws XtumlException {
        checkLiving();
        return m_Type;
    }
    private UniqueId ref_Part_ID;
    @Override
    public void setPart_ID(UniqueId ref_Part_ID) throws XtumlException {
        checkLiving();
        if (ref_Part_ID.inequality( this.ref_Part_ID)) {
            final UniqueId oldValue = this.ref_Part_ID;
            this.ref_Part_ID = ref_Part_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Part_ID", oldValue, this.ref_Part_ID));
        }
    }
    @Override
    public UniqueId getPart_ID() throws XtumlException {
        checkLiving();
        return ref_Part_ID;
    }
    private String m_Descrip;
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getIa_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ClassParticipant R935_belongs_to_ClassParticipant_inst;
    @Override
    public void setR935_belongs_to_ClassParticipant( ClassParticipant inst ) {
        R935_belongs_to_ClassParticipant_inst = inst;
    }
    @Override
    public ClassParticipant R935_belongs_to_ClassParticipant() throws XtumlException {
        return R935_belongs_to_ClassParticipant_inst;
    }
    private FormalAttribute R947_is_a_FormalAttribute_inst;
    @Override
    public void setR947_is_a_FormalAttribute( FormalAttribute inst ) {
        R947_is_a_FormalAttribute_inst = inst;
    }
    @Override
    public FormalAttribute R947_is_a_FormalAttribute() throws XtumlException {
        return R947_is_a_FormalAttribute_inst;
    }
    private InformalAttribute R947_is_a_InformalAttribute_inst;
    @Override
    public void setR947_is_a_InformalAttribute( InformalAttribute inst ) {
        R947_is_a_InformalAttribute_inst = inst;
    }
    @Override
    public InformalAttribute R947_is_a_InformalAttribute() throws XtumlException {
        return R947_is_a_InformalAttribute_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ClassParticipantAttribute self() {
        return this;
    }

    @Override
    public ClassParticipantAttribute oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_CLASSPARTICIPANTATTRIBUTE;
    }

}

class EmptyClassParticipantAttribute extends ModelInstance<ClassParticipantAttribute,Sql> implements ClassParticipantAttribute {

    // attributes
    public UniqueId getIa_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIa_ID( UniqueId m_Ia_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setType( String m_Type ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getType() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPart_ID( UniqueId ref_Part_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPart_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ClassParticipant R935_belongs_to_ClassParticipant() {
        return ClassParticipantImpl.EMPTY_CLASSPARTICIPANT;
    }
    @Override
    public FormalAttribute R947_is_a_FormalAttribute() {
        return FormalAttributeImpl.EMPTY_FORMALATTRIBUTE;
    }
    @Override
    public InformalAttribute R947_is_a_InformalAttribute() {
        return InformalAttributeImpl.EMPTY_INFORMALATTRIBUTE;
    }


    @Override
    public String getKeyLetters() {
        return ClassParticipantAttributeImpl.KEY_LETTERS;
    }

    @Override
    public ClassParticipantAttribute self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ClassParticipantAttribute oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ClassParticipantAttributeImpl.EMPTY_CLASSPARTICIPANTATTRIBUTE;
    }

}
