package io.ciera.tool.sql.ooaofooa.instance.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.instance.StackFrame;
import io.ciera.tool.sql.ooaofooa.instance.ValueInStackFrame;
import io.ciera.tool.sql.ooaofooa.instance.impl.StackFrameImpl;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class ValueInStackFrameImpl extends ModelInstance<ValueInStackFrame,Sql> implements ValueInStackFrame {

    public static final String KEY_LETTERS = "I_VSF";
    public static final ValueInStackFrame EMPTY_VALUEINSTACKFRAME = new EmptyValueInStackFrame();

    private Sql context;

    // constructors
    private ValueInStackFrameImpl( Sql context ) {
        this.context = context;
        m_ValueInStackFrame_ID = UniqueId.random();
        m_RuntimeValue_ID = UniqueId.random();
        ref_Value_ID = UniqueId.random();
        ref_Stack_Frame_ID = UniqueId.random();
        R2951_StackFrame_inst = StackFrameImpl.EMPTY_STACKFRAME;
        R2978_Value_inst = ValueImpl.EMPTY_VALUE;
    }

    private ValueInStackFrameImpl( Sql context, UniqueId instanceId, UniqueId m_ValueInStackFrame_ID, UniqueId m_RuntimeValue_ID, UniqueId ref_Value_ID, UniqueId ref_Stack_Frame_ID ) {
        super(instanceId);
        this.context = context;
        this.m_ValueInStackFrame_ID = m_ValueInStackFrame_ID;
        this.m_RuntimeValue_ID = m_RuntimeValue_ID;
        this.ref_Value_ID = ref_Value_ID;
        this.ref_Stack_Frame_ID = ref_Stack_Frame_ID;
        R2951_StackFrame_inst = StackFrameImpl.EMPTY_STACKFRAME;
        R2978_Value_inst = ValueImpl.EMPTY_VALUE;
    }

    public static ValueInStackFrame create( Sql context ) throws XtumlException {
        ValueInStackFrame newValueInStackFrame = new ValueInStackFrameImpl( context );
        if ( context.addInstance( newValueInStackFrame ) ) {
            newValueInStackFrame.getRunContext().addChange(new InstanceCreatedDelta(newValueInStackFrame, KEY_LETTERS));
            return newValueInStackFrame;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ValueInStackFrame create( Sql context, UniqueId m_ValueInStackFrame_ID, UniqueId m_RuntimeValue_ID, UniqueId ref_Value_ID, UniqueId ref_Stack_Frame_ID ) throws XtumlException {
        return create(context, UniqueId.random(), m_ValueInStackFrame_ID, m_RuntimeValue_ID, ref_Value_ID, ref_Stack_Frame_ID);
    }

    public static ValueInStackFrame create( Sql context, UniqueId instanceId, UniqueId m_ValueInStackFrame_ID, UniqueId m_RuntimeValue_ID, UniqueId ref_Value_ID, UniqueId ref_Stack_Frame_ID ) throws XtumlException {
        ValueInStackFrame newValueInStackFrame = new ValueInStackFrameImpl( context, instanceId, m_ValueInStackFrame_ID, m_RuntimeValue_ID, ref_Value_ID, ref_Stack_Frame_ID );
        if ( context.addInstance( newValueInStackFrame ) ) {
            return newValueInStackFrame;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_ValueInStackFrame_ID;
    @Override
    public void setValueInStackFrame_ID(UniqueId m_ValueInStackFrame_ID) throws XtumlException {
        checkLiving();
        if (m_ValueInStackFrame_ID.inequality( this.m_ValueInStackFrame_ID)) {
            final UniqueId oldValue = this.m_ValueInStackFrame_ID;
            this.m_ValueInStackFrame_ID = m_ValueInStackFrame_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_ValueInStackFrame_ID", oldValue, this.m_ValueInStackFrame_ID));
        }
    }
    @Override
    public UniqueId getValueInStackFrame_ID() throws XtumlException {
        checkLiving();
        return m_ValueInStackFrame_ID;
    }
    private UniqueId m_RuntimeValue_ID;
    @Override
    public UniqueId getRuntimeValue_ID() throws XtumlException {
        checkLiving();
        return m_RuntimeValue_ID;
    }
    @Override
    public void setRuntimeValue_ID(UniqueId m_RuntimeValue_ID) throws XtumlException {
        checkLiving();
        if (m_RuntimeValue_ID.inequality( this.m_RuntimeValue_ID)) {
            final UniqueId oldValue = this.m_RuntimeValue_ID;
            this.m_RuntimeValue_ID = m_RuntimeValue_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_RuntimeValue_ID", oldValue, this.m_RuntimeValue_ID));
        }
    }
    private UniqueId ref_Value_ID;
    @Override
    public void setValue_ID(UniqueId ref_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Value_ID.inequality( this.ref_Value_ID)) {
            final UniqueId oldValue = this.ref_Value_ID;
            this.ref_Value_ID = ref_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Value_ID", oldValue, this.ref_Value_ID));
        }
    }
    @Override
    public UniqueId getValue_ID() throws XtumlException {
        checkLiving();
        return ref_Value_ID;
    }
    private UniqueId ref_Stack_Frame_ID;
    @Override
    public void setStack_Frame_ID(UniqueId ref_Stack_Frame_ID) throws XtumlException {
        checkLiving();
        if (ref_Stack_Frame_ID.inequality( this.ref_Stack_Frame_ID)) {
            final UniqueId oldValue = this.ref_Stack_Frame_ID;
            this.ref_Stack_Frame_ID = ref_Stack_Frame_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Stack_Frame_ID", oldValue, this.ref_Stack_Frame_ID));
        }
    }
    @Override
    public UniqueId getStack_Frame_ID() throws XtumlException {
        checkLiving();
        return ref_Stack_Frame_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getValueInStackFrame_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private StackFrame R2951_StackFrame_inst;
    @Override
    public void setR2951_StackFrame( StackFrame inst ) {
        R2951_StackFrame_inst = inst;
    }
    @Override
    public StackFrame R2951_StackFrame() throws XtumlException {
        return R2951_StackFrame_inst;
    }
    private Value R2978_Value_inst;
    @Override
    public void setR2978_Value( Value inst ) {
        R2978_Value_inst = inst;
    }
    @Override
    public Value R2978_Value() throws XtumlException {
        return R2978_Value_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ValueInStackFrame self() {
        return this;
    }

    @Override
    public ValueInStackFrame oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_VALUEINSTACKFRAME;
    }

}

class EmptyValueInStackFrame extends ModelInstance<ValueInStackFrame,Sql> implements ValueInStackFrame {

    // attributes
    public void setValueInStackFrame_ID( UniqueId m_ValueInStackFrame_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getValueInStackFrame_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getRuntimeValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRuntimeValue_ID( UniqueId m_RuntimeValue_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStack_Frame_ID( UniqueId ref_Stack_Frame_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getStack_Frame_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public StackFrame R2951_StackFrame() {
        return StackFrameImpl.EMPTY_STACKFRAME;
    }
    @Override
    public Value R2978_Value() {
        return ValueImpl.EMPTY_VALUE;
    }


    @Override
    public String getKeyLetters() {
        return ValueInStackFrameImpl.KEY_LETTERS;
    }

    @Override
    public ValueInStackFrame self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ValueInStackFrame oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ValueInStackFrameImpl.EMPTY_VALUEINSTACKFRAME;
    }

}
