package io.ciera.tool.sql.ooaofooa.instance.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.instance.AttributeValue;
import io.ciera.tool.sql.ooaofooa.instance.I_INS;
import io.ciera.tool.sql.ooaofooa.instance.impl.I_INSImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.O_ATTR;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.O_ATTRImpl;


public class AttributeValueImpl extends ModelInstance<AttributeValue,Sql> implements AttributeValue {

    public static final String KEY_LETTERS = "I_AVL";
    public static final AttributeValue EMPTY_ATTRIBUTEVALUE = new EmptyAttributeValue();

    private Sql context;

    // constructors
    private AttributeValueImpl( Sql context ) {
        this.context = context;
        ref_Inst_ID = UniqueId.random();
        ref_Obj_ID = UniqueId.random();
        ref_Attr_ID = UniqueId.random();
        m_Value = "";
        m_Label = "";
        m_RuntimeValue_ID = UniqueId.random();
        m_Derived_RuntimeValue_ID = UniqueId.random();
        R2909_defines_value_for_characteristic_of_I_INS_inst = I_INSImpl.EMPTY_I_INS;
        R2910_is_instance_of_O_ATTR_inst = O_ATTRImpl.EMPTY_O_ATTR;
    }

    private AttributeValueImpl( Sql context, UniqueId instanceId, UniqueId ref_Inst_ID, UniqueId ref_Obj_ID, UniqueId ref_Attr_ID, String m_Value, String m_Label, UniqueId m_RuntimeValue_ID, UniqueId m_Derived_RuntimeValue_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Inst_ID = ref_Inst_ID;
        this.ref_Obj_ID = ref_Obj_ID;
        this.ref_Attr_ID = ref_Attr_ID;
        this.m_Value = m_Value;
        this.m_Label = m_Label;
        this.m_RuntimeValue_ID = m_RuntimeValue_ID;
        this.m_Derived_RuntimeValue_ID = m_Derived_RuntimeValue_ID;
        R2909_defines_value_for_characteristic_of_I_INS_inst = I_INSImpl.EMPTY_I_INS;
        R2910_is_instance_of_O_ATTR_inst = O_ATTRImpl.EMPTY_O_ATTR;
    }

    public static AttributeValue create( Sql context ) throws XtumlException {
        AttributeValue newAttributeValue = new AttributeValueImpl( context );
        if ( context.addInstance( newAttributeValue ) ) {
            newAttributeValue.getRunContext().addChange(new InstanceCreatedDelta(newAttributeValue, KEY_LETTERS));
            return newAttributeValue;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static AttributeValue create( Sql context, UniqueId ref_Inst_ID, UniqueId ref_Obj_ID, UniqueId ref_Attr_ID, String m_Value, String m_Label, UniqueId m_RuntimeValue_ID, UniqueId m_Derived_RuntimeValue_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Inst_ID, ref_Obj_ID, ref_Attr_ID, m_Value, m_Label, m_RuntimeValue_ID, m_Derived_RuntimeValue_ID);
    }

    public static AttributeValue create( Sql context, UniqueId instanceId, UniqueId ref_Inst_ID, UniqueId ref_Obj_ID, UniqueId ref_Attr_ID, String m_Value, String m_Label, UniqueId m_RuntimeValue_ID, UniqueId m_Derived_RuntimeValue_ID ) throws XtumlException {
        AttributeValue newAttributeValue = new AttributeValueImpl( context, instanceId, ref_Inst_ID, ref_Obj_ID, ref_Attr_ID, m_Value, m_Label, m_RuntimeValue_ID, m_Derived_RuntimeValue_ID );
        if ( context.addInstance( newAttributeValue ) ) {
            return newAttributeValue;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Inst_ID;
    @Override
    public UniqueId getInst_ID() throws XtumlException {
        checkLiving();
        return ref_Inst_ID;
    }
    @Override
    public void setInst_ID(UniqueId ref_Inst_ID) throws XtumlException {
        checkLiving();
        if (ref_Inst_ID.inequality( this.ref_Inst_ID)) {
            final UniqueId oldValue = this.ref_Inst_ID;
            this.ref_Inst_ID = ref_Inst_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Inst_ID", oldValue, this.ref_Inst_ID));
        }
    }
    private UniqueId ref_Obj_ID;
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
        return ref_Obj_ID;
    }
    @Override
    public void setObj_ID(UniqueId ref_Obj_ID) throws XtumlException {
        checkLiving();
        if (ref_Obj_ID.inequality( this.ref_Obj_ID)) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
        }
    }
    private UniqueId ref_Attr_ID;
    @Override
    public void setAttr_ID(UniqueId ref_Attr_ID) throws XtumlException {
        checkLiving();
        if (ref_Attr_ID.inequality( this.ref_Attr_ID)) {
            final UniqueId oldValue = this.ref_Attr_ID;
            this.ref_Attr_ID = ref_Attr_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Attr_ID", oldValue, this.ref_Attr_ID));
        }
    }
    @Override
    public UniqueId getAttr_ID() throws XtumlException {
        checkLiving();
        return ref_Attr_ID;
    }
    private String m_Value;
    @Override
    public String getValue() throws XtumlException {
        checkLiving();
        return m_Value;
    }
    @Override
    public void setValue(String m_Value) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Value, this.m_Value)) {
            final String oldValue = this.m_Value;
            this.m_Value = m_Value;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Value", oldValue, this.m_Value));
        }
    }
    private String m_Label;
    @Override
    public void setLabel(String m_Label) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Label, this.m_Label)) {
            final String oldValue = this.m_Label;
            this.m_Label = m_Label;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Label", oldValue, this.m_Label));
        }
    }
    @Override
    public String getLabel() throws XtumlException {
        checkLiving();
        return m_Label;
    }
    private UniqueId m_RuntimeValue_ID;
    @Override
    public UniqueId getRuntimeValue_ID() throws XtumlException {
        checkLiving();
        return m_RuntimeValue_ID;
    }
    @Override
    public void setRuntimeValue_ID(UniqueId m_RuntimeValue_ID) throws XtumlException {
        checkLiving();
        if (m_RuntimeValue_ID.inequality( this.m_RuntimeValue_ID)) {
            final UniqueId oldValue = this.m_RuntimeValue_ID;
            this.m_RuntimeValue_ID = m_RuntimeValue_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_RuntimeValue_ID", oldValue, this.m_RuntimeValue_ID));
        }
    }
    private UniqueId m_Derived_RuntimeValue_ID;
    @Override
    public UniqueId getDerived_RuntimeValue_ID() throws XtumlException {
        checkLiving();
        return m_Derived_RuntimeValue_ID;
    }
    @Override
    public void setDerived_RuntimeValue_ID(UniqueId m_Derived_RuntimeValue_ID) throws XtumlException {
        checkLiving();
        if (m_Derived_RuntimeValue_ID.inequality( this.m_Derived_RuntimeValue_ID)) {
            final UniqueId oldValue = this.m_Derived_RuntimeValue_ID;
            this.m_Derived_RuntimeValue_ID = m_Derived_RuntimeValue_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Derived_RuntimeValue_ID", oldValue, this.m_Derived_RuntimeValue_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getInst_ID(), getAttr_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private I_INS R2909_defines_value_for_characteristic_of_I_INS_inst;
    @Override
    public void setR2909_defines_value_for_characteristic_of_I_INS( I_INS inst ) {
        R2909_defines_value_for_characteristic_of_I_INS_inst = inst;
    }
    @Override
    public I_INS R2909_defines_value_for_characteristic_of_I_INS() throws XtumlException {
        return R2909_defines_value_for_characteristic_of_I_INS_inst;
    }
    private O_ATTR R2910_is_instance_of_O_ATTR_inst;
    @Override
    public void setR2910_is_instance_of_O_ATTR( O_ATTR inst ) {
        R2910_is_instance_of_O_ATTR_inst = inst;
    }
    @Override
    public O_ATTR R2910_is_instance_of_O_ATTR() throws XtumlException {
        return R2910_is_instance_of_O_ATTR_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public AttributeValue self() {
        return this;
    }

    @Override
    public AttributeValue oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ATTRIBUTEVALUE;
    }

}

class EmptyAttributeValue extends ModelInstance<AttributeValue,Sql> implements AttributeValue {

    // attributes
    public UniqueId getInst_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setInst_ID( UniqueId ref_Inst_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setAttr_ID( UniqueId ref_Attr_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getAttr_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getValue() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setValue( String m_Value ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setLabel( String m_Label ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLabel() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getRuntimeValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRuntimeValue_ID( UniqueId m_RuntimeValue_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getDerived_RuntimeValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDerived_RuntimeValue_ID( UniqueId m_Derived_RuntimeValue_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public I_INS R2909_defines_value_for_characteristic_of_I_INS() {
        return I_INSImpl.EMPTY_I_INS;
    }
    @Override
    public O_ATTR R2910_is_instance_of_O_ATTR() {
        return O_ATTRImpl.EMPTY_O_ATTR;
    }


    @Override
    public String getKeyLetters() {
        return AttributeValueImpl.KEY_LETTERS;
    }

    @Override
    public AttributeValue self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public AttributeValue oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return AttributeValueImpl.EMPTY_ATTRIBUTEVALUE;
    }

}
