package io.ciera.tool.sql.ooaofooa.event.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.event.CreateEventToCreator;
import io.ciera.tool.sql.ooaofooa.event.CreateSMEventStatement;
import io.ciera.tool.sql.ooaofooa.event.impl.CreateSMEventStatementImpl;


public class CreateEventToCreatorImpl extends ModelInstance<CreateEventToCreator,Sql> implements CreateEventToCreator {

    public static final String KEY_LETTERS = "E_CEC";
    public static final CreateEventToCreator EMPTY_CREATEEVENTTOCREATOR = new EmptyCreateEventToCreator();

    private Sql context;

    // constructors
    private CreateEventToCreatorImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        R704_is_a_CreateSMEventStatement_inst = CreateSMEventStatementImpl.EMPTY_CREATESMEVENTSTATEMENT;
    }

    private CreateEventToCreatorImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        R704_is_a_CreateSMEventStatement_inst = CreateSMEventStatementImpl.EMPTY_CREATESMEVENTSTATEMENT;
    }

    public static CreateEventToCreator create( Sql context ) throws XtumlException {
        CreateEventToCreator newCreateEventToCreator = new CreateEventToCreatorImpl( context );
        if ( context.addInstance( newCreateEventToCreator ) ) {
            newCreateEventToCreator.getRunContext().addChange(new InstanceCreatedDelta(newCreateEventToCreator, KEY_LETTERS));
            return newCreateEventToCreator;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static CreateEventToCreator create( Sql context, UniqueId ref_Statement_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Statement_ID);
    }

    public static CreateEventToCreator create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID ) throws XtumlException {
        CreateEventToCreator newCreateEventToCreator = new CreateEventToCreatorImpl( context, instanceId, ref_Statement_ID );
        if ( context.addInstance( newCreateEventToCreator ) ) {
            return newCreateEventToCreator;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
        return ref_Statement_ID;
    }
    @Override
    public void setStatement_ID(UniqueId ref_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Statement_ID.inequality( this.ref_Statement_ID)) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private CreateSMEventStatement R704_is_a_CreateSMEventStatement_inst;
    @Override
    public void setR704_is_a_CreateSMEventStatement( CreateSMEventStatement inst ) {
        R704_is_a_CreateSMEventStatement_inst = inst;
    }
    @Override
    public CreateSMEventStatement R704_is_a_CreateSMEventStatement() throws XtumlException {
        return R704_is_a_CreateSMEventStatement_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public CreateEventToCreator self() {
        return this;
    }

    @Override
    public CreateEventToCreator oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_CREATEEVENTTOCREATOR;
    }

}

class EmptyCreateEventToCreator extends ModelInstance<CreateEventToCreator,Sql> implements CreateEventToCreator {

    // attributes
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public CreateSMEventStatement R704_is_a_CreateSMEventStatement() {
        return CreateSMEventStatementImpl.EMPTY_CREATESMEVENTSTATEMENT;
    }


    @Override
    public String getKeyLetters() {
        return CreateEventToCreatorImpl.KEY_LETTERS;
    }

    @Override
    public CreateEventToCreator self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public CreateEventToCreator oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return CreateEventToCreatorImpl.EMPTY_CREATEEVENTTOCREATOR;
    }

}
