package io.ciera.tool.sql.ooaofooa.domain.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.EnumerationDataType;
import io.ciera.tool.sql.ooaofooa.domain.S_ENUM;
import io.ciera.tool.sql.ooaofooa.domain.impl.EnumerationDataTypeImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.S_ENUMImpl;
import io.ciera.tool.sql.ooaofooa.value.LiteralEnumerator;
import io.ciera.tool.sql.ooaofooa.value.LiteralEnumeratorSet;
import io.ciera.tool.sql.ooaofooa.value.impl.LiteralEnumeratorSetImpl;


public class S_ENUMImpl extends ModelInstance<S_ENUM,Sql> implements S_ENUM {

    public static final String KEY_LETTERS = "S_ENUM";
    public static final S_ENUM EMPTY_S_ENUM = new EmptyS_ENUM();

    private Sql context;

    // constructors
    private S_ENUMImpl( Sql context ) {
        this.context = context;
        m_Enum_ID = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        ref_EDT_DT_ID = UniqueId.random();
        ref_Previous_Enum_ID = UniqueId.random();
        R27_is_defined_by_EnumerationDataType_inst = EnumerationDataTypeImpl.EMPTY_ENUMERATIONDATATYPE;
        R56_precedes_S_ENUM_inst = S_ENUMImpl.EMPTY_S_ENUM;
        R56_succeeds_S_ENUM_inst = S_ENUMImpl.EMPTY_S_ENUM;
        R824_is_value_of_LiteralEnumerator_set = new LiteralEnumeratorSetImpl();
    }

    private S_ENUMImpl( Sql context, UniqueId instanceId, UniqueId m_Enum_ID, String m_Name, String m_Descrip, UniqueId ref_EDT_DT_ID, UniqueId ref_Previous_Enum_ID ) {
        super(instanceId);
        this.context = context;
        this.m_Enum_ID = m_Enum_ID;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        this.ref_EDT_DT_ID = ref_EDT_DT_ID;
        this.ref_Previous_Enum_ID = ref_Previous_Enum_ID;
        R27_is_defined_by_EnumerationDataType_inst = EnumerationDataTypeImpl.EMPTY_ENUMERATIONDATATYPE;
        R56_precedes_S_ENUM_inst = S_ENUMImpl.EMPTY_S_ENUM;
        R56_succeeds_S_ENUM_inst = S_ENUMImpl.EMPTY_S_ENUM;
        R824_is_value_of_LiteralEnumerator_set = new LiteralEnumeratorSetImpl();
    }

    public static S_ENUM create( Sql context ) throws XtumlException {
        S_ENUM newS_ENUM = new S_ENUMImpl( context );
        if ( context.addInstance( newS_ENUM ) ) {
            newS_ENUM.getRunContext().addChange(new InstanceCreatedDelta(newS_ENUM, KEY_LETTERS));
            return newS_ENUM;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static S_ENUM create( Sql context, UniqueId m_Enum_ID, String m_Name, String m_Descrip, UniqueId ref_EDT_DT_ID, UniqueId ref_Previous_Enum_ID ) throws XtumlException {
        return create(context, UniqueId.random(), m_Enum_ID, m_Name, m_Descrip, ref_EDT_DT_ID, ref_Previous_Enum_ID);
    }

    public static S_ENUM create( Sql context, UniqueId instanceId, UniqueId m_Enum_ID, String m_Name, String m_Descrip, UniqueId ref_EDT_DT_ID, UniqueId ref_Previous_Enum_ID ) throws XtumlException {
        S_ENUM newS_ENUM = new S_ENUMImpl( context, instanceId, m_Enum_ID, m_Name, m_Descrip, ref_EDT_DT_ID, ref_Previous_Enum_ID );
        if ( context.addInstance( newS_ENUM ) ) {
            return newS_ENUM;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Enum_ID;
    @Override
    public UniqueId getEnum_ID() throws XtumlException {
        checkLiving();
        return m_Enum_ID;
    }
    @Override
    public void setEnum_ID(UniqueId m_Enum_ID) throws XtumlException {
        checkLiving();
        if (m_Enum_ID.inequality( this.m_Enum_ID)) {
            final UniqueId oldValue = this.m_Enum_ID;
            this.m_Enum_ID = m_Enum_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Enum_ID", oldValue, this.m_Enum_ID));
            if ( !R824_is_value_of_LiteralEnumerator().isEmpty() ) R824_is_value_of_LiteralEnumerator().setEnum_ID( m_Enum_ID );
            if ( !R56_precedes_S_ENUM().isEmpty() ) R56_precedes_S_ENUM().setPrevious_Enum_ID( m_Enum_ID );
        }
    }
    private String m_Name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    private UniqueId ref_EDT_DT_ID;
    @Override
    public void setEDT_DT_ID(UniqueId ref_EDT_DT_ID) throws XtumlException {
        checkLiving();
        if (ref_EDT_DT_ID.inequality( this.ref_EDT_DT_ID)) {
            final UniqueId oldValue = this.ref_EDT_DT_ID;
            this.ref_EDT_DT_ID = ref_EDT_DT_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_EDT_DT_ID", oldValue, this.ref_EDT_DT_ID));
        }
    }
    @Override
    public UniqueId getEDT_DT_ID() throws XtumlException {
        checkLiving();
        return ref_EDT_DT_ID;
    }
    private UniqueId ref_Previous_Enum_ID;
    @Override
    public void setPrevious_Enum_ID(UniqueId ref_Previous_Enum_ID) throws XtumlException {
        checkLiving();
        if (ref_Previous_Enum_ID.inequality( this.ref_Previous_Enum_ID)) {
            final UniqueId oldValue = this.ref_Previous_Enum_ID;
            this.ref_Previous_Enum_ID = ref_Previous_Enum_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Previous_Enum_ID", oldValue, this.ref_Previous_Enum_ID));
        }
    }
    @Override
    public UniqueId getPrevious_Enum_ID() throws XtumlException {
        checkLiving();
        return ref_Previous_Enum_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getEnum_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private EnumerationDataType R27_is_defined_by_EnumerationDataType_inst;
    @Override
    public void setR27_is_defined_by_EnumerationDataType( EnumerationDataType inst ) {
        R27_is_defined_by_EnumerationDataType_inst = inst;
    }
    @Override
    public EnumerationDataType R27_is_defined_by_EnumerationDataType() throws XtumlException {
        return R27_is_defined_by_EnumerationDataType_inst;
    }
    private S_ENUM R56_precedes_S_ENUM_inst;
    @Override
    public void setR56_precedes_S_ENUM( S_ENUM inst ) {
        R56_precedes_S_ENUM_inst = inst;
    }
    @Override
    public S_ENUM R56_precedes_S_ENUM() throws XtumlException {
        return R56_precedes_S_ENUM_inst;
    }
    private S_ENUM R56_succeeds_S_ENUM_inst;
    @Override
    public void setR56_succeeds_S_ENUM( S_ENUM inst ) {
        R56_succeeds_S_ENUM_inst = inst;
    }
    @Override
    public S_ENUM R56_succeeds_S_ENUM() throws XtumlException {
        return R56_succeeds_S_ENUM_inst;
    }
    private LiteralEnumeratorSet R824_is_value_of_LiteralEnumerator_set;
    @Override
    public void addR824_is_value_of_LiteralEnumerator( LiteralEnumerator inst ) {
        R824_is_value_of_LiteralEnumerator_set.add(inst);
    }
    @Override
    public void removeR824_is_value_of_LiteralEnumerator( LiteralEnumerator inst ) {
        R824_is_value_of_LiteralEnumerator_set.remove(inst);
    }
    @Override
    public LiteralEnumeratorSet R824_is_value_of_LiteralEnumerator() throws XtumlException {
        return R824_is_value_of_LiteralEnumerator_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public S_ENUM self() {
        return this;
    }

    @Override
    public S_ENUM oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_S_ENUM;
    }

}

class EmptyS_ENUM extends ModelInstance<S_ENUM,Sql> implements S_ENUM {

    // attributes
    public UniqueId getEnum_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setEnum_ID( UniqueId m_Enum_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setEDT_DT_ID( UniqueId ref_EDT_DT_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getEDT_DT_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPrevious_Enum_ID( UniqueId ref_Previous_Enum_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPrevious_Enum_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public EnumerationDataType R27_is_defined_by_EnumerationDataType() {
        return EnumerationDataTypeImpl.EMPTY_ENUMERATIONDATATYPE;
    }
    @Override
    public S_ENUM R56_precedes_S_ENUM() {
        return S_ENUMImpl.EMPTY_S_ENUM;
    }
    @Override
    public S_ENUM R56_succeeds_S_ENUM() {
        return S_ENUMImpl.EMPTY_S_ENUM;
    }
    @Override
    public LiteralEnumeratorSet R824_is_value_of_LiteralEnumerator() {
        return (new LiteralEnumeratorSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return S_ENUMImpl.KEY_LETTERS;
    }

    @Override
    public S_ENUM self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public S_ENUM oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return S_ENUMImpl.EMPTY_S_ENUM;
    }

}
