package io.ciera.tool.sql.ooaofooa.deployment.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.deployment.Deployment;
import io.ciera.tool.sql.ooaofooa.deployment.DeploymentSet;
import io.ciera.tool.sql.ooaofooa.deployment.TerminatorSet;
import io.ciera.tool.sql.ooaofooa.deployment.impl.TerminatorSetImpl;
import io.ciera.tool.sql.ooaofooa.packageableelement.PackageableElementSet;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.PackageableElementSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class DeploymentSetImpl extends InstanceSet<DeploymentSet,Deployment> implements DeploymentSet {

    public DeploymentSetImpl() {
    }

    public DeploymentSetImpl(Comparator<? super Deployment> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        for ( Deployment deployment : this ) deployment.setDescrip( m_Descrip );
    }
    @Override
    public void setName( String m_Name ) throws XtumlException {
        for ( Deployment deployment : this ) deployment.setName( m_Name );
    }
    @Override
    public void setDeployment_ID( UniqueId ref_Deployment_ID ) throws XtumlException {
        for ( Deployment deployment : this ) deployment.setDeployment_ID( ref_Deployment_ID );
    }
    @Override
    public void setKey_Lett( String m_Key_Lett ) throws XtumlException {
        for ( Deployment deployment : this ) deployment.setKey_Lett( m_Key_Lett );
    }


    // selections
    @Override
    public TerminatorSet R1650_Terminator() throws XtumlException {
        TerminatorSet terminatorset = new TerminatorSetImpl();
        for ( Deployment deployment : this ) terminatorset.addAll( deployment.R1650_Terminator() );
        return terminatorset;
    }
    @Override
    public PackageableElementSet R8001_is_a_PackageableElement() throws XtumlException {
        PackageableElementSet packageableelementset = new PackageableElementSetImpl();
        for ( Deployment deployment : this ) packageableelementset.add( deployment.R8001_is_a_PackageableElement() );
        return packageableelementset;
    }


    @Override
    public Deployment nullElement() {
        return DeploymentImpl.EMPTY_DEPLOYMENT;
    }

    @Override
    public DeploymentSet emptySet() {
      return new DeploymentSetImpl();
    }

    @Override
    public DeploymentSet emptySet(Comparator<? super Deployment> comp) {
      return new DeploymentSetImpl(comp);
    }

    @Override
    public List<Deployment> elements() {
        Deployment[] elements = toArray(new Deployment[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
