package io.ciera.tool.sql.ooaofooa.constants.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.constants.ConstantSpecification;
import io.ciera.tool.sql.ooaofooa.constants.ConstantSpecificationSet;
import io.ciera.tool.sql.ooaofooa.constants.SymbolicConstantSet;
import io.ciera.tool.sql.ooaofooa.constants.impl.SymbolicConstantSetImpl;
import io.ciera.tool.sql.ooaofooa.packageableelement.PackageableElementSet;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.PackageableElementSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class ConstantSpecificationSetImpl extends InstanceSet<ConstantSpecificationSet,ConstantSpecification> implements ConstantSpecificationSet {

    public ConstantSpecificationSetImpl() {
    }

    public ConstantSpecificationSetImpl(Comparator<? super ConstantSpecification> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        for ( ConstantSpecification constantspecification : this ) constantspecification.setDescrip( m_Descrip );
    }
    @Override
    public void setInformalGroupName( String m_InformalGroupName ) throws XtumlException {
        for ( ConstantSpecification constantspecification : this ) constantspecification.setInformalGroupName( m_InformalGroupName );
    }
    @Override
    public void setConstant_Spec_ID( UniqueId ref_Constant_Spec_ID ) throws XtumlException {
        for ( ConstantSpecification constantspecification : this ) constantspecification.setConstant_Spec_ID( ref_Constant_Spec_ID );
    }


    // selections
    @Override
    public SymbolicConstantSet R1504_contains_SymbolicConstant() throws XtumlException {
        SymbolicConstantSet symbolicconstantset = new SymbolicConstantSetImpl();
        for ( ConstantSpecification constantspecification : this ) symbolicconstantset.addAll( constantspecification.R1504_contains_SymbolicConstant() );
        return symbolicconstantset;
    }
    @Override
    public PackageableElementSet R8001_is_a_PackageableElement() throws XtumlException {
        PackageableElementSet packageableelementset = new PackageableElementSetImpl();
        for ( ConstantSpecification constantspecification : this ) packageableelementset.add( constantspecification.R8001_is_a_PackageableElement() );
        return packageableelementset;
    }


    @Override
    public ConstantSpecification nullElement() {
        return ConstantSpecificationImpl.EMPTY_CONSTANTSPECIFICATION;
    }

    @Override
    public ConstantSpecificationSet emptySet() {
      return new ConstantSpecificationSetImpl();
    }

    @Override
    public ConstantSpecificationSet emptySet(Comparator<? super ConstantSpecification> comp) {
      return new ConstantSpecificationSetImpl(comp);
    }

    @Override
    public List<ConstantSpecification> elements() {
        return Arrays.asList(toArray(new ConstantSpecification[0]));
    }

}
