package io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.Satisfaction;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedProvision;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.ImportedProvisionInSatisfaction;
import io.ciera.tool.sql.ooaofooa.component.componentlibrary.impl.ImportedProvisionImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.SatisfactionImpl;


public class ImportedProvisionInSatisfactionImpl extends ModelInstance<ImportedProvisionInSatisfaction,Sql> implements ImportedProvisionInSatisfaction {

    public static final String KEY_LETTERS = "CL_IPINS";
    public static final ImportedProvisionInSatisfaction EMPTY_IMPORTEDPROVISIONINSATISFACTION = new EmptyImportedProvisionInSatisfaction();

    private Sql context;

    // constructors
    private ImportedProvisionInSatisfactionImpl( Sql context ) {
        this.context = context;
        ref_Satisfaction_Id = UniqueId.random();
        ref_ImportedProvision_Id = UniqueId.random();
        R4705_provides_satisfaction_through_Satisfaction_inst = SatisfactionImpl.EMPTY_SATISFACTION;
        R4705_satisfaction_made_with_ImportedProvision_inst = ImportedProvisionImpl.EMPTY_IMPORTEDPROVISION;
    }

    private ImportedProvisionInSatisfactionImpl( Sql context, UniqueId instanceId, UniqueId ref_Satisfaction_Id, UniqueId ref_ImportedProvision_Id ) {
        super(instanceId);
        this.context = context;
        this.ref_Satisfaction_Id = ref_Satisfaction_Id;
        this.ref_ImportedProvision_Id = ref_ImportedProvision_Id;
        R4705_provides_satisfaction_through_Satisfaction_inst = SatisfactionImpl.EMPTY_SATISFACTION;
        R4705_satisfaction_made_with_ImportedProvision_inst = ImportedProvisionImpl.EMPTY_IMPORTEDPROVISION;
    }

    public static ImportedProvisionInSatisfaction create( Sql context ) throws XtumlException {
        ImportedProvisionInSatisfaction newImportedProvisionInSatisfaction = new ImportedProvisionInSatisfactionImpl( context );
        if ( context.addInstance( newImportedProvisionInSatisfaction ) ) {
            newImportedProvisionInSatisfaction.getRunContext().addChange(new InstanceCreatedDelta(newImportedProvisionInSatisfaction, KEY_LETTERS));
            return newImportedProvisionInSatisfaction;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ImportedProvisionInSatisfaction create( Sql context, UniqueId ref_Satisfaction_Id, UniqueId ref_ImportedProvision_Id ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Satisfaction_Id, ref_ImportedProvision_Id);
    }

    public static ImportedProvisionInSatisfaction create( Sql context, UniqueId instanceId, UniqueId ref_Satisfaction_Id, UniqueId ref_ImportedProvision_Id ) throws XtumlException {
        ImportedProvisionInSatisfaction newImportedProvisionInSatisfaction = new ImportedProvisionInSatisfactionImpl( context, instanceId, ref_Satisfaction_Id, ref_ImportedProvision_Id );
        if ( context.addInstance( newImportedProvisionInSatisfaction ) ) {
            return newImportedProvisionInSatisfaction;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Satisfaction_Id;
    @Override
    public UniqueId getSatisfaction_Id() throws XtumlException {
        checkLiving();
        return ref_Satisfaction_Id;
    }
    @Override
    public void setSatisfaction_Id(UniqueId ref_Satisfaction_Id) throws XtumlException {
        checkLiving();
        if (ref_Satisfaction_Id.inequality( this.ref_Satisfaction_Id)) {
            final UniqueId oldValue = this.ref_Satisfaction_Id;
            this.ref_Satisfaction_Id = ref_Satisfaction_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Satisfaction_Id", oldValue, this.ref_Satisfaction_Id));
        }
    }
    private UniqueId ref_ImportedProvision_Id;
    @Override
    public UniqueId getImportedProvision_Id() throws XtumlException {
        checkLiving();
        return ref_ImportedProvision_Id;
    }
    @Override
    public void setImportedProvision_Id(UniqueId ref_ImportedProvision_Id) throws XtumlException {
        checkLiving();
        if (ref_ImportedProvision_Id.inequality( this.ref_ImportedProvision_Id)) {
            final UniqueId oldValue = this.ref_ImportedProvision_Id;
            this.ref_ImportedProvision_Id = ref_ImportedProvision_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_ImportedProvision_Id", oldValue, this.ref_ImportedProvision_Id));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSatisfaction_Id(), getImportedProvision_Id());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Satisfaction R4705_provides_satisfaction_through_Satisfaction_inst;
    @Override
    public void setR4705_provides_satisfaction_through_Satisfaction( Satisfaction inst ) {
        R4705_provides_satisfaction_through_Satisfaction_inst = inst;
    }
    @Override
    public Satisfaction R4705_provides_satisfaction_through_Satisfaction() throws XtumlException {
        return R4705_provides_satisfaction_through_Satisfaction_inst;
    }
    private ImportedProvision R4705_satisfaction_made_with_ImportedProvision_inst;
    @Override
    public void setR4705_satisfaction_made_with_ImportedProvision( ImportedProvision inst ) {
        R4705_satisfaction_made_with_ImportedProvision_inst = inst;
    }
    @Override
    public ImportedProvision R4705_satisfaction_made_with_ImportedProvision() throws XtumlException {
        return R4705_satisfaction_made_with_ImportedProvision_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ImportedProvisionInSatisfaction self() {
        return this;
    }

    @Override
    public ImportedProvisionInSatisfaction oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_IMPORTEDPROVISIONINSATISFACTION;
    }

}

class EmptyImportedProvisionInSatisfaction extends ModelInstance<ImportedProvisionInSatisfaction,Sql> implements ImportedProvisionInSatisfaction {

    // attributes
    public UniqueId getSatisfaction_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSatisfaction_Id( UniqueId ref_Satisfaction_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getImportedProvision_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setImportedProvision_Id( UniqueId ref_ImportedProvision_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Satisfaction R4705_provides_satisfaction_through_Satisfaction() {
        return SatisfactionImpl.EMPTY_SATISFACTION;
    }
    @Override
    public ImportedProvision R4705_satisfaction_made_with_ImportedProvision() {
        return ImportedProvisionImpl.EMPTY_IMPORTEDPROVISION;
    }


    @Override
    public String getKeyLetters() {
        return ImportedProvisionInSatisfactionImpl.KEY_LETTERS;
    }

    @Override
    public ImportedProvisionInSatisfaction self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ImportedProvisionInSatisfaction oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ImportedProvisionInSatisfactionImpl.EMPTY_IMPORTEDPROVISIONINSATISFACTION;
    }

}
