package io.ciera.tool.sql.ooaofooa.body.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.ACT_SMT;
import io.ciera.tool.sql.ooaofooa.body.Block;
import io.ciera.tool.sql.ooaofooa.body.ElseIfStmt;
import io.ciera.tool.sql.ooaofooa.body.ElseIfStmtSet;
import io.ciera.tool.sql.ooaofooa.body.ElseStmt;
import io.ciera.tool.sql.ooaofooa.body.IfStmt;
import io.ciera.tool.sql.ooaofooa.body.impl.ACT_SMTImpl;
import io.ciera.tool.sql.ooaofooa.body.impl.BlockImpl;
import io.ciera.tool.sql.ooaofooa.body.impl.ElseIfStmtImpl;
import io.ciera.tool.sql.ooaofooa.body.impl.ElseIfStmtSetImpl;
import io.ciera.tool.sql.ooaofooa.body.impl.ElseStmtImpl;
import io.ciera.tool.sql.ooaofooa.value.Value;
import io.ciera.tool.sql.ooaofooa.value.impl.ValueImpl;


public class IfStmtImpl extends ModelInstance<IfStmt,Sql> implements IfStmt {

    public static final String KEY_LETTERS = "ACT_IF";
    public static final IfStmt EMPTY_IFSTMT = new EmptyIfStmt();

    private Sql context;

    // constructors
    private IfStmtImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        ref_Block_ID = UniqueId.random();
        ref_Value_ID = UniqueId.random();
        ref_Elif_Statement_ID = UniqueId.random();
        ref_Else_Statement_ID = UniqueId.random();
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R607_controls_Block_inst = BlockImpl.EMPTY_BLOCK;
        R625_test_result_Value_inst = ValueImpl.EMPTY_VALUE;
        R682_has_ElseIfStmt_set = new ElseIfStmtSetImpl();
        R683_has_ElseStmt_inst = ElseStmtImpl.EMPTY_ELSESTMT;
        R690_was_executing_when_halted_ElseIfStmt_inst = ElseIfStmtImpl.EMPTY_ELSEIFSTMT;
        R692_was_executing_when_halted_ElseStmt_inst = ElseStmtImpl.EMPTY_ELSESTMT;
    }

    private IfStmtImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Block_ID, UniqueId ref_Value_ID, UniqueId ref_Elif_Statement_ID, UniqueId ref_Else_Statement_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        this.ref_Block_ID = ref_Block_ID;
        this.ref_Value_ID = ref_Value_ID;
        this.ref_Elif_Statement_ID = ref_Elif_Statement_ID;
        this.ref_Else_Statement_ID = ref_Else_Statement_ID;
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R607_controls_Block_inst = BlockImpl.EMPTY_BLOCK;
        R625_test_result_Value_inst = ValueImpl.EMPTY_VALUE;
        R682_has_ElseIfStmt_set = new ElseIfStmtSetImpl();
        R683_has_ElseStmt_inst = ElseStmtImpl.EMPTY_ELSESTMT;
        R690_was_executing_when_halted_ElseIfStmt_inst = ElseIfStmtImpl.EMPTY_ELSEIFSTMT;
        R692_was_executing_when_halted_ElseStmt_inst = ElseStmtImpl.EMPTY_ELSESTMT;
    }

    public static IfStmt create( Sql context ) throws XtumlException {
        IfStmt newIfStmt = new IfStmtImpl( context );
        if ( context.addInstance( newIfStmt ) ) {
            newIfStmt.getRunContext().addChange(new InstanceCreatedDelta(newIfStmt, KEY_LETTERS));
            return newIfStmt;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static IfStmt create( Sql context, UniqueId ref_Statement_ID, UniqueId ref_Block_ID, UniqueId ref_Value_ID, UniqueId ref_Elif_Statement_ID, UniqueId ref_Else_Statement_ID ) throws XtumlException {
        return create(context, UniqueId.random(), ref_Statement_ID, ref_Block_ID, ref_Value_ID, ref_Elif_Statement_ID, ref_Else_Statement_ID);
    }

    public static IfStmt create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Block_ID, UniqueId ref_Value_ID, UniqueId ref_Elif_Statement_ID, UniqueId ref_Else_Statement_ID ) throws XtumlException {
        IfStmt newIfStmt = new IfStmtImpl( context, instanceId, ref_Statement_ID, ref_Block_ID, ref_Value_ID, ref_Elif_Statement_ID, ref_Else_Statement_ID );
        if ( context.addInstance( newIfStmt ) ) {
            return newIfStmt;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public void setStatement_ID(UniqueId ref_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Statement_ID.inequality( this.ref_Statement_ID)) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
            if ( !R682_has_ElseIfStmt().isEmpty() ) R682_has_ElseIfStmt().setIf_Statement_ID( ref_Statement_ID );
            if ( !R683_has_ElseStmt().isEmpty() ) R683_has_ElseStmt().setIf_Statement_ID( ref_Statement_ID );
        }
    }
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
        return ref_Statement_ID;
    }
    private UniqueId ref_Block_ID;
    @Override
    public void setBlock_ID(UniqueId ref_Block_ID) throws XtumlException {
        checkLiving();
        if (ref_Block_ID.inequality( this.ref_Block_ID)) {
            final UniqueId oldValue = this.ref_Block_ID;
            this.ref_Block_ID = ref_Block_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Block_ID", oldValue, this.ref_Block_ID));
        }
    }
    @Override
    public UniqueId getBlock_ID() throws XtumlException {
        checkLiving();
        return ref_Block_ID;
    }
    private UniqueId ref_Value_ID;
    @Override
    public void setValue_ID(UniqueId ref_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Value_ID.inequality( this.ref_Value_ID)) {
            final UniqueId oldValue = this.ref_Value_ID;
            this.ref_Value_ID = ref_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Value_ID", oldValue, this.ref_Value_ID));
        }
    }
    @Override
    public UniqueId getValue_ID() throws XtumlException {
        checkLiving();
        return ref_Value_ID;
    }
    private UniqueId ref_Elif_Statement_ID;
    @Override
    public UniqueId getElif_Statement_ID() throws XtumlException {
        checkLiving();
        return ref_Elif_Statement_ID;
    }
    @Override
    public void setElif_Statement_ID(UniqueId ref_Elif_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Elif_Statement_ID.inequality( this.ref_Elif_Statement_ID)) {
            final UniqueId oldValue = this.ref_Elif_Statement_ID;
            this.ref_Elif_Statement_ID = ref_Elif_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Elif_Statement_ID", oldValue, this.ref_Elif_Statement_ID));
        }
    }
    private UniqueId ref_Else_Statement_ID;
    @Override
    public UniqueId getElse_Statement_ID() throws XtumlException {
        checkLiving();
        return ref_Else_Statement_ID;
    }
    @Override
    public void setElse_Statement_ID(UniqueId ref_Else_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Else_Statement_ID.inequality( this.ref_Else_Statement_ID)) {
            final UniqueId oldValue = this.ref_Else_Statement_ID;
            this.ref_Else_Statement_ID = ref_Else_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Else_Statement_ID", oldValue, this.ref_Else_Statement_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ACT_SMT R603_is_a_ACT_SMT_inst;
    @Override
    public void setR603_is_a_ACT_SMT( ACT_SMT inst ) {
        R603_is_a_ACT_SMT_inst = inst;
    }
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() throws XtumlException {
        return R603_is_a_ACT_SMT_inst;
    }
    private Block R607_controls_Block_inst;
    @Override
    public void setR607_controls_Block( Block inst ) {
        R607_controls_Block_inst = inst;
    }
    @Override
    public Block R607_controls_Block() throws XtumlException {
        return R607_controls_Block_inst;
    }
    private Value R625_test_result_Value_inst;
    @Override
    public void setR625_test_result_Value( Value inst ) {
        R625_test_result_Value_inst = inst;
    }
    @Override
    public Value R625_test_result_Value() throws XtumlException {
        return R625_test_result_Value_inst;
    }
    private ElseIfStmtSet R682_has_ElseIfStmt_set;
    @Override
    public void addR682_has_ElseIfStmt( ElseIfStmt inst ) {
        R682_has_ElseIfStmt_set.add(inst);
    }
    @Override
    public void removeR682_has_ElseIfStmt( ElseIfStmt inst ) {
        R682_has_ElseIfStmt_set.remove(inst);
    }
    @Override
    public ElseIfStmtSet R682_has_ElseIfStmt() throws XtumlException {
        return R682_has_ElseIfStmt_set;
    }
    private ElseStmt R683_has_ElseStmt_inst;
    @Override
    public void setR683_has_ElseStmt( ElseStmt inst ) {
        R683_has_ElseStmt_inst = inst;
    }
    @Override
    public ElseStmt R683_has_ElseStmt() throws XtumlException {
        return R683_has_ElseStmt_inst;
    }
    private ElseIfStmt R690_was_executing_when_halted_ElseIfStmt_inst;
    @Override
    public void setR690_was_executing_when_halted_ElseIfStmt( ElseIfStmt inst ) {
        R690_was_executing_when_halted_ElseIfStmt_inst = inst;
    }
    @Override
    public ElseIfStmt R690_was_executing_when_halted_ElseIfStmt() throws XtumlException {
        return R690_was_executing_when_halted_ElseIfStmt_inst;
    }
    private ElseStmt R692_was_executing_when_halted_ElseStmt_inst;
    @Override
    public void setR692_was_executing_when_halted_ElseStmt( ElseStmt inst ) {
        R692_was_executing_when_halted_ElseStmt_inst = inst;
    }
    @Override
    public ElseStmt R692_was_executing_when_halted_ElseStmt() throws XtumlException {
        return R692_was_executing_when_halted_ElseStmt_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public IfStmt self() {
        return this;
    }

    @Override
    public IfStmt oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_IFSTMT;
    }

}

class EmptyIfStmt extends ModelInstance<IfStmt,Sql> implements IfStmt {

    // attributes
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBlock_ID( UniqueId ref_Block_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getBlock_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getElif_Statement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setElif_Statement_ID( UniqueId ref_Elif_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getElse_Statement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setElse_Statement_ID( UniqueId ref_Else_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() {
        return ACT_SMTImpl.EMPTY_ACT_SMT;
    }
    @Override
    public Block R607_controls_Block() {
        return BlockImpl.EMPTY_BLOCK;
    }
    @Override
    public Value R625_test_result_Value() {
        return ValueImpl.EMPTY_VALUE;
    }
    @Override
    public ElseIfStmtSet R682_has_ElseIfStmt() {
        return (new ElseIfStmtSetImpl());
    }
    @Override
    public ElseStmt R683_has_ElseStmt() {
        return ElseStmtImpl.EMPTY_ELSESTMT;
    }
    @Override
    public ElseIfStmt R690_was_executing_when_halted_ElseIfStmt() {
        return ElseIfStmtImpl.EMPTY_ELSEIFSTMT;
    }
    @Override
    public ElseStmt R692_was_executing_when_halted_ElseStmt() {
        return ElseStmtImpl.EMPTY_ELSESTMT;
    }


    @Override
    public String getKeyLetters() {
        return IfStmtImpl.KEY_LETTERS;
    }

    @Override
    public IfStmt self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public IfStmt oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return IfStmtImpl.EMPTY_IFSTMT;
    }

}
