package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.loader.AttributeLoader;
import io.ciera.tool.sql.loader.AttributeLoaderSet;
import io.ciera.tool.sql.loader.ClassInstanceLoader;
import io.ciera.tool.sql.loader.EventInstanceLoader;
import io.ciera.tool.sql.loader.InstanceLoader;
import io.ciera.tool.sql.loader.PopulationLoader;
import io.ciera.tool.sql.loader.TimerInstanceLoader;
import io.ciera.tool.sql.loader.impl.AttributeLoaderSetImpl;
import io.ciera.tool.sql.loader.impl.ClassInstanceLoaderImpl;
import io.ciera.tool.sql.loader.impl.EventInstanceLoaderImpl;
import io.ciera.tool.sql.loader.impl.PopulationLoaderImpl;
import io.ciera.tool.sql.loader.impl.TimerInstanceLoaderImpl;


public class InstanceLoaderImpl extends ModelInstance<InstanceLoader,Sql> implements InstanceLoader {

    public static final String KEY_LETTERS = "Z_InstanceLoader";
    public static final InstanceLoader EMPTY_INSTANCELOADER = new EmptyInstanceLoader();

    private Sql context;

    // constructors
    private InstanceLoaderImpl( Sql context ) {
        this.context = context;
        ref_loader_name = "";
        ref_loader_package = "";
        m_class_name = "";
        R3005_invoked_by_PopulationLoader_inst = PopulationLoaderImpl.EMPTY_POPULATIONLOADER;
        R3006_loads_data_value_using_AttributeLoader_set = new AttributeLoaderSetImpl();
        R3016_is_a_ClassInstanceLoader_inst = ClassInstanceLoaderImpl.EMPTY_CLASSINSTANCELOADER;
        R3016_is_a_EventInstanceLoader_inst = EventInstanceLoaderImpl.EMPTY_EVENTINSTANCELOADER;
        R3016_is_a_TimerInstanceLoader_inst = TimerInstanceLoaderImpl.EMPTY_TIMERINSTANCELOADER;
    }

    private InstanceLoaderImpl( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String m_class_name ) {
        super(instanceId);
        this.context = context;
        this.ref_loader_name = ref_loader_name;
        this.ref_loader_package = ref_loader_package;
        this.m_class_name = m_class_name;
        R3005_invoked_by_PopulationLoader_inst = PopulationLoaderImpl.EMPTY_POPULATIONLOADER;
        R3006_loads_data_value_using_AttributeLoader_set = new AttributeLoaderSetImpl();
        R3016_is_a_ClassInstanceLoader_inst = ClassInstanceLoaderImpl.EMPTY_CLASSINSTANCELOADER;
        R3016_is_a_EventInstanceLoader_inst = EventInstanceLoaderImpl.EMPTY_EVENTINSTANCELOADER;
        R3016_is_a_TimerInstanceLoader_inst = TimerInstanceLoaderImpl.EMPTY_TIMERINSTANCELOADER;
    }

    public static InstanceLoader create( Sql context ) throws XtumlException {
        InstanceLoader newInstanceLoader = new InstanceLoaderImpl( context );
        if ( context.addInstance( newInstanceLoader ) ) {
            newInstanceLoader.getRunContext().addChange(new InstanceCreatedDelta(newInstanceLoader, KEY_LETTERS));
            return newInstanceLoader;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static InstanceLoader create( Sql context, String ref_loader_name, String ref_loader_package, String m_class_name ) throws XtumlException {
        return create(context, UniqueId.random(), ref_loader_name, ref_loader_package, m_class_name);
    }

    public static InstanceLoader create( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String m_class_name ) throws XtumlException {
        InstanceLoader newInstanceLoader = new InstanceLoaderImpl( context, instanceId, ref_loader_name, ref_loader_package, m_class_name );
        if ( context.addInstance( newInstanceLoader ) ) {
            return newInstanceLoader;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_loader_name;
    @Override
    public void setLoader_name(String ref_loader_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_loader_name, this.ref_loader_name)) {
            final String oldValue = this.ref_loader_name;
            this.ref_loader_name = ref_loader_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_name", oldValue, this.ref_loader_name));
            if ( !R3016_is_a_EventInstanceLoader().isEmpty() ) R3016_is_a_EventInstanceLoader().setLoader_name( ref_loader_name );
            if ( !R3016_is_a_TimerInstanceLoader().isEmpty() ) R3016_is_a_TimerInstanceLoader().setLoader_name( ref_loader_name );
            if ( !R3016_is_a_ClassInstanceLoader().isEmpty() ) R3016_is_a_ClassInstanceLoader().setLoader_name( ref_loader_name );
            if ( !R3006_loads_data_value_using_AttributeLoader().isEmpty() ) R3006_loads_data_value_using_AttributeLoader().setLoader_name( ref_loader_name );
        }
    }
    @Override
    public String getLoader_name() throws XtumlException {
        checkLiving();
        return ref_loader_name;
    }
    private String ref_loader_package;
    @Override
    public void setLoader_package(String ref_loader_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_loader_package, this.ref_loader_package)) {
            final String oldValue = this.ref_loader_package;
            this.ref_loader_package = ref_loader_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_package", oldValue, this.ref_loader_package));
            if ( !R3016_is_a_ClassInstanceLoader().isEmpty() ) R3016_is_a_ClassInstanceLoader().setLoader_package( ref_loader_package );
            if ( !R3016_is_a_TimerInstanceLoader().isEmpty() ) R3016_is_a_TimerInstanceLoader().setLoader_package( ref_loader_package );
            if ( !R3016_is_a_EventInstanceLoader().isEmpty() ) R3016_is_a_EventInstanceLoader().setLoader_package( ref_loader_package );
            if ( !R3006_loads_data_value_using_AttributeLoader().isEmpty() ) R3006_loads_data_value_using_AttributeLoader().setLoader_package( ref_loader_package );
        }
    }
    @Override
    public String getLoader_package() throws XtumlException {
        checkLiving();
        return ref_loader_package;
    }
    private String m_class_name;
    @Override
    public void setClass_name(String m_class_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_class_name, this.m_class_name)) {
            final String oldValue = this.m_class_name;
            this.m_class_name = m_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_class_name", oldValue, this.m_class_name));
            if ( !R3016_is_a_ClassInstanceLoader().isEmpty() ) R3016_is_a_ClassInstanceLoader().setClass_name( m_class_name );
            if ( !R3006_loads_data_value_using_AttributeLoader().isEmpty() ) R3006_loads_data_value_using_AttributeLoader().setClass_name( m_class_name );
            if ( !R3016_is_a_TimerInstanceLoader().isEmpty() ) R3016_is_a_TimerInstanceLoader().setClass_name( m_class_name );
            if ( !R3016_is_a_EventInstanceLoader().isEmpty() ) R3016_is_a_EventInstanceLoader().setEvt_class_name( m_class_name );
        }
    }
    @Override
    public String getClass_name() throws XtumlException {
        checkLiving();
        return m_class_name;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getLoader_name(), getLoader_package(), getClass_name());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        ClassInstanceLoader classinstanceloader = self().R3016_is_a_ClassInstanceLoader();
        if ( !classinstanceloader.isEmpty() ) {
            classinstanceloader.render();
        }
        else {
            EventInstanceLoader eventinstanceloader = self().R3016_is_a_EventInstanceLoader();
            if ( !eventinstanceloader.isEmpty() ) {
                eventinstanceloader.render();
            }
            else {
                TimerInstanceLoader timerinstanceloader = self().R3016_is_a_TimerInstanceLoader();
                if ( !timerinstanceloader.isEmpty() ) {
                    timerinstanceloader.render();
                }
                else {
                    throw new XtumlException("No subtype selected");
                }
            }
        }
    }



    // static operations


    // events


    // selections
    private PopulationLoader R3005_invoked_by_PopulationLoader_inst;
    @Override
    public void setR3005_invoked_by_PopulationLoader( PopulationLoader inst ) {
        R3005_invoked_by_PopulationLoader_inst = inst;
    }
    @Override
    public PopulationLoader R3005_invoked_by_PopulationLoader() throws XtumlException {
        return R3005_invoked_by_PopulationLoader_inst;
    }
    private AttributeLoaderSet R3006_loads_data_value_using_AttributeLoader_set;
    @Override
    public void addR3006_loads_data_value_using_AttributeLoader( AttributeLoader inst ) {
        R3006_loads_data_value_using_AttributeLoader_set.add(inst);
    }
    @Override
    public void removeR3006_loads_data_value_using_AttributeLoader( AttributeLoader inst ) {
        R3006_loads_data_value_using_AttributeLoader_set.remove(inst);
    }
    @Override
    public AttributeLoaderSet R3006_loads_data_value_using_AttributeLoader() throws XtumlException {
        return R3006_loads_data_value_using_AttributeLoader_set;
    }
    private ClassInstanceLoader R3016_is_a_ClassInstanceLoader_inst;
    @Override
    public void setR3016_is_a_ClassInstanceLoader( ClassInstanceLoader inst ) {
        R3016_is_a_ClassInstanceLoader_inst = inst;
    }
    @Override
    public ClassInstanceLoader R3016_is_a_ClassInstanceLoader() throws XtumlException {
        return R3016_is_a_ClassInstanceLoader_inst;
    }
    private EventInstanceLoader R3016_is_a_EventInstanceLoader_inst;
    @Override
    public void setR3016_is_a_EventInstanceLoader( EventInstanceLoader inst ) {
        R3016_is_a_EventInstanceLoader_inst = inst;
    }
    @Override
    public EventInstanceLoader R3016_is_a_EventInstanceLoader() throws XtumlException {
        return R3016_is_a_EventInstanceLoader_inst;
    }
    private TimerInstanceLoader R3016_is_a_TimerInstanceLoader_inst;
    @Override
    public void setR3016_is_a_TimerInstanceLoader( TimerInstanceLoader inst ) {
        R3016_is_a_TimerInstanceLoader_inst = inst;
    }
    @Override
    public TimerInstanceLoader R3016_is_a_TimerInstanceLoader() throws XtumlException {
        return R3016_is_a_TimerInstanceLoader_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public InstanceLoader self() {
        return this;
    }

    @Override
    public InstanceLoader oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_INSTANCELOADER;
    }

}

class EmptyInstanceLoader extends ModelInstance<InstanceLoader,Sql> implements InstanceLoader {

    // attributes
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLoader_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLoader_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setClass_name( String m_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getClass_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public PopulationLoader R3005_invoked_by_PopulationLoader() {
        return PopulationLoaderImpl.EMPTY_POPULATIONLOADER;
    }
    @Override
    public AttributeLoaderSet R3006_loads_data_value_using_AttributeLoader() {
        return (new AttributeLoaderSetImpl());
    }
    @Override
    public ClassInstanceLoader R3016_is_a_ClassInstanceLoader() {
        return ClassInstanceLoaderImpl.EMPTY_CLASSINSTANCELOADER;
    }
    @Override
    public EventInstanceLoader R3016_is_a_EventInstanceLoader() {
        return EventInstanceLoaderImpl.EMPTY_EVENTINSTANCELOADER;
    }
    @Override
    public TimerInstanceLoader R3016_is_a_TimerInstanceLoader() {
        return TimerInstanceLoaderImpl.EMPTY_TIMERINSTANCELOADER;
    }


    @Override
    public String getKeyLetters() {
        return InstanceLoaderImpl.KEY_LETTERS;
    }

    @Override
    public InstanceLoader self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public InstanceLoader oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return InstanceLoaderImpl.EMPTY_INSTANCELOADER;
    }

}
