package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.loader.ClassInstanceLoader;
import io.ciera.tool.sql.loader.ClassInstanceLoaderSet;
import io.ciera.tool.sql.loader.InstanceLoaderSet;
import io.ciera.tool.sql.loader.impl.InstanceLoaderSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class ClassInstanceLoaderSetImpl extends InstanceSet<ClassInstanceLoaderSet,ClassInstanceLoader> implements ClassInstanceLoaderSet {

    public ClassInstanceLoaderSetImpl() {
    }

    public ClassInstanceLoaderSetImpl(Comparator<? super ClassInstanceLoader> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        for ( ClassInstanceLoader classinstanceloader : this ) classinstanceloader.setLoader_name( ref_loader_name );
    }
    @Override
    public void setClass_package( String m_class_package ) throws XtumlException {
        for ( ClassInstanceLoader classinstanceloader : this ) classinstanceloader.setClass_package( m_class_package );
    }
    @Override
    public void setClass_key_letters( String m_class_key_letters ) throws XtumlException {
        for ( ClassInstanceLoader classinstanceloader : this ) classinstanceloader.setClass_key_letters( m_class_key_letters );
    }
    @Override
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        for ( ClassInstanceLoader classinstanceloader : this ) classinstanceloader.setLoader_package( ref_loader_package );
    }
    @Override
    public void setClass_name( String ref_class_name ) throws XtumlException {
        for ( ClassInstanceLoader classinstanceloader : this ) classinstanceloader.setClass_name( ref_class_name );
    }


    // selections
    @Override
    public InstanceLoaderSet R3016_is_a_InstanceLoader() throws XtumlException {
        InstanceLoaderSet instanceloaderset = new InstanceLoaderSetImpl();
        for ( ClassInstanceLoader classinstanceloader : this ) instanceloaderset.add( classinstanceloader.R3016_is_a_InstanceLoader() );
        return instanceloaderset;
    }


    @Override
    public ClassInstanceLoader nullElement() {
        return ClassInstanceLoaderImpl.EMPTY_CLASSINSTANCELOADER;
    }

    @Override
    public ClassInstanceLoaderSet emptySet() {
      return new ClassInstanceLoaderSetImpl();
    }

    @Override
    public ClassInstanceLoaderSet emptySet(Comparator<? super ClassInstanceLoader> comp) {
      return new ClassInstanceLoaderSetImpl(comp);
    }

    @Override
    public List<ClassInstanceLoader> elements() {
        return Arrays.asList(toArray(new ClassInstanceLoader[0]));
    }

}
