package io.ciera.tool.sql.loader.associationserializerloader.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.loader.associationserializerloader.MultipleReferrerAssoc;
import io.ciera.tool.sql.loader.associationserializerloader.ReferringClassProxy;
import io.ciera.tool.sql.loader.associationserializerloader.impl.MultipleReferrerAssocImpl;


public class ReferringClassProxyImpl extends ModelInstance<ReferringClassProxy,Sql> implements ReferringClassProxy {

    public static final String KEY_LETTERS = "ReferringClassProxy";
    public static final ReferringClassProxy EMPTY_REFERRINGCLASSPROXY = new EmptyReferringClassProxy();

    private Sql context;

    // constructors
    private ReferringClassProxyImpl( Sql context ) {
        this.context = context;
        ref_rel_num = 0;
        m_referring_class_name = "";
        m_reference_name = "";
        m_rel_name = "";
        R3036_renders_code_for_both_IDs_using_MultipleReferrerAssoc_inst = MultipleReferrerAssocImpl.EMPTY_MULTIPLEREFERRERASSOC;
    }

    private ReferringClassProxyImpl( Sql context, UniqueId instanceId, int ref_rel_num, String m_referring_class_name, String m_reference_name, String m_rel_name ) {
        super(instanceId);
        this.context = context;
        this.ref_rel_num = ref_rel_num;
        this.m_referring_class_name = m_referring_class_name;
        this.m_reference_name = m_reference_name;
        this.m_rel_name = m_rel_name;
        R3036_renders_code_for_both_IDs_using_MultipleReferrerAssoc_inst = MultipleReferrerAssocImpl.EMPTY_MULTIPLEREFERRERASSOC;
    }

    public static ReferringClassProxy create( Sql context ) throws XtumlException {
        ReferringClassProxy newReferringClassProxy = new ReferringClassProxyImpl( context );
        if ( context.addInstance( newReferringClassProxy ) ) {
            newReferringClassProxy.getRunContext().addChange(new InstanceCreatedDelta(newReferringClassProxy, KEY_LETTERS));
            return newReferringClassProxy;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ReferringClassProxy create( Sql context, int ref_rel_num, String m_referring_class_name, String m_reference_name, String m_rel_name ) throws XtumlException {
        return create(context, UniqueId.random(), ref_rel_num, m_referring_class_name, m_reference_name, m_rel_name);
    }

    public static ReferringClassProxy create( Sql context, UniqueId instanceId, int ref_rel_num, String m_referring_class_name, String m_reference_name, String m_rel_name ) throws XtumlException {
        ReferringClassProxy newReferringClassProxy = new ReferringClassProxyImpl( context, instanceId, ref_rel_num, m_referring_class_name, m_reference_name, m_rel_name );
        if ( context.addInstance( newReferringClassProxy ) ) {
            return newReferringClassProxy;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private int ref_rel_num;
    @Override
    public void setRel_num(int ref_rel_num) throws XtumlException {
        checkLiving();
        if (ref_rel_num != this.ref_rel_num) {
            final int oldValue = this.ref_rel_num;
            this.ref_rel_num = ref_rel_num;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_rel_num", oldValue, this.ref_rel_num));
        }
    }
    @Override
    public int getRel_num() throws XtumlException {
        checkLiving();
        return ref_rel_num;
    }
    private String m_referring_class_name;
    @Override
    public void setReferring_class_name(String m_referring_class_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_referring_class_name, this.m_referring_class_name)) {
            final String oldValue = this.m_referring_class_name;
            this.m_referring_class_name = m_referring_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_referring_class_name", oldValue, this.m_referring_class_name));
        }
    }
    @Override
    public String getReferring_class_name() throws XtumlException {
        checkLiving();
        return m_referring_class_name;
    }
    private String m_reference_name;
    @Override
    public String getReference_name() throws XtumlException {
        checkLiving();
        return m_reference_name;
    }
    @Override
    public void setReference_name(String m_reference_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_reference_name, this.m_reference_name)) {
            final String oldValue = this.m_reference_name;
            this.m_reference_name = m_reference_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_reference_name", oldValue, this.m_reference_name));
        }
    }
    private String m_rel_name;
    @Override
    public String getRel_name() throws XtumlException {
        checkLiving();
        return m_rel_name;
    }
    @Override
    public void setRel_name(String m_rel_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_rel_name, this.m_rel_name)) {
            final String oldValue = this.m_rel_name;
            this.m_rel_name = m_rel_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_rel_name", oldValue, this.m_rel_name));
        }
    }


    // instance identifiers

    // operations


    // static operations


    // events


    // selections
    private MultipleReferrerAssoc R3036_renders_code_for_both_IDs_using_MultipleReferrerAssoc_inst;
    @Override
    public void setR3036_renders_code_for_both_IDs_using_MultipleReferrerAssoc( MultipleReferrerAssoc inst ) {
        R3036_renders_code_for_both_IDs_using_MultipleReferrerAssoc_inst = inst;
    }
    @Override
    public MultipleReferrerAssoc R3036_renders_code_for_both_IDs_using_MultipleReferrerAssoc() throws XtumlException {
        return R3036_renders_code_for_both_IDs_using_MultipleReferrerAssoc_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ReferringClassProxy self() {
        return this;
    }

    @Override
    public ReferringClassProxy oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_REFERRINGCLASSPROXY;
    }

}

class EmptyReferringClassProxy extends ModelInstance<ReferringClassProxy,Sql> implements ReferringClassProxy {

    // attributes
    public void setRel_num( int ref_rel_num ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getRel_num() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setReferring_class_name( String m_referring_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getReferring_class_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getReference_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setReference_name( String m_reference_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getRel_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRel_name( String m_rel_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public MultipleReferrerAssoc R3036_renders_code_for_both_IDs_using_MultipleReferrerAssoc() {
        return MultipleReferrerAssocImpl.EMPTY_MULTIPLEREFERRERASSOC;
    }


    @Override
    public String getKeyLetters() {
        return ReferringClassProxyImpl.KEY_LETTERS;
    }

    @Override
    public ReferringClassProxy self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ReferringClassProxy oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ReferringClassProxyImpl.EMPTY_REFERRINGCLASSPROXY;
    }

}
