package io.ciera.tool.sql.loader.associationserializerloader.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.ActionHome;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.loader.PopulationLoader;
import io.ciera.tool.sql.loader.associationserializerloader.AssociationSerializerLoader;
import io.ciera.tool.sql.loader.associationserializerloader.MultipleReferrerAssoc;
import io.ciera.tool.sql.loader.associationserializerloader.ReferringClassProxy;
import io.ciera.tool.sql.loader.associationserializerloader.ReferringClassProxySet;
import io.ciera.tool.sql.loader.associationserializerloader.SingleReferrerAssoc;
import io.ciera.tool.sql.loader.associationserializerloader.impl.AssociationSerializerLoaderImpl;
import io.ciera.tool.sql.loader.associationserializerloader.impl.MultipleReferrerAssocImpl;
import io.ciera.tool.sql.loader.associationserializerloader.impl.SingleReferrerAssocImpl;
import io.ciera.tool.sql.loader.impl.PopulationLoaderImpl;

import java.util.Iterator;


public class AssociationSerializerLoaderImpl extends ModelInstance<AssociationSerializerLoader,Sql> implements AssociationSerializerLoader {

    public static final String KEY_LETTERS = "AssociationSerializerLoader";
    public static final AssociationSerializerLoader EMPTY_ASSOCIATIONSERIALIZERLOADER = new EmptyAssociationSerializerLoader();

    private Sql context;

    // constructors
    private AssociationSerializerLoaderImpl( Sql context ) {
        this.context = context;
        ref_loader_name = "";
        ref_loader_package = "";
        m_rel_num = 0;
        R3019_renders_for_PopulationLoader_inst = PopulationLoaderImpl.EMPTY_POPULATIONLOADER;
        R3029_is_a_MultipleReferrerAssoc_inst = MultipleReferrerAssocImpl.EMPTY_MULTIPLEREFERRERASSOC;
        R3029_is_a_SingleReferrerAssoc_inst = SingleReferrerAssocImpl.EMPTY_SINGLEREFERRERASSOC;
    }

    private AssociationSerializerLoaderImpl( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, int m_rel_num ) {
        super(instanceId);
        this.context = context;
        this.ref_loader_name = ref_loader_name;
        this.ref_loader_package = ref_loader_package;
        this.m_rel_num = m_rel_num;
        R3019_renders_for_PopulationLoader_inst = PopulationLoaderImpl.EMPTY_POPULATIONLOADER;
        R3029_is_a_MultipleReferrerAssoc_inst = MultipleReferrerAssocImpl.EMPTY_MULTIPLEREFERRERASSOC;
        R3029_is_a_SingleReferrerAssoc_inst = SingleReferrerAssocImpl.EMPTY_SINGLEREFERRERASSOC;
    }

    public static AssociationSerializerLoader create( Sql context ) throws XtumlException {
        AssociationSerializerLoader newAssociationSerializerLoader = new AssociationSerializerLoaderImpl( context );
        if ( context.addInstance( newAssociationSerializerLoader ) ) {
            newAssociationSerializerLoader.getRunContext().addChange(new InstanceCreatedDelta(newAssociationSerializerLoader, KEY_LETTERS));
            return newAssociationSerializerLoader;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static AssociationSerializerLoader create( Sql context, String ref_loader_name, String ref_loader_package, int m_rel_num ) throws XtumlException {
        return create(context, UniqueId.random(), ref_loader_name, ref_loader_package, m_rel_num);
    }

    public static AssociationSerializerLoader create( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, int m_rel_num ) throws XtumlException {
        AssociationSerializerLoader newAssociationSerializerLoader = new AssociationSerializerLoaderImpl( context, instanceId, ref_loader_name, ref_loader_package, m_rel_num );
        if ( context.addInstance( newAssociationSerializerLoader ) ) {
            return newAssociationSerializerLoader;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_loader_name;
    @Override
    public String getLoader_name() throws XtumlException {
        checkLiving();
        return ref_loader_name;
    }
    @Override
    public void setLoader_name(String ref_loader_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_loader_name, this.ref_loader_name)) {
            final String oldValue = this.ref_loader_name;
            this.ref_loader_name = ref_loader_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_name", oldValue, this.ref_loader_name));
        }
    }
    private String ref_loader_package;
    @Override
    public String getLoader_package() throws XtumlException {
        checkLiving();
        return ref_loader_package;
    }
    @Override
    public void setLoader_package(String ref_loader_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_loader_package, this.ref_loader_package)) {
            final String oldValue = this.ref_loader_package;
            this.ref_loader_package = ref_loader_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_package", oldValue, this.ref_loader_package));
        }
    }
    private int m_rel_num;
    @Override
    public int getRel_num() throws XtumlException {
        checkLiving();
        return m_rel_num;
    }
    @Override
    public void setRel_num(int m_rel_num) throws XtumlException {
        checkLiving();
        if (m_rel_num != this.m_rel_num) {
            final int oldValue = this.m_rel_num;
            this.m_rel_num = m_rel_num;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_rel_num", oldValue, this.m_rel_num));
            if ( !R3029_is_a_SingleReferrerAssoc().isEmpty() ) R3029_is_a_SingleReferrerAssoc().setRel_num( m_rel_num );
            if ( !R3029_is_a_MultipleReferrerAssoc().isEmpty() ) R3029_is_a_MultipleReferrerAssoc().setRel_num( m_rel_num );
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getLoader_name(), getLoader_package());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }
    @Override
    public IInstanceIdentifier getId2() {
        try {
            return new InstanceIdentifier(getRel_num());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render_invocation() throws XtumlException {
        String rnum_str = context().STRING().itoa( self().getRel_num() );
        SingleReferrerAssoc srefferer = self().R3029_is_a_SingleReferrerAssoc();
        if ( !srefferer.isEmpty() ) {
            String class_name = srefferer.getReferring_class_name();
            context().T().include( "loader/t.linkserializer.invoke.java", class_name, rnum_str );
        }
        else {
            MultipleReferrerAssoc mrefferer = self().R3029_is_a_MultipleReferrerAssoc();
            ReferringClassProxySet referrers = mrefferer.R3036_holds_referring_data_for_ReferringClassProxy();
            ReferringClassProxy referrer;
            for ( Iterator<ReferringClassProxy> _referrer_iter = referrers.elements().iterator(); _referrer_iter.hasNext(); ) {
                referrer = _referrer_iter.next();
                String class_name = referrer.getReferring_class_name();
                context().T().include( "loader/t.linkserializer.invoke.java", class_name, rnum_str );
            }
        }
    }

    @Override
    public void render_relate() throws XtumlException {
        SingleReferrerAssoc singleref = self().R3029_is_a_SingleReferrerAssoc();
        if ( !singleref.isEmpty() ) {
            singleref.render_relate();
        }
        else {
            MultipleReferrerAssoc multiref = self().R3029_is_a_MultipleReferrerAssoc();
            multiref.render_relate();
        }
    }

    @Override
    public void render_serialize() throws XtumlException {
        SingleReferrerAssoc singleref = self().R3029_is_a_SingleReferrerAssoc();
        if ( !singleref.isEmpty() ) {
            singleref.render_serialize();
        }
        else {
            MultipleReferrerAssoc multiref = self().R3029_is_a_MultipleReferrerAssoc();
            multiref.render_serialize();
        }
    }



    // static operations
    public static class CLASS extends ActionHome<Sql> {

        public CLASS( Sql context ) {
            super( context );
        }

        public AssociationSerializerLoader create( final int p_rel_num,  final PopulationLoader p_addto ) throws XtumlException {
            AssociationSerializerLoader assoc_serializer = AssociationSerializerLoaderImpl.create( context() );
            assoc_serializer.setRel_num(p_rel_num);
            PopulationLoader loader = p_addto;
            context().relate_R3019_AssociationSerializerLoader_renders_for_PopulationLoader( assoc_serializer, loader );
            return assoc_serializer;
        }



    }


    // events


    // selections
    private PopulationLoader R3019_renders_for_PopulationLoader_inst;
    @Override
    public void setR3019_renders_for_PopulationLoader( PopulationLoader inst ) {
        R3019_renders_for_PopulationLoader_inst = inst;
    }
    @Override
    public PopulationLoader R3019_renders_for_PopulationLoader() throws XtumlException {
        return R3019_renders_for_PopulationLoader_inst;
    }
    private MultipleReferrerAssoc R3029_is_a_MultipleReferrerAssoc_inst;
    @Override
    public void setR3029_is_a_MultipleReferrerAssoc( MultipleReferrerAssoc inst ) {
        R3029_is_a_MultipleReferrerAssoc_inst = inst;
    }
    @Override
    public MultipleReferrerAssoc R3029_is_a_MultipleReferrerAssoc() throws XtumlException {
        return R3029_is_a_MultipleReferrerAssoc_inst;
    }
    private SingleReferrerAssoc R3029_is_a_SingleReferrerAssoc_inst;
    @Override
    public void setR3029_is_a_SingleReferrerAssoc( SingleReferrerAssoc inst ) {
        R3029_is_a_SingleReferrerAssoc_inst = inst;
    }
    @Override
    public SingleReferrerAssoc R3029_is_a_SingleReferrerAssoc() throws XtumlException {
        return R3029_is_a_SingleReferrerAssoc_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public AssociationSerializerLoader self() {
        return this;
    }

    @Override
    public AssociationSerializerLoader oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ASSOCIATIONSERIALIZERLOADER;
    }

}

class EmptyAssociationSerializerLoader extends ModelInstance<AssociationSerializerLoader,Sql> implements AssociationSerializerLoader {

    // attributes
    public String getLoader_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLoader_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getRel_num() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRel_num( int m_rel_num ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render_invocation() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_relate() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_serialize() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public PopulationLoader R3019_renders_for_PopulationLoader() {
        return PopulationLoaderImpl.EMPTY_POPULATIONLOADER;
    }
    @Override
    public MultipleReferrerAssoc R3029_is_a_MultipleReferrerAssoc() {
        return MultipleReferrerAssocImpl.EMPTY_MULTIPLEREFERRERASSOC;
    }
    @Override
    public SingleReferrerAssoc R3029_is_a_SingleReferrerAssoc() {
        return SingleReferrerAssocImpl.EMPTY_SINGLEREFERRERASSOC;
    }


    @Override
    public String getKeyLetters() {
        return AssociationSerializerLoaderImpl.KEY_LETTERS;
    }

    @Override
    public AssociationSerializerLoader self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public AssociationSerializerLoader oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return AssociationSerializerLoaderImpl.EMPTY_ASSOCIATIONSERIALIZERLOADER;
    }

}
