package io.ciera.tool.sql.architecture.type.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.InstSet;
import io.ciera.tool.sql.architecture.classes.ModelInst;
import io.ciera.tool.sql.architecture.classes.impl.InstSetImpl;
import io.ciera.tool.sql.architecture.classes.impl.ModelInstImpl;
import io.ciera.tool.sql.architecture.file.File;
import io.ciera.tool.sql.architecture.type.ArrayTypeReference;
import io.ciera.tool.sql.architecture.type.BasicTypeReference;
import io.ciera.tool.sql.architecture.type.BuiltInType;
import io.ciera.tool.sql.architecture.type.EnumeratedType;
import io.ciera.tool.sql.architecture.type.Type;
import io.ciera.tool.sql.architecture.type.TypeReference;
import io.ciera.tool.sql.architecture.type.TypeReferenceSet;
import io.ciera.tool.sql.architecture.type.UnresolvedType;
import io.ciera.tool.sql.architecture.type.UserDefinedType;
import io.ciera.tool.sql.architecture.type.UserDefinedTypeSet;
import io.ciera.tool.sql.architecture.type.impl.BuiltInTypeImpl;
import io.ciera.tool.sql.architecture.type.impl.EnumeratedTypeImpl;
import io.ciera.tool.sql.architecture.type.impl.TypeReferenceSetImpl;
import io.ciera.tool.sql.architecture.type.impl.UnresolvedTypeImpl;
import io.ciera.tool.sql.architecture.type.impl.UserDefinedTypeImpl;
import io.ciera.tool.sql.architecture.type.impl.UserDefinedTypeSetImpl;
import io.ciera.tool.sql.loader.GeneralLoader;
import io.ciera.tool.sql.loader.GeneralSerializer;
import io.ciera.tool.sql.loader.impl.GeneralLoaderImpl;
import io.ciera.tool.sql.loader.impl.GeneralSerializerImpl;
import io.ciera.tool.sql.ooaofooa.domain.DataType;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeImpl;

import java.util.Iterator;

import types.ImportType;


public class TypeImpl extends ModelInstance<Type,Sql> implements Type {

    public static final String KEY_LETTERS = "Type";
    public static final Type EMPTY_TYPE = new EmptyType();

    private Sql context;

    // constructors
    private TypeImpl( Sql context ) {
        this.context = context;
        m_name = "";
        m_package = "";
        m_default_value = "";
        R3013_GeneralLoader_inst = GeneralLoaderImpl.EMPTY_GENERALLOADER;
        R3014_GeneralSerializer_inst = GeneralSerializerImpl.EMPTY_GENERALSERIALIZER;
        R3800_referred_to_by_TypeReference_set = new TypeReferenceSetImpl();
        R3802_used_as_base_for_UserDefinedType_set = new UserDefinedTypeSetImpl();
        R407_is_a_BuiltInType_inst = BuiltInTypeImpl.EMPTY_BUILTINTYPE;
        R407_is_a_EnumeratedType_inst = EnumeratedTypeImpl.EMPTY_ENUMERATEDTYPE;
        R407_is_a_InstSet_inst = InstSetImpl.EMPTY_INSTSET;
        R407_is_a_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R407_is_a_UnresolvedType_inst = UnresolvedTypeImpl.EMPTY_UNRESOLVEDTYPE;
        R407_is_a_UserDefinedType_inst = UserDefinedTypeImpl.EMPTY_USERDEFINEDTYPE;
        R423_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
    }

    private TypeImpl( Sql context, UniqueId instanceId, String m_name, String m_package, String m_default_value ) {
        super(instanceId);
        this.context = context;
        this.m_name = m_name;
        this.m_package = m_package;
        this.m_default_value = m_default_value;
        R3013_GeneralLoader_inst = GeneralLoaderImpl.EMPTY_GENERALLOADER;
        R3014_GeneralSerializer_inst = GeneralSerializerImpl.EMPTY_GENERALSERIALIZER;
        R3800_referred_to_by_TypeReference_set = new TypeReferenceSetImpl();
        R3802_used_as_base_for_UserDefinedType_set = new UserDefinedTypeSetImpl();
        R407_is_a_BuiltInType_inst = BuiltInTypeImpl.EMPTY_BUILTINTYPE;
        R407_is_a_EnumeratedType_inst = EnumeratedTypeImpl.EMPTY_ENUMERATEDTYPE;
        R407_is_a_InstSet_inst = InstSetImpl.EMPTY_INSTSET;
        R407_is_a_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R407_is_a_UnresolvedType_inst = UnresolvedTypeImpl.EMPTY_UNRESOLVEDTYPE;
        R407_is_a_UserDefinedType_inst = UserDefinedTypeImpl.EMPTY_USERDEFINEDTYPE;
        R423_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
    }

    public static Type create( Sql context ) throws XtumlException {
        Type newType = new TypeImpl( context );
        if ( context.addInstance( newType ) ) {
            newType.getRunContext().addChange(new InstanceCreatedDelta(newType, KEY_LETTERS));
            return newType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Type create( Sql context, String m_name, String m_package, String m_default_value ) throws XtumlException {
        return create(context, UniqueId.random(), m_name, m_package, m_default_value);
    }

    public static Type create( Sql context, UniqueId instanceId, String m_name, String m_package, String m_default_value ) throws XtumlException {
        Type newType = new TypeImpl( context, instanceId, m_name, m_package, m_default_value );
        if ( context.addInstance( newType ) ) {
            return newType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String m_name;
    @Override
    public void setName(String m_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_name, this.m_name)) {
            final String oldValue = this.m_name;
            this.m_name = m_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_name", oldValue, this.m_name));
            if ( !R3802_used_as_base_for_UserDefinedType().isEmpty() ) R3802_used_as_base_for_UserDefinedType().setBase_type_name( m_name );
            if ( !R407_is_a_InstSet().isEmpty() ) R407_is_a_InstSet().setName( m_name );
            if ( !R3800_referred_to_by_TypeReference().isEmpty() ) R3800_referred_to_by_TypeReference().setType_name( m_name );
            if ( !R407_is_a_EnumeratedType().isEmpty() ) R407_is_a_EnumeratedType().setName( m_name );
            if ( !R3014_GeneralSerializer().isEmpty() ) R3014_GeneralSerializer().setType_name( m_name );
            if ( !R407_is_a_UserDefinedType().isEmpty() ) R407_is_a_UserDefinedType().setName( m_name );
            if ( !R407_is_a_ModelInst().isEmpty() ) R407_is_a_ModelInst().setName( m_name );
            if ( !R407_is_a_UnresolvedType().isEmpty() ) R407_is_a_UnresolvedType().setName( m_name );
            if ( !R3013_GeneralLoader().isEmpty() ) R3013_GeneralLoader().setType_name( m_name );
            if ( !R407_is_a_BuiltInType().isEmpty() ) R407_is_a_BuiltInType().setName( m_name );
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_name;
    }
    private String m_package;
    @Override
    public String getPackage() throws XtumlException {
        checkLiving();
        return m_package;
    }
    @Override
    public void setPackage(String m_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_package, this.m_package)) {
            final String oldValue = this.m_package;
            this.m_package = m_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_package", oldValue, this.m_package));
            if ( !R407_is_a_InstSet().isEmpty() ) R407_is_a_InstSet().setPackage( m_package );
            if ( !R3800_referred_to_by_TypeReference().isEmpty() ) R3800_referred_to_by_TypeReference().setType_package( m_package );
            if ( !R3802_used_as_base_for_UserDefinedType().isEmpty() ) R3802_used_as_base_for_UserDefinedType().setBase_type_package( m_package );
            if ( !R3014_GeneralSerializer().isEmpty() ) R3014_GeneralSerializer().setType_package( m_package );
            if ( !R407_is_a_UnresolvedType().isEmpty() ) R407_is_a_UnresolvedType().setPackage( m_package );
            if ( !R407_is_a_ModelInst().isEmpty() ) R407_is_a_ModelInst().setPackage( m_package );
            if ( !R407_is_a_BuiltInType().isEmpty() ) R407_is_a_BuiltInType().setPackage( m_package );
            if ( !R407_is_a_EnumeratedType().isEmpty() ) R407_is_a_EnumeratedType().setPackage( m_package );
            if ( !R407_is_a_UserDefinedType().isEmpty() ) R407_is_a_UserDefinedType().setPackage( m_package );
            if ( !R3013_GeneralLoader().isEmpty() ) R3013_GeneralLoader().setType_package( m_package );
        }
    }
    private String m_default_value;
    @Override
    public void setDefault_value(String m_default_value) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_default_value, this.m_default_value)) {
            final String oldValue = this.m_default_value;
            this.m_default_value = m_default_value;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_default_value", oldValue, this.m_default_value));
        }
    }
    @Override
    public String getDefault_value() throws XtumlException {
        checkLiving();
        return m_default_value;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getName(), getPackage());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void addToImports( final File p_file,  final ImportType p_type ) throws XtumlException {
        if ( StringUtil.inequality("", self().getPackage()) ) {
            context().addStringToImports( p_file, ( self().getPackage() + "." ) + self().getName(), p_type );
        }
    }

    @Override
    public void dispose() throws XtumlException {
        UnresolvedType unresolved_type = self().R407_is_a_UnresolvedType();
        if ( !unresolved_type.isEmpty() ) {
            unresolved_type.dispose();
        }
        ModelInst obj = self().R407_is_a_ModelInst();
        if ( !obj.isEmpty() ) {
            context().unrelate_R407_ModelInst_is_a_Type( obj, self() );
        }
        InstSet objset = self().R407_is_a_InstSet();
        if ( !objset.isEmpty() ) {
            context().unrelate_R407_InstSet_is_a_Type( objset, self() );
        }
        EnumeratedType edt = self().R407_is_a_EnumeratedType();
        if ( !edt.isEmpty() ) {
            context().unrelate_R407_EnumeratedType_is_a_Type( edt, self() );
        }
        BuiltInType builtin = self().R407_is_a_BuiltInType();
        if ( !builtin.isEmpty() ) {
            context().unrelate_R407_BuiltInType_is_a_Type( builtin, self() );
        }
        TypeReferenceSet type_refs = self().R3800_referred_to_by_TypeReference();
        TypeReference type_ref;
        for ( Iterator<TypeReference> _type_ref_iter = type_refs.elements().iterator(); _type_ref_iter.hasNext(); ) {
            type_ref = _type_ref_iter.next();
            BasicTypeReference basic_ref = type_ref.R3801_is_a_BasicTypeReference();
            if ( !basic_ref.isEmpty() ) {
                context().unrelate_R3801_BasicTypeReference_is_a_TypeReference( basic_ref, type_ref );
                basic_ref.delete();
            }
            ArrayTypeReference array_ref = type_ref.R3801_is_a_ArrayTypeReference();
            if ( !array_ref.isEmpty() ) {
                context().unrelate_R3801_ArrayTypeReference_is_a_TypeReference( array_ref, type_ref );
                array_ref.delete();
            }
            context().unrelate_R3800_TypeReference_based_on_Type( type_ref, self() );
            type_ref.delete();
        }
        self().delete();
    }

    @Override
    public boolean primitive() throws XtumlException {
        boolean primitive = false;
        BuiltInType builtin = self().R407_is_a_BuiltInType();
        if ( !builtin.isEmpty() ) {
            primitive = builtin.getPrimitive();
        }
        return primitive;
    }



    // static operations


    // events


    // selections
    private GeneralLoader R3013_GeneralLoader_inst;
    @Override
    public void setR3013_GeneralLoader( GeneralLoader inst ) {
        R3013_GeneralLoader_inst = inst;
    }
    @Override
    public GeneralLoader R3013_GeneralLoader() throws XtumlException {
        return R3013_GeneralLoader_inst;
    }
    private GeneralSerializer R3014_GeneralSerializer_inst;
    @Override
    public void setR3014_GeneralSerializer( GeneralSerializer inst ) {
        R3014_GeneralSerializer_inst = inst;
    }
    @Override
    public GeneralSerializer R3014_GeneralSerializer() throws XtumlException {
        return R3014_GeneralSerializer_inst;
    }
    private TypeReferenceSet R3800_referred_to_by_TypeReference_set;
    @Override
    public void addR3800_referred_to_by_TypeReference( TypeReference inst ) {
        R3800_referred_to_by_TypeReference_set.add(inst);
    }
    @Override
    public void removeR3800_referred_to_by_TypeReference( TypeReference inst ) {
        R3800_referred_to_by_TypeReference_set.remove(inst);
    }
    @Override
    public TypeReferenceSet R3800_referred_to_by_TypeReference() throws XtumlException {
        return R3800_referred_to_by_TypeReference_set;
    }
    private UserDefinedTypeSet R3802_used_as_base_for_UserDefinedType_set;
    @Override
    public void addR3802_used_as_base_for_UserDefinedType( UserDefinedType inst ) {
        R3802_used_as_base_for_UserDefinedType_set.add(inst);
    }
    @Override
    public void removeR3802_used_as_base_for_UserDefinedType( UserDefinedType inst ) {
        R3802_used_as_base_for_UserDefinedType_set.remove(inst);
    }
    @Override
    public UserDefinedTypeSet R3802_used_as_base_for_UserDefinedType() throws XtumlException {
        return R3802_used_as_base_for_UserDefinedType_set;
    }
    private BuiltInType R407_is_a_BuiltInType_inst;
    @Override
    public void setR407_is_a_BuiltInType( BuiltInType inst ) {
        R407_is_a_BuiltInType_inst = inst;
    }
    @Override
    public BuiltInType R407_is_a_BuiltInType() throws XtumlException {
        return R407_is_a_BuiltInType_inst;
    }
    private EnumeratedType R407_is_a_EnumeratedType_inst;
    @Override
    public void setR407_is_a_EnumeratedType( EnumeratedType inst ) {
        R407_is_a_EnumeratedType_inst = inst;
    }
    @Override
    public EnumeratedType R407_is_a_EnumeratedType() throws XtumlException {
        return R407_is_a_EnumeratedType_inst;
    }
    private InstSet R407_is_a_InstSet_inst;
    @Override
    public void setR407_is_a_InstSet( InstSet inst ) {
        R407_is_a_InstSet_inst = inst;
    }
    @Override
    public InstSet R407_is_a_InstSet() throws XtumlException {
        return R407_is_a_InstSet_inst;
    }
    private ModelInst R407_is_a_ModelInst_inst;
    @Override
    public void setR407_is_a_ModelInst( ModelInst inst ) {
        R407_is_a_ModelInst_inst = inst;
    }
    @Override
    public ModelInst R407_is_a_ModelInst() throws XtumlException {
        return R407_is_a_ModelInst_inst;
    }
    private UnresolvedType R407_is_a_UnresolvedType_inst;
    @Override
    public void setR407_is_a_UnresolvedType( UnresolvedType inst ) {
        R407_is_a_UnresolvedType_inst = inst;
    }
    @Override
    public UnresolvedType R407_is_a_UnresolvedType() throws XtumlException {
        return R407_is_a_UnresolvedType_inst;
    }
    private UserDefinedType R407_is_a_UserDefinedType_inst;
    @Override
    public void setR407_is_a_UserDefinedType( UserDefinedType inst ) {
        R407_is_a_UserDefinedType_inst = inst;
    }
    @Override
    public UserDefinedType R407_is_a_UserDefinedType() throws XtumlException {
        return R407_is_a_UserDefinedType_inst;
    }
    private DataType R423_DataType_inst;
    @Override
    public void setR423_DataType( DataType inst ) {
        R423_DataType_inst = inst;
    }
    @Override
    public DataType R423_DataType() throws XtumlException {
        return R423_DataType_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Type self() {
        return this;
    }

    @Override
    public Type oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_TYPE;
    }

}

class EmptyType extends ModelInstance<Type,Sql> implements Type {

    // attributes
    public void setName( String m_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getPackage() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPackage( String m_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDefault_value( String m_default_value ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDefault_value() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void addToImports( final File p_file,  final ImportType p_type ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void dispose() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public boolean primitive() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public GeneralLoader R3013_GeneralLoader() {
        return GeneralLoaderImpl.EMPTY_GENERALLOADER;
    }
    @Override
    public GeneralSerializer R3014_GeneralSerializer() {
        return GeneralSerializerImpl.EMPTY_GENERALSERIALIZER;
    }
    @Override
    public TypeReferenceSet R3800_referred_to_by_TypeReference() {
        return (new TypeReferenceSetImpl());
    }
    @Override
    public UserDefinedTypeSet R3802_used_as_base_for_UserDefinedType() {
        return (new UserDefinedTypeSetImpl());
    }
    @Override
    public BuiltInType R407_is_a_BuiltInType() {
        return BuiltInTypeImpl.EMPTY_BUILTINTYPE;
    }
    @Override
    public EnumeratedType R407_is_a_EnumeratedType() {
        return EnumeratedTypeImpl.EMPTY_ENUMERATEDTYPE;
    }
    @Override
    public InstSet R407_is_a_InstSet() {
        return InstSetImpl.EMPTY_INSTSET;
    }
    @Override
    public ModelInst R407_is_a_ModelInst() {
        return ModelInstImpl.EMPTY_MODELINST;
    }
    @Override
    public UnresolvedType R407_is_a_UnresolvedType() {
        return UnresolvedTypeImpl.EMPTY_UNRESOLVEDTYPE;
    }
    @Override
    public UserDefinedType R407_is_a_UserDefinedType() {
        return UserDefinedTypeImpl.EMPTY_USERDEFINEDTYPE;
    }
    @Override
    public DataType R423_DataType() {
        return DataTypeImpl.EMPTY_DATATYPE;
    }


    @Override
    public String getKeyLetters() {
        return TypeImpl.KEY_LETTERS;
    }

    @Override
    public Type self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Type oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return TypeImpl.EMPTY_TYPE;
    }

}
