package io.ciera.tool.sql.architecture.type.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.type.BasicTypeReference;
import io.ciera.tool.sql.architecture.type.TypeReference;
import io.ciera.tool.sql.architecture.type.impl.TypeReferenceImpl;


public class BasicTypeReferenceImpl extends ModelInstance<BasicTypeReference,Sql> implements BasicTypeReference {

    public static final String KEY_LETTERS = "BasicTypeReference";
    public static final BasicTypeReference EMPTY_BASICTYPEREFERENCE = new EmptyBasicTypeReference();

    private Sql context;

    // constructors
    private BasicTypeReferenceImpl( Sql context ) {
        this.context = context;
        ref_name = "";
        ref_package = "";
        ref_type_reference_name = "";
        R3801_is_a_TypeReference_inst = TypeReferenceImpl.EMPTY_TYPEREFERENCE;
    }

    private BasicTypeReferenceImpl( Sql context, UniqueId instanceId, String ref_name, String ref_package, String ref_type_reference_name ) {
        super(instanceId);
        this.context = context;
        this.ref_name = ref_name;
        this.ref_package = ref_package;
        this.ref_type_reference_name = ref_type_reference_name;
        R3801_is_a_TypeReference_inst = TypeReferenceImpl.EMPTY_TYPEREFERENCE;
    }

    public static BasicTypeReference create( Sql context ) throws XtumlException {
        BasicTypeReference newBasicTypeReference = new BasicTypeReferenceImpl( context );
        if ( context.addInstance( newBasicTypeReference ) ) {
            newBasicTypeReference.getRunContext().addChange(new InstanceCreatedDelta(newBasicTypeReference, KEY_LETTERS));
            return newBasicTypeReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static BasicTypeReference create( Sql context, String ref_name, String ref_package, String ref_type_reference_name ) throws XtumlException {
        return create(context, UniqueId.random(), ref_name, ref_package, ref_type_reference_name);
    }

    public static BasicTypeReference create( Sql context, UniqueId instanceId, String ref_name, String ref_package, String ref_type_reference_name ) throws XtumlException {
        BasicTypeReference newBasicTypeReference = new BasicTypeReferenceImpl( context, instanceId, ref_name, ref_package, ref_type_reference_name );
        if ( context.addInstance( newBasicTypeReference ) ) {
            return newBasicTypeReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_name;
    @Override
    public void setName(String ref_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_name, this.ref_name)) {
            final String oldValue = this.ref_name;
            this.ref_name = ref_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_name", oldValue, this.ref_name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return ref_name;
    }
    private String ref_package;
    @Override
    public String getPackage() throws XtumlException {
        checkLiving();
        return ref_package;
    }
    @Override
    public void setPackage(String ref_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_package, this.ref_package)) {
            final String oldValue = this.ref_package;
            this.ref_package = ref_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_package", oldValue, this.ref_package));
        }
    }
    private String ref_type_reference_name;
    @Override
    public String getType_reference_name() throws XtumlException {
        checkLiving();
        return ref_type_reference_name;
    }
    @Override
    public void setType_reference_name(String ref_type_reference_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_type_reference_name, this.ref_type_reference_name)) {
            final String oldValue = this.ref_type_reference_name;
            this.ref_type_reference_name = ref_type_reference_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_type_reference_name", oldValue, this.ref_type_reference_name));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getName(), getPackage(), getType_reference_name());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private TypeReference R3801_is_a_TypeReference_inst;
    @Override
    public void setR3801_is_a_TypeReference( TypeReference inst ) {
        R3801_is_a_TypeReference_inst = inst;
    }
    @Override
    public TypeReference R3801_is_a_TypeReference() throws XtumlException {
        return R3801_is_a_TypeReference_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public BasicTypeReference self() {
        return this;
    }

    @Override
    public BasicTypeReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_BASICTYPEREFERENCE;
    }

}

class EmptyBasicTypeReference extends ModelInstance<BasicTypeReference,Sql> implements BasicTypeReference {

    // attributes
    public void setName( String ref_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getPackage() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPackage( String ref_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getType_reference_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setType_reference_name( String ref_type_reference_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public TypeReference R3801_is_a_TypeReference() {
        return TypeReferenceImpl.EMPTY_TYPEREFERENCE;
    }


    @Override
    public String getKeyLetters() {
        return BasicTypeReferenceImpl.KEY_LETTERS;
    }

    @Override
    public BasicTypeReference self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public BasicTypeReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return BasicTypeReferenceImpl.EMPTY_BASICTYPEREFERENCE;
    }

}
